/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.InsertionEndpointApi;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.program.JaxProgram;
import org.eclipse.osee.ats.api.program.ProgramEndpointApi;
import org.eclipse.osee.ats.api.program.ProgramVersions;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.rest.internal.config.BaseConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ProgramEndpointImpl
extends BaseConfigEndpointImpl<JaxProgram>
implements ProgramEndpointApi {
    private final long countryId;

    public ProgramEndpointImpl(AtsApi atsApi) {
        this(atsApi, 0L);
    }

    public ProgramEndpointImpl(AtsApi atsApi, long countryId) {
        super(AtsArtifactTypes.Program, null, atsApi);
        this.countryId = countryId;
    }

    @PUT
    public Response update(JaxProgram jaxProgram) throws Exception {
        ArtifactReadable artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(jaxProgram.getId());
        if (artifact == null) {
            throw new OseeStateException("Artifact with id %d not found", new Object[]{jaxProgram.getIdString()});
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactToken programArt = changes.createArtifact(this.artifactType, jaxProgram.getName(), jaxProgram.getId());
        IAtsProgram program = this.atsApi.getProgramService().getProgramById((ArtifactId)programArt);
        if (!programArt.getName().equals(jaxProgram.getName())) {
            changes.setSoleAttributeValue((IAtsObject)program, (AttributeTypeToken)CoreAttributeTypes.Name, (Object)jaxProgram.getName());
        }
        changes.execute();
        return Response.created((URI)new URI("/" + jaxProgram.getIdString())).build();
    }

    @Override
    public JaxProgram getConfigObject(ArtifactId artifact) {
        JaxProgram jaxProgram = new JaxProgram();
        IAtsProgram program = this.atsApi.getProgramService().getProgramById(artifact);
        jaxProgram.setName(program.getName());
        jaxProgram.setId(program.getId());
        jaxProgram.setActive(program.isActive());
        jaxProgram.setDescription(program.getDescription());
        return jaxProgram;
    }

    @Override
    public List<JaxProgram> getObjects() {
        ArrayList<JaxProgram> configs = new ArrayList<JaxProgram>();
        if (this.countryId == 0L) {
            for (ArtifactToken art : this.atsApi.getQueryService().getArtifacts(this.artifactType)) {
                configs.add(this.getConfigObject((ArtifactId)art));
            }
        } else {
            for (ArtifactToken art : this.atsApi.getRelationResolver().getRelated((ArtifactId)this.atsApi.getQueryService().getArtifact(Long.valueOf(this.countryId)), AtsRelationTypes.CountryToProgram_Program)) {
                JaxProgram program = this.getConfigObject((ArtifactId)art);
                program.setCountryId(this.countryId);
                configs.add(program);
            }
        }
        return configs;
    }

    @Override
    protected void create(JaxProgram jaxProgram, ArtifactId programArtId, IAtsChangeSet changes) {
        ArtifactReadable programArt = (ArtifactReadable)programArtId;
        if (programArt.getRelatedCount(AtsRelationTypes.CountryToProgram_Country) == 0) {
            ArtifactReadable countryArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(Long.valueOf(jaxProgram.getCountryId()));
            changes.relate((ArtifactId)countryArt, AtsRelationTypes.CountryToProgram_Program, (ArtifactId)programArt);
        }
    }

    public InsertionEndpointApi getInsertion(long programId) {
        return new InsertionEndpointImpl(this.atsApi, programId);
    }

    @GET
    @Path(value="version")
    @Produces(value={"application/json"})
    public List<ProgramVersions> getVersions(@Context UriInfo uriInfo) {
        boolean activeOnly = true;
        ArtifactTypeToken artType = AtsArtifactTypes.Program;
        if (uriInfo != null) {
            String artifactTypeId;
            MultivaluedMap qp = uriInfo.getQueryParameters(true);
            String activeStr = (String)qp.getFirst((Object)"activeOnly");
            if (Strings.isValid((String)activeStr)) {
                activeOnly = "true".equals(activeStr);
            }
            if (Strings.isNumeric((String)(artifactTypeId = (String)qp.getFirst((Object)"artifactTypeId")))) {
                artType = this.atsApi.tokenService().getArtifactType(Long.valueOf(artifactTypeId));
            }
        }
        return this.atsApi.getProgramService().getProgramVersions(artType, activeOnly);
    }
}

