/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.branch;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.branch.BranchStatus;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;

public class BranchEnablementData {
    private final IAtsTeamWorkflow teamWf;
    private BranchToken workingBranch;
    private boolean workingBranchInWork;
    private boolean committedBranchExists;
    private boolean disableAll;
    private final AtsApi atsApi;

    public BranchEnablementData(IAtsTeamWorkflow teamArt, AtsApi atsApi) {
        this.teamWf = teamArt;
        this.atsApi = atsApi;
    }

    public void setWorkingBranchInWork(boolean workingBranchInWork) {
        this.workingBranchInWork = workingBranchInWork;
    }

    public void setCommittedBranchExists(boolean committedBranchExists) {
        this.committedBranchExists = committedBranchExists;
    }

    public void setWorkingBranch(BranchToken workingBranch) {
        this.workingBranch = workingBranch;
    }

    public void setDisableAll(boolean disableAll) {
        this.disableAll = disableAll;
    }

    public boolean isWorkingBranchCreationInProgress() {
        return this.atsApi.getBranchService().isWorkingBranchCreationInProgress(this.teamWf) || this.workingBranch.isValid() && this.atsApi.getBranchService().getBranchState((BranchId)this.workingBranch).isCreationInProgress();
    }

    public boolean isWorkingBranchCommitInProgress() {
        return this.atsApi.getBranchService().isWorkingBranchCommitInProgress(this.teamWf) || this.workingBranch.isValid() && this.atsApi.getBranchService().getBranchState((BranchId)this.workingBranch).isCommitInProgress();
    }

    public boolean isWorkingBranchInWork() {
        return this.workingBranchInWork;
    }

    public boolean isCommittedBranchExists() {
        return this.committedBranchExists;
    }

    public boolean isDisableAll() {
        return this.disableAll;
    }

    public BranchToken getWorkingBranch() {
        return this.workingBranch;
    }

    public BranchStatus getBranchStatus() {
        if (this.teamWf != null) {
            if (this.isWorkingBranchCreationInProgress()) {
                return BranchStatus.Changes_NotPermitted__CreationInProgress;
            }
            if (this.isWorkingBranchCommitInProgress()) {
                return BranchStatus.Changes_NotPermitted__CommitInProgress;
            }
            if (this.isCommittedBranchExists()) {
                return BranchStatus.Changes_NotPermitted__BranchCommitted;
            }
            if (this.isWorkingBranchInWork()) {
                return BranchStatus.Changes_InProgress;
            }
        }
        return BranchStatus.Not_Started;
    }

    public String toString() {
        return "BranchEnablementData [workingBranch=" + this.workingBranch + ", workingBranchCreationInProgress=" + this.isWorkingBranchCreationInProgress() + ", workingBranchCommitInProgress=" + this.isWorkingBranchCommitInProgress() + ", workingBranchInWork=" + this.workingBranchInWork + ", committedBranchExists=" + this.committedBranchExists + ", disableAll=" + this.disableAll + "]";
    }
}

