/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.PlatformTypesFilterEndpoint;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class PlatformTypesFilterEndpointImpl
implements PlatformTypesFilterEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final InterfacePlatformTypeApi platformApi;

    public PlatformTypesFilterEndpointImpl(BranchId branch, UserId account, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = account;
        this.branch = branch;
        this.platformApi = interfacePlatformTypeApi;
    }

    private List<AttributeTypeId> createAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceLogicalType);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformType2sComplement);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeAnalogAccuracy);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeBitSize);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeBitsResolution);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeCompRate);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeDefaultValue);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeEnumLiteral);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMaxval);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMinval);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMsbValue);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeUnits);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription);
        return attributes;
    }

    @Override
    public Collection<PlatformTypeToken> getPlatformTypes(String filter) {
        List<AttributeTypeId> attributes = this.createAttributeList();
        try {
            return this.platformApi.getAccessor().getAllByFilter(this.branch, filter, attributes, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public Collection<PlatformTypeToken> getPlatformTypes() {
        try {
            return this.platformApi.getAccessor().getAll(this.branch, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

