/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.export;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.ExportOptions;
import org.eclipse.osee.orcs.SystemProperties;
import org.eclipse.osee.orcs.db.internal.exchange.ExportImportXml;
import org.eclipse.osee.orcs.db.internal.exchange.export.AbstractExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.export.AbstractXmlExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;

public class ManifestExportItem
extends AbstractXmlExportItem {
    private final SystemProperties preferences;
    private final List<AbstractExportItem> exportItems;
    private final PropertyStore options;

    public ManifestExportItem(Log logger, SystemProperties preferences, List<AbstractExportItem> exportItems, PropertyStore options) {
        super(logger, ExportItem.EXPORT_MANIFEST);
        this.preferences = preferences;
        this.exportItems = exportItems;
        this.options = options;
    }

    private void addEntry(Appendable appendable, String fileName, int priority, String source) throws IOException {
        ExportImportXml.openPartialXmlNode(appendable, "entry");
        ExportImportXml.addXmlAttribute(appendable, "id", fileName);
        ExportImportXml.addXmlAttribute(appendable, "priority", priority);
        ExportImportXml.addXmlAttribute(appendable, "source", source);
        ExportImportXml.closePartialXmlNode(appendable);
    }

    @Override
    protected void doWork(Appendable appendable) throws Exception {
        ExportImportXml.openPartialXmlNode(appendable, "export");
        ExportImportXml.addXmlAttribute(appendable, "databaseId", this.preferences.getSystemUuid());
        ExportImportXml.addXmlAttribute(appendable, "exportVersion", OseeCodeVersion.getBundleVersion());
        ExportImportXml.addXmlAttribute(appendable, "exportDate", new Long(new Date().getTime()).toString());
        ExportImportXml.closePartialXmlNode(appendable);
        for (AbstractExportItem relationalItem : this.exportItems) {
            if (((Object)((Object)relationalItem)).equals((Object)this)) continue;
            this.addEntry(appendable, relationalItem.getFileName(), relationalItem.getPriority(), relationalItem.getSource());
        }
        ExportImportXml.openPartialXmlNode(appendable, "options");
        ExportOptions[] exportOptionsArray = ExportOptions.values();
        int n = exportOptionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportOptions exportOption = exportOptionsArray[n2];
            String value = this.options.get(exportOption.name());
            ExportImportXml.addXmlAttribute(appendable, exportOption.name(), value);
            ++n2;
        }
        ExportImportXml.closePartialXmlNode(appendable);
    }
}

