/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.util.MultiplicityState;

public class RelationTypeValidity {
    private final OrcsTokenService tokenService;

    public RelationTypeValidity(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void checkRelationTypeMultiplicity(RelationTypeToken type, Artifact node, RelationSide side, int count) {
        MultiplicityState state = this.getRelationMultiplicityState(type, side, count);
        switch (state) {
            case MAX_VIOLATION: {
                throw new OseeStateException("Relation type [%s] on [%s] exceeds max occurrence rule on [%s]", new Object[]{type, side, node.getExceptionString()});
            }
            case MIN_VIOLATION: {
                throw new OseeStateException("Relation type [%s] on [%s] is less than min occurrence rule on [%s]", new Object[]{type, side, node.getExceptionString()});
            }
        }
    }

    public void checkRelationTypeValid(RelationTypeToken type, Artifact node, RelationSide side) {
        Conditions.checkNotNull((Object)type, (String)"type");
        Conditions.checkNotNull((Object)node, (String)"node");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        ArtifactTypeToken artifactType = node.getArtifactType();
        boolean isValid = this.isRelationTypeValid(type, artifactType, side);
        if (!isValid) {
            throw new OseeArgumentException("Relation validity error for [%s] - ArtifactType [%s] does not belong on side [%s] of relation [%s] - only items of type [%s] are allowed", new Object[]{node.getExceptionString(), artifactType, side.name(), type.getName(), type.getArtifactType(side)});
        }
    }

    public int getMaximumRelationsAllowed(RelationTypeToken type, ArtifactTypeToken artifactType, RelationSide side) {
        Conditions.checkNotNull((Object)type, (String)"relationType");
        Conditions.checkNotNull((Object)artifactType, (String)"artifactType");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        int toReturn = 0;
        if (type.isArtifactTypeAllowed(side, artifactType)) {
            toReturn = type.getMultiplicity().getLimit(side);
        }
        return toReturn;
    }

    public MultiplicityState getRelationMultiplicityState(RelationTypeToken type, RelationSide side, int count) {
        Conditions.checkNotNull((Object)type, (String)"type");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        RelationTypeMultiplicity multiplicity = type.getMultiplicity();
        MultiplicityState toReturn = MultiplicityState.IS_VALID;
        int limit = multiplicity.getLimit(side);
        if (count > limit) {
            toReturn = MultiplicityState.MAX_VIOLATION;
        }
        return toReturn;
    }

    public boolean isRelationTypeValid(RelationTypeToken relationType, ArtifactTypeToken artifactType, RelationSide relationSide) {
        Conditions.checkNotNull((Object)artifactType, (String)"artifactType");
        Conditions.checkNotNull((Object)relationSide, (String)"relationSide");
        return this.getRelationSideMax(relationType, artifactType, relationSide) > 0;
    }

    public List<RelationTypeToken> getValidRelationTypes(ArtifactTypeToken artifactType) {
        Conditions.checkNotNull((Object)artifactType, (String)"artifactType");
        Collection types = this.tokenService.getRelationTypes();
        ArrayList<RelationTypeToken> toReturn = new ArrayList<RelationTypeToken>();
        for (RelationTypeToken relationType : types) {
            if (!this.isTypeAllowed(artifactType, relationType)) continue;
            toReturn.add(relationType);
        }
        return toReturn;
    }

    private boolean isTypeAllowed(ArtifactTypeToken artifactType, RelationTypeToken relationType) {
        boolean result = false;
        RelationSide[] relationSideArray = RelationSide.values();
        int n = relationSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationSide side = relationSideArray[n2];
            int sideMax = this.getRelationSideMax(relationType, artifactType, side);
            if (sideMax > 0) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private int getRelationSideMax(RelationTypeToken relationType, ArtifactTypeToken artifactType, RelationSide relationSide) {
        int toReturn = 0;
        if (relationType.isArtifactTypeAllowed(relationSide, artifactType)) {
            toReturn = relationType.getMultiplicity().getLimit(relationSide);
        }
        return toReturn;
    }
}

