/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public interface IAtsWorkItem
extends IAtsObject {
    public static final IAtsWorkItem SENTINEL = IAtsWorkItem.createSentinel();

    public String getAtsId();

    public IAtsTeamWorkflow getParentTeamWorkflow();

    public IAtsLog getLog();

    public WorkDefinition getWorkDefinition();

    public StateDefinition getStateDefinition();

    public AtsUser getCreatedBy();

    public Date getCreatedDate();

    public AtsUser getCompletedBy();

    public AtsUser getCancelledBy();

    public String getCompletedFromState();

    public String getCancelledFromState();

    public String getArtifactTypeName();

    public Date getCompletedDate();

    public Date getCancelledDate();

    public String getCancelledReason();

    public IAtsAction getParentAction();

    default public boolean isTeamWorkflow() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow});
    }

    default public boolean isDecisionReview() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.DecisionReview});
    }

    default public boolean isPeerReview() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview});
    }

    default public boolean isTask() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task});
    }

    default public boolean isReview() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractReview});
    }

    default public boolean isSprint() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint});
    }

    default public boolean isBacklog() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileBacklog});
    }

    default public boolean isGoal() {
        return this instanceof IAtsGoal;
    }

    default public boolean isInWork() {
        return this.getStateDefinition().isWorking();
    }

    default public boolean isCompleted() {
        return this.getStateDefinition().isCompleted();
    }

    default public boolean isCancelled() {
        return this.getStateDefinition().isCancelled();
    }

    default public boolean isCompletedOrCancelled() {
        return this.isCompleted() || this.isCancelled();
    }

    default public boolean hasAction() {
        return true;
    }

    public void clearCaches();

    default public boolean isInState(IStateToken ... states) {
        IStateToken[] iStateTokenArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            IStateToken state = iStateTokenArray[n2];
            if (this.getCurrentStateName().equals(state.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    default public boolean isNotInState(IStateToken ... states) {
        return !this.isInState(states);
    }

    @Override
    default public Collection<String> getTags() {
        return this.getAtsApi().getAttributeResolver().getAttributesToStringList((ArtifactId)this.getStoreObject(), (AttributeTypeToken)CoreAttributeTypes.StaticId);
    }

    default public void setTags(List<String> tags) {
        throw new UnsupportedOperationException("Invalid method for IAtsWorkItem; use IAtsChangeSet");
    }

    @Override
    default public boolean hasTag(String tag) {
        return this.getTags().contains(tag);
    }

    default public String toStringWithId() {
        String atsId = "";
        try {
            atsId = this.getAtsId();
        }
        catch (Exception ex) {
            atsId = "Exception: " + ex.getLocalizedMessage();
        }
        return String.format("[%s]-[%s]-[%s]", this.getName(), atsId, this.getIdString());
    }

    default public String toStringWithId(int nameTruncateLength) {
        return String.format("[%s]-[%s]-[%s]", Strings.truncate((String)this.getName(), (int)nameTruncateLength, (boolean)true), this.getAtsId(), this.getIdString());
    }

    default public String toStringWithAtsId() {
        return String.format("[%s]-[%s]", this.getName(), this.getAtsId());
    }

    default public boolean isChangeRequest() {
        return this.getArtifactType().inheritsFrom((ArtifactTypeId)AtsArtifactTypes.AbstractChangeRequestWorkflow);
    }

    public String getCurrentStateName();

    public StateType getCurrentStateType();

    public IStateToken getCurrentState();

    public List<AtsUser> getAssignees();

    public List<AtsUser> getImplementers();

    default public Collection<AtsUser> getAssignees(IStateToken state) {
        HashSet<AtsUser> assignees = new HashSet<AtsUser>();
        for (IAtsLogItem item : this.getLog().getLogItems(LogType.Assign)) {
            AtsUser user = this.getUserByUserId(item.getUserId());
            assignees.add(user);
        }
        return assignees;
    }

    public AtsUser getUserByUserId(String var1);

    default public String getAssigneesStr() {
        return Collections.toString((String)"; ", this.getAssignees());
    }

    default public String getAssigneesStr(int length) {
        return Strings.truncate((String)Collections.toString((String)"; ", (Object[])new Object[]{this.getAssigneesStr()}), (int)length);
    }

    default public boolean isUnAssigned() {
        return this.getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER);
    }

    public static IAtsWorkItem createSentinel() {
        final class IAtsWorkItemSentinel
        extends NamedIdBase
        implements IAtsWorkItem {
            IAtsWorkItemSentinel() {
            }

            public ArtifactTypeToken getArtifactType() {
                return null;
            }

            @Override
            public List<AtsUser> getAssignees() {
                return null;
            }

            @Override
            public List<AtsUser> getImplementers() {
                return null;
            }

            @Override
            public String getAtsId() {
                return null;
            }

            @Override
            public IAtsTeamWorkflow getParentTeamWorkflow() {
                return null;
            }

            @Override
            public IAtsLog getLog() {
                return null;
            }

            @Override
            public WorkDefinition getWorkDefinition() {
                return null;
            }

            @Override
            public StateDefinition getStateDefinition() {
                return null;
            }

            @Override
            public AtsUser getCreatedBy() {
                return null;
            }

            @Override
            public Date getCreatedDate() {
                return null;
            }

            @Override
            public AtsUser getCompletedBy() {
                return null;
            }

            @Override
            public AtsUser getCancelledBy() {
                return null;
            }

            @Override
            public String getCompletedFromState() {
                return null;
            }

            @Override
            public String getCancelledFromState() {
                return null;
            }

            @Override
            public String getArtifactTypeName() {
                return null;
            }

            @Override
            public Date getCompletedDate() {
                return null;
            }

            @Override
            public Date getCancelledDate() {
                return null;
            }

            @Override
            public String getCancelledReason() {
                return null;
            }

            @Override
            public IAtsAction getParentAction() {
                return null;
            }

            @Override
            public void clearCaches() {
            }

            @Override
            public AtsApi getAtsApi() {
                return null;
            }

            @Override
            public Collection<WorkType> getWorkTypes() {
                return null;
            }

            @Override
            public boolean isWorkType(WorkType workType) {
                return false;
            }

            @Override
            public Collection<String> getTags() {
                return null;
            }

            @Override
            public boolean hasTag(String tag) {
                return false;
            }

            @Override
            public boolean isSprint() {
                return false;
            }

            @Override
            public String getCurrentStateName() {
                return "";
            }

            @Override
            public StateType getCurrentStateType() {
                return null;
            }

            @Override
            public IStateToken getCurrentState() {
                return null;
            }

            @Override
            public AtsUser getUserByUserId(String userId) {
                return null;
            }
        }
        return new IAtsWorkItemSentinel();
    }
}

