/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeDataTransfer;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.Multiplicity;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.model.AttributeEndpoint;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AttributeEndpointImpl
implements AttributeEndpoint {
    private final QueryBuilder query;
    private final UriInfo uriInfo;
    private final BranchId branch;
    private final ArtifactId artifactId;
    private final OrcsApi orcsApi;

    public AttributeEndpointImpl(ArtifactId artifactId, BranchId branch, OrcsApi orcsApi, QueryBuilder query, UriInfo uriInfo) {
        this.artifactId = artifactId;
        this.query = query;
        this.uriInfo = uriInfo;
        this.branch = branch;
        this.orcsApi = orcsApi;
    }

    public String getAttributesAsHtml(ArtifactId artifactId) {
        ArtifactReadable artifact = (ArtifactReadable)this.query.andId(artifactId).getResults().getExactlyOne();
        HtmlWriter writer = new HtmlWriter(this.uriInfo, this.orcsApi);
        return writer.toHtml((Iterable<? extends Object>)artifact.getAttributes());
    }

    public List<AttributeDataTransfer> getAttributes(ArtifactId artifactId) {
        ArrayList<AttributeDataTransfer> data = new ArrayList<AttributeDataTransfer>();
        QueryBuilder queryBuilder = this.query.andId(artifactId);
        ArtifactReadable exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne();
        ResultSet attributes = exactlyOne.getAttributes();
        for (AttributeReadable item : attributes) {
            data.add(this.getDataFromAttribute(exactlyOne, (AttributeReadable<Object>)item));
        }
        return data;
    }

    private AttributeDataTransfer getDataFromAttribute(ArtifactReadable artifact, AttributeReadable<Object> attribute) {
        AttributeDataTransfer data = new AttributeDataTransfer();
        AttributeTypeToken type = attribute.getAttributeType();
        data.setAttributeName(type.getName());
        data.setAttrId(attribute);
        data.setAttrTypeId((AttributeTypeId)type);
        data.setBaseType(this.getBaseTypeName(type));
        data.setDescription(type.getDescription());
        data.setDisplayHint(type.getDisplayHints().toString());
        data.setExtension(type.getFileExtension());
        data.setGammaId(attribute.getGammaId());
        data.setMediaType(type.getMediaType());
        data.setMultiplicity(this.getMultiplicity(artifact, type));
        data.setValidEnums(this.getValidEnums(type));
        data.setValue(attribute.getValue().toString());
        return data;
    }

    private String getMultiplicity(ArtifactReadable artifact, AttributeTypeToken type) {
        Multiplicity mult = artifact.getArtifactType().getMultiplicity(type);
        return mult.toString();
    }

    private String[] getValidEnums(AttributeTypeToken type) {
        String[] empty = new String[]{"EMPTY"};
        if (type.isEnumerated()) {
            Set enums = type.toEnum().getEnumStrValues();
            if (enums.size() > 0) {
                return enums.toArray(new String[enums.size()]);
            }
            return empty;
        }
        return empty;
    }

    private String getBaseTypeName(AttributeTypeToken type) {
        if (type.isArtifactId()) {
            return "ART_ID";
        }
        if (type.isBoolean()) {
            return "BOOLEAN";
        }
        if (type.isBranchId()) {
            return "BRANCH_ID";
        }
        if (type.isDate()) {
            return "DATE";
        }
        if (type.isDouble()) {
            return "DOUBLE";
        }
        if (type.isEnumerated()) {
            return "ENUM";
        }
        if (type.isInputStream()) {
            return "STREAM";
        }
        if (type.isInteger()) {
            return "INTEGER";
        }
        if (type.isLong()) {
            return "LONG";
        }
        if (type.isString()) {
            return "STRING";
        }
        if (type.isUri()) {
            return "URI";
        }
        if (type.isJavaObject()) {
            return "JAVA_OBJECT";
        }
        return "COMPLEX";
    }

    public Response getAttribute(AttributeId attributeId) {
        return this.getAttributeResponse(attributeId, TransactionId.SENTINEL, false);
    }

    public Response getAttributeWithGammaAsText(AttributeId attributeId, TransactionId transaction) {
        return this.getAttributeResponse(attributeId, transaction, true);
    }

    public Response getAttributeWithGamma(AttributeId attributeId, TransactionId transaction) {
        return this.getAttributeResponse(attributeId, transaction, false);
    }

    private Response getAttributeResponse(final AttributeId attributeId, TransactionId transaction, boolean textOut) {
        Response.ResponseBuilder builder = Response.noContent();
        try {
            ArtifactReadable exactlyOne;
            Optional item;
            QueryBuilder queryBuilder = this.query.andId(this.artifactId);
            if (transaction.isValid()) {
                queryBuilder.fromTransaction(transaction);
            }
            if ((item = Iterables.tryFind((Iterable)(exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne()).getAttributes(), (Predicate)new Predicate<AttributeReadable<Object>>(){

                public boolean apply(AttributeReadable<Object> attribute) {
                    return attributeId.equals(attribute);
                }
            })).isPresent()) {
                Object value = item.get();
                if (value instanceof AttributeReadable) {
                    builder = Response.ok();
                    AttributeReadable attribute = (AttributeReadable)value;
                    String mediaType = attribute.getAttributeType().getMediaType();
                    String fileExtension = attribute.getAttributeType().getFileExtension();
                    if (mediaType.isEmpty() || mediaType.startsWith("text") || textOut) {
                        builder.entity((Object)attribute.getDisplayableString());
                    } else {
                        ResultSet results = exactlyOne.getAttributes((AttributeTypeToken)CoreAttributeTypes.Extension);
                        AttributeReadable extension = (AttributeReadable)results.getOneOrNull();
                        if (extension != null) {
                            fileExtension = extension.getDisplayableString();
                        }
                        Object content = attribute.getValue();
                        builder.entity(content);
                        builder.header("Content-type", (Object)mediaType);
                        String filename = URLEncoder.encode(String.valueOf(exactlyOne.getName()) + "." + fileExtension, "UTF-8");
                        builder.header("Content-Disposition", (Object)("attachment; filename=" + filename));
                    }
                }
            } else {
                builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return builder.build();
    }

    public Response getAttributeTypes() {
        return this.getAttributeTypeResponse();
    }

    public Response getAttributeTypeValues(AttributeTypeToken attributeType) {
        return this.getAttributeTypeResponse(TransactionId.SENTINEL, attributeType);
    }

    public Response getAttributeTypeValuesForTransaction(AttributeTypeToken attributeType, TransactionId transaction) {
        return this.getAttributeTypeResponse(transaction, attributeType);
    }

    private Response getAttributeTypeResponse(TransactionId transaction, AttributeTypeToken attributeType) {
        Response.ResponseBuilder builder;
        block9: {
            builder = Response.noContent();
            try {
                QueryBuilder queryBuilder = this.query.andId(this.artifactId);
                if (transaction.isValid()) {
                    queryBuilder.fromTransaction(transaction);
                }
                ArtifactReadable exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne();
                ArrayList<AttributeReadable> attrs = new ArrayList<AttributeReadable>();
                for (AttributeReadable attr : exactlyOne.getAttributes(attributeType)) {
                    attrs.add(attr);
                }
                if (attrs.size() == 1) {
                    builder = Response.ok();
                    AttributeReadable attribute = (AttributeReadable)attrs.iterator().next();
                    String mediaType = attribute.getAttributeType().getMediaType();
                    String fileExtension = attribute.getAttributeType().getFileExtension();
                    if (mediaType.isEmpty() || mediaType.startsWith("text")) {
                        builder.entity((Object)attribute.getDisplayableString());
                    } else {
                        ResultSet results = exactlyOne.getAttributes((AttributeTypeToken)CoreAttributeTypes.Extension);
                        AttributeReadable extension = (AttributeReadable)results.getOneOrNull();
                        if (extension != null) {
                            fileExtension = extension.getDisplayableString();
                        }
                        Object content = attribute.getValue();
                        builder.entity(content);
                        builder.header("Content-type", (Object)mediaType);
                        String filename = URLEncoder.encode(String.valueOf(exactlyOne.getName()) + "." + fileExtension, "UTF-8");
                        builder.header("Content-Disposition", (Object)("attachment; filename=" + filename));
                    }
                    break block9;
                }
                if (attrs.size() > 1) {
                    String values = Collections.toString((String)"</br>", attrs);
                    return Response.ok((Object)AHTML.simplePage((String)values)).build();
                }
                return Response.ok((Object)AHTML.simplePage((String)String.format("No attributes of type [%s] found.", attributeType))).build();
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return builder.build();
    }

    private Response getAttributeTypeResponse() {
        try {
            QueryBuilder queryBuilder = this.query.andId(this.artifactId);
            ArtifactReadable exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne();
            StringBuilder sb = new StringBuilder();
            sb.append(AHTML.beginMultiColumnTable((int)95));
            sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"Valid Types")}));
            sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{""}));
            for (AttributeTypeToken attrType : exactlyOne.getValidAttributeTypes()) {
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"Name:"), attrType.getName()}));
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"Attribute Type:"), AHTML.getHyperlink((String)String.format("/orcs/branch/%s/artifact/%s/attribute/type/%s", this.branch, this.artifactId, attrType.getIdString()), (String)attrType.getIdString())}));
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{""}));
            }
            sb.append(AHTML.endMultiColumnTable());
            return Response.ok((Object)AHTML.simplePage((String)sb.toString())).build();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }
}

