/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.types;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.types.HealthReportOperation;
import org.eclipse.osee.orcs.rest.model.TypesEndpoint;

public class TypesEndpointImpl
implements TypesEndpoint {
    private final OrcsApi orcsApi;
    private final OrcsTokenService orcsTokenService;
    private final JdbcService jdbcService;

    public TypesEndpointImpl(OrcsApi orcsApi, JdbcService jdbcService) {
        this.orcsApi = Objects.requireNonNull(orcsApi, "orcsApi cannot be null.");
        this.orcsTokenService = Objects.requireNonNull(orcsApi.tokenService(), "orcsApi.tokenService must not be null");
        this.jdbcService = Objects.requireNonNull(jdbcService, "jdbcService cannot be null.");
    }

    public XResultData getHealthReport() {
        HealthReportOperation reportOp = new HealthReportOperation(this.orcsTokenService, this.jdbcService);
        return reportOp.run();
    }

    public List<LinkedHashMap<String, Object>> getServerEnumTypesAndValues() {
        ArrayList<LinkedHashMap<String, Object>> output = new ArrayList<LinkedHashMap<String, Object>>();
        for (AttributeTypeToken attrType : this.orcsTokenService.getAttributeTypes()) {
            if (!attrType.isEnumerated()) continue;
            LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>();
            attributeMap.put("Name", attrType.getName());
            attributeMap.put("Namespace", attrType.getNamespace().getName());
            attributeMap.put("Enum Values", attrType.toEnum().getEnumStrValues());
            output.add(attributeMap);
        }
        return output;
    }
}

