/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.dto.ChangeReportRowDto;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceDifferenceReportApi;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceEnumerationApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimChangeSummary;
import org.eclipse.osee.mim.types.MimChangeSummaryItem;
import org.eclipse.osee.mim.types.MimDifferenceItem;
import org.eclipse.osee.mim.types.MimDifferenceReport;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.FollowRelation;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class InterfaceDifferenceReportApiImpl
implements InterfaceDifferenceReportApi {
    private BranchId branch1;
    private BranchId branch2;
    private final OrcsApi orcsApi;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;
    private final InterfaceMessageApi interfaceMessageApi;
    private final InterfaceSubMessageApi interfaceSubMessageApi;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfacePlatformTypeApi interfacePlatformApi;
    private final InterfaceEnumerationApi interfaceEnumerationApi;
    private Map<ArtifactId, List<ChangeItem>> changeMap;
    private List<ArtifactId> nodeList;
    private List<ArtifactId> connectionList;
    private List<ArtifactId> messageList;
    private List<ArtifactId> submessageList;
    private List<ArtifactId> structureList;
    private List<ArtifactId> elementList;
    private List<ArtifactId> pTypeList;
    private List<ArtifactId> enumList;
    private MimDifferenceReport diffReport;

    InterfaceDifferenceReportApiImpl(OrcsApi orcsApi, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfacePlatformTypeApi interfacePlatformApi, InterfaceEnumerationApi interfaceEnumerationApi) {
        this.orcsApi = orcsApi;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
        this.interfaceMessageApi = interfaceMessageApi;
        this.interfaceSubMessageApi = interfaceSubMessageApi;
        this.interfaceStructureApi = interfaceStructureApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfacePlatformApi = interfacePlatformApi;
        this.interfaceEnumerationApi = interfaceEnumerationApi;
    }

    @Override
    public MimDifferenceReport getDifferenceReport(BranchId branch1, BranchId branch2) {
        this.branch1 = branch1;
        this.branch2 = branch2;
        this.changeMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.diffReport = new MimDifferenceReport();
        this.nodeList = new LinkedList<ArtifactId>();
        this.connectionList = new LinkedList<ArtifactId>();
        this.messageList = new LinkedList<ArtifactId>();
        this.submessageList = new LinkedList<ArtifactId>();
        this.structureList = new LinkedList<ArtifactId>();
        this.elementList = new LinkedList<ArtifactId>();
        this.pTypeList = new LinkedList<ArtifactId>();
        this.enumList = new LinkedList<ArtifactId>();
        TransactionToken sourceTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch1)).getResults().getExactlyOne();
        TransactionToken destinationTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch2)).getResults().getExactlyOne();
        List changes = this.orcsApi.getBranchOps().compareBranch(sourceTx, destinationTx);
        changes.stream().filter(c -> c.getChangeType().getId() == ChangeType.Artifact.getId() || c.getChangeType().getId() == ChangeType.Relation.getId()).forEach(c -> this.addChangeToMap((ChangeItem)c));
        for (ChangeItem change : changes) {
            List<ChangeItem> list = this.getChangeList(change.getArtId());
            list.add(change);
            this.changeMap.put(change.getArtId(), list);
        }
        this.processNodes(this.nodeList);
        this.processConnections(this.connectionList);
        this.processMessages(this.messageList);
        this.processSubMessages(this.submessageList);
        this.processStructures(this.structureList);
        this.processElements(this.elementList, ArtifactId.SENTINEL);
        this.processPlatformTypes(this.pTypeList);
        this.processEnumerations(this.enumList);
        return this.diffReport;
    }

    private void processNodes(List<ArtifactId> nodeIds) {
        List nodes = (List)this.interfaceNodeApi.get(this.branch1, this.getArtIdsForBranch(nodeIds, this.branch1));
        nodes.addAll(this.interfaceNodeApi.get(this.branch2, this.getArtIdsForBranch(nodeIds, this.branch2)));
        for (InterfaceNode node : nodes) {
            List<ChangeItem> changeItems = this.changeMap.get(node.getArtifactId());
            if (!node.isValid()) continue;
            this.diffReport.addItem(node, changeItems);
            this.diffReport.getNodes().add(node.getArtifactId());
        }
    }

    private void processConnections(List<ArtifactId> connectionIds) {
        List connections = (List)this.interfaceConnectionApi.get(this.branch1, this.getArtIdsForBranch(connectionIds, this.branch1));
        connections.addAll(this.interfaceConnectionApi.get(this.branch2, this.getArtIdsForBranch(connectionIds, this.branch2)));
        for (InterfaceConnection connection : connections) {
            if (!connection.isValid()) continue;
            this.diffReport.addItem(connection, this.getChangeList(connection.getArtifactId()));
            this.diffReport.getConnections().add(connection.getArtifactId());
        }
    }

    private void processMessages(List<ArtifactId> messageIds) {
        List parentRelations = FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceConnectionMessage_Connection, CoreRelationTypes.InterfaceConnectionTransportType_TransportType});
        List messages = (List)this.interfaceMessageApi.get(this.branch1, this.getArtIdsForBranch(messageIds, this.branch1), parentRelations);
        messages.addAll(this.interfaceMessageApi.get(this.branch2, this.getArtIdsForBranch(messageIds, this.branch2), parentRelations));
        for (InterfaceMessageToken message : messages) {
            if (!message.isValid()) continue;
            this.diffReport.addItem(message, this.getChangeList(message.getArtifactId()));
            this.addMessageParent(message);
            this.diffReport.getMessages().add(message.getArtifactId());
        }
    }

    private void processSubMessages(List<ArtifactId> submessageIds) {
        List parentRelations = FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection, CoreRelationTypes.InterfaceConnectionTransportType_TransportType});
        List subMessages = (List)this.interfaceSubMessageApi.get(this.branch1, this.getArtIdsForBranch(submessageIds, this.branch1), parentRelations);
        subMessages.addAll(this.interfaceSubMessageApi.get(this.branch2, this.getArtIdsForBranch(submessageIds, this.branch2), parentRelations));
        for (InterfaceSubMessageToken subMessage : subMessages) {
            if (!subMessage.isValid()) continue;
            this.diffReport.addItem(subMessage, this.getChangeList(subMessage.getArtifactId()));
            this.addSubMessageParents(subMessage);
            this.diffReport.getSubMessages().add(subMessage.getArtifactId());
        }
    }

    private void processStructures(List<ArtifactId> structureIds) {
        List parentRelations = FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection, CoreRelationTypes.InterfaceConnectionTransportType_TransportType});
        List structures = (List)this.interfaceStructureApi.get(this.branch1, this.getArtIdsForBranch(structureIds, this.branch1), parentRelations);
        structures.addAll(this.interfaceStructureApi.get(this.branch2, this.getArtIdsForBranch(structureIds, this.branch2), parentRelations));
        for (InterfaceStructureToken structure : structures) {
            if (!structure.isValid()) continue;
            this.diffReport.addItem(structure, this.getChangeList(structure.getArtifactId()));
            this.addStructureParents(structure);
            this.diffReport.getStructures().add(structure.getArtifactId());
        }
    }

    private void processElements(List<ArtifactId> elementIds, ArtifactId typeId) {
        LinkedList<FollowRelation> parentRelations = new LinkedList<FollowRelation>();
        parentRelations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType));
        parentRelations.addAll(FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection, CoreRelationTypes.InterfaceConnectionTransportType_TransportType}));
        List elements = (List)this.interfaceElementApi.get(this.branch1, this.getArtIdsForBranch(elementIds, this.branch1), parentRelations);
        elements.addAll(this.interfaceElementApi.get(this.branch2, this.getArtIdsForBranch(elementIds, this.branch2), parentRelations));
        for (InterfaceStructureElementToken element : elements) {
            this.addElementParents(element);
            this.processElement(element.getArtifactId(), typeId, element);
        }
    }

    private void processElement(ArtifactId elementId, ArtifactId typeId, InterfaceStructureElementToken element) {
        if (element.isValid()) {
            this.diffReport.addItem(element, this.getChangeList(elementId));
            if (typeId.isValid()) {
                this.diffReport.addItem(element, this.getChangeList(typeId));
            }
            if (!this.diffReport.hasParents(elementId)) {
                this.addElementParents(element);
            }
            if (!this.diffReport.getElements().contains(elementId)) {
                this.diffReport.getElements().add(elementId);
            }
        }
    }

    private void processPlatformTypes(List<ArtifactId> pTypeIds) {
        LinkedList<FollowRelation> relations = new LinkedList<FollowRelation>();
        relations.add(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_Element));
        relations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType));
        relations.addAll(FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection, CoreRelationTypes.InterfaceConnectionTransportType_TransportType}));
        List<PlatformTypeToken> pTypes = this.interfacePlatformApi.get(this.branch1, this.getArtIdsForBranch(pTypeIds, this.branch1), relations);
        pTypes.addAll(this.interfacePlatformApi.get(this.branch2, this.getArtIdsForBranch(pTypeIds, this.branch2), relations));
        for (PlatformTypeToken pType : pTypes) {
            if (!pType.isValid()) continue;
            this.diffReport.addItem(pType, this.getChangeList(pType.getArtifactId()));
            List<?> elements = this.getFromArtifactReadable(pType.getArtifactReadable(), CoreRelationTypes.InterfaceElementPlatformType_Element, InterfaceStructureElementToken.class);
            for (InterfaceStructureElementToken element : elements) {
                this.processElement(ArtifactId.valueOf((Long)element.getId()), pType.getArtifactId(), element);
            }
        }
    }

    private void processEnumerations(List<ArtifactId> enumIds) {
        LinkedList<FollowRelation> relations = new LinkedList<FollowRelation>();
        relations.add(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceEnumeration_EnumerationSet));
        relations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceEnumeration_EnumerationState));
        relations.add(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfacePlatformTypeEnumeration_Element));
        relations.add(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_Element));
        relations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType));
        relations.addAll(FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection, CoreRelationTypes.InterfaceConnectionTransportType_TransportType}));
        List<InterfaceEnumeration> enumerations = this.interfaceEnumerationApi.get(this.branch1, this.getArtIdsForBranch(enumIds, this.branch1), relations);
        enumerations.addAll(this.interfaceEnumerationApi.get(this.branch2, this.getArtIdsForBranch(enumIds, this.branch2), relations));
        for (InterfaceEnumeration enumeration : enumerations) {
            List<?> enumSets = this.getFromArtifactReadable(enumeration.getArtifactReadable(), CoreRelationTypes.InterfaceEnumeration_EnumerationSet, InterfaceEnumerationSet.class);
            for (InterfaceEnumerationSet enumSet : enumSets) {
                this.diffReport.addItem(enumSet, this.getChangeList(enumeration.getArtifactId()));
                this.diffReport.getEnumSets().add(enumSet.getArtifactId());
                this.addEnumSetParents(enumSet);
            }
        }
    }

    private void addMessageParent(InterfaceMessageToken message) {
        ArtifactId messageId = ArtifactId.valueOf((Long)message.getId());
        if (!this.diffReport.hasParents(messageId)) {
            InterfaceConnection connection = (InterfaceConnection)((Object)this.getFromArtifactReadable(message.getArtifactReadable(), CoreRelationTypes.InterfaceConnectionMessage_Connection, InterfaceConnection.class).get(0));
            this.diffReport.addParent(messageId, connection.getArtifactId());
            this.diffReport.addItem(connection);
        }
    }

    private void addSubMessageParents(InterfaceSubMessageToken subMessage) {
        if (!this.diffReport.hasParents(subMessage.getArtifactId())) {
            List<?> messages = this.getFromArtifactReadable(subMessage.getArtifactReadable(), CoreRelationTypes.InterfaceMessageSubMessageContent_Message, InterfaceMessageToken.class);
            for (InterfaceMessageToken message : messages) {
                this.diffReport.addParent(subMessage.getArtifactId(), message.getArtifactId());
                this.diffReport.addItem(message);
                this.addMessageParent(message);
            }
        }
    }

    private void addStructureParents(InterfaceStructureToken structure) {
        if (!this.diffReport.hasParents(structure.getArtifactId())) {
            List<?> subMessages = this.getFromArtifactReadable(structure.getArtifactReadable(), CoreRelationTypes.InterfaceSubMessageContent_SubMessage, InterfaceSubMessageToken.class);
            for (InterfaceSubMessageToken subMessage : subMessages) {
                this.diffReport.addParent(structure.getArtifactId(), subMessage.getArtifactId());
                this.diffReport.addItem(subMessage);
                this.addSubMessageParents(subMessage);
            }
        }
    }

    private void addElementParents(InterfaceStructureElementToken element) {
        if (!this.diffReport.hasParents(element.getArtifactId())) {
            List<?> structures = this.getFromArtifactReadable(element.getArtifactReadable(), CoreRelationTypes.InterfaceStructureContent_Structure, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structures) {
                this.diffReport.addParent(element.getArtifactId(), structure.getArtifactId());
                this.diffReport.addItem(structure);
                this.addStructureParents(structure);
            }
        }
    }

    private void addEnumSetParents(InterfaceEnumerationSet enumSet) {
        if (!this.diffReport.hasParents(enumSet.getArtifactId())) {
            List<?> pTypes = this.getFromArtifactReadable(enumSet.getArtifactReadable(), CoreRelationTypes.InterfacePlatformTypeEnumeration_Element, PlatformTypeToken.class);
            for (PlatformTypeToken pType : pTypes) {
                this.diffReport.addParent(enumSet.getArtifactId(), pType.getArtifactId());
                List<?> elements = this.getFromArtifactReadable(pType.getArtifactReadable(), CoreRelationTypes.InterfaceElementPlatformType_Element, InterfaceStructureElementToken.class);
                for (InterfaceStructureElementToken element : elements) {
                    this.processElement(element.getArtifactId(), ArtifactId.SENTINEL, element);
                }
            }
        }
    }

    private List<?> getFromArtifactReadable(ArtifactReadable art, RelationTypeSide relation, Class<?> clazz) {
        if (art == null || art.isInvalid()) {
            return new LinkedList();
        }
        return art.getRelatedList(relation).stream().map(a -> {
            try {
                return clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(a);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                return new LinkedList();
            }
        }).collect(Collectors.toList());
    }

    private BranchId getBranchId(ArtifactId artId) {
        List<ChangeItem> changes = this.changeMap.get(artId);
        if (changes == null || changes.isEmpty()) {
            return this.branch1;
        }
        ChangeItem change = changes.stream().filter(c -> c.getChangeType().getId() == ChangeType.Artifact.getId()).findFirst().orElse(null);
        change = change == null ? (ChangeItem)changes.stream().filter(c -> c.getChangeType().getId() == ChangeType.Relation.getId()).findFirst().orElse(null) : change;
        return change != null && change.isDeleted() ? this.branch2 : this.branch1;
    }

    private List<ChangeItem> getChangeList(ArtifactId artId) {
        return this.changeMap.getOrDefault(artId, new LinkedList());
    }

    private List<ArtifactId> getArtIdsForBranch(List<ArtifactId> artIds, BranchId branch) {
        return artIds.stream().filter(id -> this.getBranchId((ArtifactId)id).equals(branch)).collect(Collectors.toList());
    }

    private void addChangeToMap(ChangeItem changeItem) {
        ArtifactId artId = changeItem.getArtId();
        long itemTypeId = changeItem.getItemTypeId().getId();
        if (itemTypeId == CoreArtifactTypes.InterfaceNode.getId() || itemTypeId == CoreRelationTypes.InterfaceConnectionNode.getId()) {
            if (!this.nodeList.contains(artId)) {
                this.nodeList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceConnection.getId()) {
            if (!this.connectionList.contains(artId)) {
                this.connectionList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceMessage.getId()) {
            if (!this.messageList.contains(artId)) {
                this.messageList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceSubMessage.getId()) {
            if (!this.submessageList.contains(artId)) {
                this.submessageList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceStructure.getId() || itemTypeId == CoreRelationTypes.InterfaceStructureContent.getId()) {
            if (!this.structureList.contains(artId)) {
                this.structureList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceDataElementArray.getId() || itemTypeId == CoreArtifactTypes.InterfaceDataElement.getId() || itemTypeId == CoreRelationTypes.InterfaceElementPlatformType.getId()) {
            if (!this.elementList.contains(artId)) {
                this.elementList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfacePlatformType.getId()) {
            if (!this.pTypeList.contains(artId)) {
                this.pTypeList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceEnum.getId() && !this.enumList.contains(artId)) {
            this.enumList.add(artId);
        }
    }

    @Override
    public Map<ArtifactId, MimDifferenceItem> getDifferences(BranchId branch, ArtifactId view, BranchId compareBranch) {
        List changes;
        HashMap<ArtifactId, List> changeItems = new HashMap<ArtifactId, List>();
        HashMap<ArtifactId, MimDifferenceItem> diffs = new HashMap<ArtifactId, MimDifferenceItem>();
        if (branch.equals(compareBranch)) {
            List txs = ((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andBranch(new BranchId[]{branch})).getResults().getList();
            TransactionToken currentTx = (TransactionToken)txs.get(txs.size() - 1);
            TransactionToken compareToTx = (TransactionToken)txs.get(txs.size() - 2);
            changes = this.orcsApi.getTransactionFactory().compareTxs((TransactionId)compareToTx, (TransactionId)currentTx);
        } else {
            TransactionToken currentTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch)).getResults().getExactlyOne();
            TransactionToken compareTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(compareBranch)).getResults().getExactlyOne();
            changes = this.orcsApi.getBranchOps().compareBranch(currentTx, compareTx);
        }
        for (ChangeItem change : changes) {
            if (!change.getArtId().isValid()) continue;
            List artChanges = changeItems.getOrDefault(change.getArtId(), new LinkedList());
            artChanges.add(change);
            changeItems.put(change.getArtId(), artChanges);
        }
        for (ArtifactId id : changeItems.keySet()) {
            ArtifactReadable art = this.orcsApi.getQueryFactory().fromBranch(compareBranch, view).andId(id).asArtifactOrSentinel();
            if (!art.isValid()) continue;
            List artChanges = (List)changeItems.get(id);
            String artTypeName = this.orcsApi.tokenService().getArtifactType(art.getArtifactType().getId()).getName();
            MimDifferenceItem item = new MimDifferenceItem(id, art.getName(), art.getArtifactType().getId(), artTypeName);
            boolean added = true;
            boolean deleted = false;
            for (ChangeItem change : artChanges) {
                if (!change.getNetChange().getModType().equals(ModificationType.NEW) && !change.getNetChange().getModType().equals(ModificationType.INTRODUCED)) {
                    added = false;
                }
                if (change.getChangeType().equals((Object)ChangeType.Attribute)) {
                    String attrName = this.orcsApi.tokenService().getAttributeType(change.getItemTypeId().getId()).getName();
                    String oldValue = change.getBaselineVersion().getValue();
                    String newValue = change.getCurrentVersion().getValue();
                    item.addAttributeChange(change.getItemTypeId().getId(), attrName, oldValue, newValue);
                    continue;
                }
                if (change.getChangeType().equals((Object)ChangeType.Artifact) && change.getCurrentVersion().getModType().equals(ModificationType.DELETED)) {
                    deleted = true;
                    continue;
                }
                if (!change.getChangeType().equals((Object)ChangeType.Relation)) continue;
                boolean relationAdded = change.getCurrentVersion().getModType().equals(ModificationType.NEW) || change.getCurrentVersion().getModType().equals(ModificationType.INTRODUCED);
                String artBName = this.orcsApi.getQueryFactory().fromBranch(compareBranch).andId(change.getArtIdB()).asArtifactOrSentinel().getName();
                item.addRelationChange(change.getItemTypeId().getId(), change.getArtId(), change.getArtIdB(), artBName, relationAdded);
            }
            if (item.getAttributeChanges().isEmpty()) {
                added = false;
            }
            item.setAdded(added);
            item.setDeleted(deleted);
            diffs.put(id, item);
        }
        return diffs;
    }

    @Override
    public Map<ArtifactId, MimChangeSummaryItem> getChangeSummaryItems(BranchId branch1, BranchId branch2, ArtifactId view) {
        TransactionToken sourceTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch1)).getResults().getExactlyOne();
        TransactionToken destinationTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch2)).getResults().getExactlyOne();
        List changes = this.orcsApi.getTransactionFactory().getTxChangeReport(branch1, branch2, (TransactionId)sourceTx, (TransactionId)destinationTx);
        List applicTokens = view.isValid() ? this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens(view, branch1) : this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(branch1).values().stream().collect(Collectors.toList());
        HashMap<ArtifactId, MimChangeSummaryItem> changeMap = new HashMap<ArtifactId, MimChangeSummaryItem>();
        for (ChangeReportRowDto change : changes) {
            ArtifactId artId = ArtifactId.valueOf((Long)change.getArtA().getId());
            MimChangeSummaryItem item = (MimChangeSummaryItem)changeMap.get(artId);
            if (item == null) {
                item = new MimChangeSummaryItem(change.getArtA());
                changeMap.put(artId, item);
            }
            if (change.getItemKindType().equals((Object)ChangeType.Attribute)) {
                item.getAttributeChanges().add(change);
                continue;
            }
            if (change.getItemKindType().equals((Object)ChangeType.Relation)) {
                item.getRelationChanges().add(change);
                continue;
            }
            if (!change.getItemKindType().equals((Object)ChangeType.Artifact)) continue;
            if (change.getChangeType().equals("Applicability")) {
                item.setIsApplic(change.getIsApplic());
                item.setWasApplic(change.getWasApplic());
                boolean isApplic = applicTokens.contains(change.getIsApplic());
                boolean wasApplic = applicTokens.contains(change.getWasApplic());
                if (isApplic && !wasApplic) {
                    item.setAdded(true);
                    item.setAddedDueToApplicChange(true);
                    continue;
                }
                if (isApplic || !wasApplic) continue;
                item.setDeleted(true);
                item.setDeletedDueToApplicChange(true);
                continue;
            }
            if (change.getModType().equals(ModificationType.NEW) || change.getModType().equals(ModificationType.INTRODUCED)) {
                item.setAdded(true);
                continue;
            }
            if (!change.getModType().equals(ModificationType.DELETED)) continue;
            item.setDeleted(true);
        }
        return changeMap;
    }

    @Override
    public MimChangeSummary getChangeSummary(BranchId branch1, BranchId branch2, ArtifactId view) {
        Map<ArtifactId, MimChangeSummaryItem> changes = this.getChangeSummaryItems(branch1, branch2, view);
        return this.getChangeSummary(branch1, branch2, view, changes);
    }

    @Override
    public MimChangeSummary getChangeSummary(BranchId branch1, BranchId branch2, ArtifactId view, Map<ArtifactId, MimChangeSummaryItem> changes) {
        return this.getChangeSummary(branch1, branch2, view, changes, new LinkedList<ApplicabilityToken>());
    }

    @Override
    public MimChangeSummary getChangeSummary(BranchId branch1, BranchId branch2, ArtifactId view, Map<ArtifactId, MimChangeSummaryItem> changes, List<ApplicabilityToken> applicTokenList) {
        ArtifactTypeToken artType;
        List applicTokens = applicTokenList;
        if (applicTokenList.isEmpty()) {
            applicTokens = view.isValid() ? this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens(view, branch1) : this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(branch1).values().stream().collect(Collectors.toList());
        }
        MimChangeSummary summary = new MimChangeSummary();
        HashMap<ArtifactId, List<ArtifactReadable>> elementMap = new HashMap<ArtifactId, List<ArtifactReadable>>();
        HashMap<ArtifactId, MimChangeSummaryItem> elementsAndTypes = new HashMap<ArtifactId, MimChangeSummaryItem>();
        List<ArtifactTypeToken> elementTypes = Arrays.asList(CoreArtifactTypes.InterfaceDataElement, CoreArtifactTypes.InterfaceDataElementArray, CoreArtifactTypes.InterfacePlatformType, CoreArtifactTypes.InterfaceEnumSet, CoreArtifactTypes.InterfaceEnum);
        Map<ArtifactId, MimChangeSummaryItem> changeMap = changes.isEmpty() ? this.getChangeSummaryItems(branch1, branch2, view) : changes;
        LinkedList<MimChangeSummaryItem> items = new LinkedList<MimChangeSummaryItem>();
        items.addAll(changeMap.values());
        for (MimChangeSummaryItem item : items) {
            if (!elementTypes.contains(item.getArtType())) {
                for (ChangeReportRowDto change : item.getRelationChanges()) {
                    if (item.getChildren().stream().filter(c -> c.getArtifactReadable().equals(change.getArtB())).findFirst().orElse(null) != null) continue;
                    MimChangeSummaryItem child = changeMap.get(ArtifactId.valueOf((Long)change.getArtB().getId()));
                    if (child == null) {
                        child = new MimChangeSummaryItem(change.getArtB());
                    }
                    if (change.getModType().equals(ModificationType.NEW)) {
                        child.setAdded(true);
                    } else if (change.getModType().equals(ModificationType.DELETED)) {
                        child.setDeleted(true);
                    }
                    item.getChildren().add(child);
                }
            }
            if (!(applicTokens.contains(item.getArtifactReadable().getApplicabilityToken()) || item.isAddedDueToApplicChange() || item.isDeletedDueToApplicChange())) {
                changeMap.remove(item.getArtId());
                continue;
            }
            if (!item.isAdded() && !item.isDeleted() && !item.isAddedDueToApplicChange() && !item.isDeletedDueToApplicChange() && item.getAttributeChanges().isEmpty() && item.getRelationChanges().isEmpty() && item.getChildren().isEmpty()) {
                changeMap.remove(item.getArtId());
                continue;
            }
            ArtifactId artId = item.getArtId();
            artType = item.getArtType();
            if (!elementTypes.contains(artType)) continue;
            List<Object> currentElements = new LinkedList();
            if (elementMap.containsKey(artId)) {
                currentElements = (List)elementMap.get(artId);
            } else {
                BranchId branchToUse = item.isDeleted() && !item.isDeletedDueToApplicChange() ? branch2 : branch1;
                currentElements = this.getElements(artId, artType, branchToUse, elementMap);
                elementMap.put(artId, currentElements);
            }
            for (ArtifactReadable element : currentElements) {
                if (!CoreArtifactTypes.InterfaceDataElement.equals(artType) && !CoreArtifactTypes.InterfaceDataElement.equals(artType) && !applicTokens.contains(element.getApplicabilityToken())) continue;
                ArtifactId elementId = ArtifactId.valueOf((Long)element.getId());
                MimChangeSummaryItem elementItem = changeMap.get(elementId);
                if (elementItem == null) {
                    if (CoreArtifactTypes.InterfaceDataElement.equals(artType) || CoreArtifactTypes.InterfaceDataElement.equals(artType)) {
                        elementItem = item;
                    } else {
                        elementItem = new MimChangeSummaryItem(element);
                        changeMap.put(elementId, elementItem);
                    }
                }
                for (ArtifactReadable structure : element.getRelated(CoreRelationTypes.InterfaceStructureContent_Structure).getList()) {
                    if (!applicTokens.contains(structure.getApplicabilityToken())) continue;
                    ArtifactId structureId = ArtifactId.valueOf((Long)structure.getId());
                    MimChangeSummaryItem structureItem = changeMap.get(structureId);
                    if (structureItem == null) {
                        structureItem = new MimChangeSummaryItem(structure);
                        changeMap.put(structureId, structureItem);
                    }
                    if (structureItem.getChildren().contains(elementItem)) continue;
                    structureItem.getChildren().add(elementItem);
                }
            }
            elementsAndTypes.put(artId, item);
        }
        for (MimChangeSummaryItem item : elementsAndTypes.values()) {
            Object elementItem2;
            List<ChangeReportRowDto> attrChanges;
            ArtifactTypeToken artType2 = item.getArtType();
            List elementItems = ((List)elementMap.get(item.getArtId())).stream().map(a -> (MimChangeSummaryItem)changeMap.get(ArtifactId.valueOf((Long)a.getId()))).filter(i -> i != null).collect(Collectors.toList());
            if (CoreArtifactTypes.InterfaceDataElement.equals(artType2) || CoreArtifactTypes.InterfaceDataElement.equals(artType2)) {
                ChangeReportRowDto deletedPType = null;
                ChangeReportRowDto addedPType = null;
                for (ChangeReportRowDto relationChange : item.getRelationChanges()) {
                    if (relationChange.getModType().equals(ModificationType.DELETED) && CoreArtifactTypes.InterfacePlatformType.equals(relationChange.getArtB().getArtifactType())) {
                        deletedPType = relationChange;
                    } else if (relationChange.getModType().equals(ModificationType.NEW) && CoreArtifactTypes.InterfacePlatformType.equals(relationChange.getArtB().getArtifactType())) {
                        addedPType = relationChange;
                    }
                    if (deletedPType == null || addedPType == null) continue;
                    ArtifactReadable oldPType = deletedPType.getArtB();
                    ArtifactReadable newPType = addedPType.getArtB();
                    Arrays.asList(CoreAttributeTypes.InterfaceLogicalType, CoreAttributeTypes.InterfacePlatformTypeBitSize, CoreAttributeTypes.InterfacePlatformType2sComplement, CoreAttributeTypes.InterfacePlatformTypeMinval, CoreAttributeTypes.InterfacePlatformTypeMaxval, CoreAttributeTypes.InterfacePlatformTypeUnits, CoreAttributeTypes.InterfaceDefaultValue, CoreAttributeTypes.InterfacePlatformTypeMsbValue, CoreAttributeTypes.InterfacePlatformTypeBitsResolution, CoreAttributeTypes.InterfacePlatformTypeCompRate, CoreAttributeTypes.InterfacePlatformTypeAnalogAccuracy, CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription).stream().forEach(attr -> {
                        String isValue;
                        String wasValue = oldPType.getSoleAttributeAsString((AttributeTypeToken)attr, "");
                        if (!wasValue.equals(isValue = newPType.getSoleAttributeAsString((AttributeTypeToken)attr, ""))) {
                            ChangeReportRowDto attrChange = new ChangeReportRowDto(relationChange.getArtA(), ArtifactReadable.SENTINEL, item.getName(), attr.getName(), "Modified", isValue, wasValue, ChangeType.Attribute, ModificationType.MODIFIED, relationChange.getIsApplic(), relationChange.getWasApplic());
                            item.getAttributeChanges().add(attrChange);
                        }
                    });
                }
            }
            if (CoreArtifactTypes.InterfacePlatformType.equals(artType2)) {
                attrChanges = item.getAttributeChanges().stream().filter(a -> !CoreAttributeTypes.Name.getName().equals(a.getItemType())).collect(Collectors.toList());
                elementItems.stream().forEach(e -> {
                    boolean bl = e.getAttributeChanges().addAll(attrChanges);
                });
                continue;
            }
            if (CoreArtifactTypes.InterfaceEnumSet.equals(artType2)) {
                attrChanges = item.getAttributeChanges().stream().filter(a -> CoreAttributeTypes.Name.getName().equals(a.getItemType())).collect(Collectors.toList());
                attrChanges.forEach(a -> a.setItemType("Enum Set Name"));
                elementItems.stream().forEach(e -> {
                    boolean bl = e.getAttributeChanges().addAll(attrChanges);
                });
                continue;
            }
            if (!CoreArtifactTypes.InterfaceEnum.equals(artType2)) continue;
            String isOrdinal = item.getArtifactReadable().getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinal);
            String isName = item.getName();
            if (item.isAdded() || item.isAddedDueToApplicChange() || item.isDeleted() || item.isDeletedDueToApplicChange()) {
                String isValue = "";
                String wasValue = "";
                String itemType = "";
                if (item.isDeleted() || item.isDeletedDueToApplicChange()) {
                    wasValue = String.valueOf(isOrdinal) + " = " + isName;
                    itemType = "Deleted Enum Literal";
                } else {
                    isValue = String.valueOf(isOrdinal) + " = " + isName;
                    itemType = "Added Enum Literal";
                }
                for (Object elementItem2 : elementItems) {
                    ChangeReportRowDto newChange = new ChangeReportRowDto(((MimChangeSummaryItem)elementItem2).getArtifactReadable(), ArtifactReadable.SENTINEL, ((MimChangeSummaryItem)elementItem2).getName(), itemType, "Modified", isValue, wasValue, ChangeType.Attribute, ModificationType.MODIFIED, ApplicabilityToken.SENTINEL, ApplicabilityToken.SENTINEL);
                    ((MimChangeSummaryItem)elementItem2).getAttributeChanges().add(newChange);
                }
                continue;
            }
            String wasOrdinal = isOrdinal;
            String wasName = isName;
            elementItem2 = item.getAttributeChanges().iterator();
            while (elementItem2.hasNext()) {
                ChangeReportRowDto attrChange = elementItem2.next();
                if (CoreAttributeTypes.Name.getName().equals(attrChange.getItemType())) {
                    wasName = attrChange.getWasValue();
                    continue;
                }
                if (!CoreAttributeTypes.InterfaceEnumOrdinal.getName().equals(attrChange.getItemType())) continue;
                wasOrdinal = attrChange.getWasValue();
            }
            String isValue = String.valueOf(isOrdinal) + " = " + isName;
            String wasValue = String.valueOf(wasOrdinal) + " = " + wasName;
            for (MimChangeSummaryItem elementItem3 : elementItems) {
                ChangeReportRowDto newChange = new ChangeReportRowDto(elementItem3.getArtifactReadable(), ArtifactReadable.SENTINEL, elementItem3.getName(), "Enum Literal", "Modified", isValue, wasValue, ChangeType.Attribute, ModificationType.MODIFIED, ApplicabilityToken.SENTINEL, ApplicabilityToken.SENTINEL);
                elementItem3.getAttributeChanges().add(newChange);
            }
        }
        for (ArtifactId artId : changeMap.keySet()) {
            MimChangeSummaryItem item = changeMap.get(artId);
            artType = item.getArtType();
            if (item.getRelationChanges().isEmpty() && item.getAttributeChanges().isEmpty() && !item.isAdded() && !item.isDeleted() && item.getChildren().isEmpty()) continue;
            if (CoreArtifactTypes.InterfaceNode.equals(artType)) {
                summary.getNodes().put(artId, item);
                continue;
            }
            if (CoreArtifactTypes.InterfaceConnection.equals(artType)) {
                summary.getConnections().put(artId, item);
                continue;
            }
            if (CoreArtifactTypes.InterfaceMessage.equals(artType)) {
                summary.getMessages().put(artId, item);
                continue;
            }
            if (CoreArtifactTypes.InterfaceSubMessage.equals(artType)) {
                summary.getSubMessages().put(artId, item);
                continue;
            }
            if (!CoreArtifactTypes.InterfaceStructure.equals(artType)) continue;
            summary.getStructures().put(artId, item);
        }
        return summary;
    }

    private List<ArtifactReadable> getElements(ArtifactId artId, ArtifactTypeToken artType, BranchId branch, Map<ArtifactId, List<ArtifactReadable>> elementMap) {
        LinkedList<ArtifactReadable> elements = new LinkedList();
        if (elementMap.containsKey(artId)) {
            elements = elementMap.get(artId);
        } else {
            if (CoreArtifactTypes.InterfaceEnum.equals(artType)) {
                ArtifactReadable enumeration = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.InterfaceEnumeration_EnumerationSet).follow(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element).follow(CoreRelationTypes.InterfaceElementPlatformType_Element).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
                for (ArtifactReadable enumSet : enumeration.getRelated(CoreRelationTypes.InterfaceEnumeration_EnumerationSet).getList()) {
                    for (ArtifactReadable pType : enumSet.getRelated(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element)) {
                        for (ArtifactReadable element : pType.getRelated(CoreRelationTypes.InterfaceElementPlatformType_Element)) {
                            elements.add(element);
                        }
                    }
                }
            } else if (CoreArtifactTypes.InterfaceEnumSet.equals(artType)) {
                ArtifactReadable enumSet = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element).follow(CoreRelationTypes.InterfaceElementPlatformType_Element).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
                for (ArtifactReadable pType : enumSet.getRelated(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element)) {
                    for (ArtifactReadable element : pType.getRelated(CoreRelationTypes.InterfaceElementPlatformType_Element)) {
                        elements.add(element);
                    }
                }
            } else if (CoreArtifactTypes.InterfacePlatformType.equals(artType)) {
                ArtifactReadable pType = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.InterfaceElementPlatformType_Element).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
                for (ArtifactReadable element : pType.getRelated(CoreRelationTypes.InterfaceElementPlatformType_Element)) {
                    elements.add(element);
                }
            } else if (CoreArtifactTypes.InterfaceDataElement.equals(artType) || CoreArtifactTypes.InterfaceDataElementArray.equals(artType)) {
                ArtifactReadable element = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
                elements.add(element);
            }
            elementMap.put(artId, elements);
        }
        return elements;
    }
}

