/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceRateApi;
import org.eclipse.osee.mim.InterfaceRateEndpoint;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceRateEndpointImpl
implements InterfaceRateEndpoint {
    private final InterfaceRateApi rateApi;
    private final BranchId branch;

    public InterfaceRateEndpointImpl(BranchId branch, InterfaceRateApi rateApi) {
        this.rateApi = rateApi;
        this.branch = branch;
    }

    @Override
    public Collection<PLGenericDBObject> getAllRates(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.rateApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.rateApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public PLGenericDBObject getRate(ArtifactId rateId) {
        return this.rateApi.get(this.branch, rateId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.rateApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

