/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.InterfaceSubMessageEndpoint;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;

public class InterfaceSubMessageEndpointImpl
implements InterfaceSubMessageEndpoint {
    private final BranchId branch;
    private final ArtifactId messageId;
    private final InterfaceSubMessageApi subMessageApi;

    public InterfaceSubMessageEndpointImpl(BranchId branch, ArtifactId messageId2, InterfaceSubMessageApi interfaceSubMessageApi) {
        this.branch = branch;
        this.messageId = messageId2;
        this.subMessageApi = interfaceSubMessageApi;
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllSubMessages(long pageNum, long pageSize, AttributeTypeToken orderByAttributeTypeId) {
        try {
            return this.subMessageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, this.messageId, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public InterfaceSubMessageToken getSubMessage(ArtifactId subMessageId) {
        try {
            return this.subMessageApi.getAccessor().get(this.branch, subMessageId);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }
}

