/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.MimReportsApi;
import org.eclipse.osee.mim.types.NodeTraceReportItem;
import org.eclipse.osee.orcs.OrcsApi;

public class MimReportsApiImpl
implements MimReportsApi {
    private final OrcsApi orcsApi;

    public MimReportsApiImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Override
    public List<NodeTraceReportItem> getAllRequirementsToInterface(BranchId branch) {
        LinkedList<NodeTraceReportItem> results = new LinkedList();
        List requirements = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Requirement}).andRelationExists(CoreRelationTypes.RequirementsToInterface).follow(CoreRelationTypes.RequirementsToInterface_InterfaceArtifact).asArtifacts();
        results = requirements.stream().map(r -> new NodeTraceReportItem((ArtifactReadable)r, CoreRelationTypes.RequirementsToInterface_InterfaceArtifact)).collect(Collectors.toList());
        return results;
    }

    @Override
    public List<NodeTraceReportItem> getAllInterfaceToRequirements(BranchId branch) {
        LinkedList<NodeTraceReportItem> results = new LinkedList();
        List arts = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceArtifact}).andRelationExists(CoreRelationTypes.RequirementsToInterface).follow(CoreRelationTypes.RequirementsToInterface_Artifact).asArtifacts();
        results = arts.stream().map(a -> new NodeTraceReportItem((ArtifactReadable)a, CoreRelationTypes.RequirementsToInterface_Artifact)).collect(Collectors.toList());
        return results;
    }

    @Override
    public NodeTraceReportItem getInterfacesFromRequirement(BranchId branch, ArtifactId artId) {
        ArtifactReadable requirement = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.RequirementsToInterface_InterfaceArtifact).asArtifact();
        return new NodeTraceReportItem(requirement, CoreRelationTypes.RequirementsToInterface_InterfaceArtifact);
    }

    @Override
    public NodeTraceReportItem getRequirementsFromInterface(BranchId branch, ArtifactId artId) {
        ArtifactReadable interfaceReadable = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.RequirementsToInterface_Artifact).asArtifact();
        return new NodeTraceReportItem(interfaceReadable, CoreRelationTypes.RequirementsToInterface_Artifact);
    }
}

