/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.TransportTypeApi;
import org.eclipse.osee.mim.internal.TransportTypeAccessor;
import org.eclipse.osee.mim.types.ArtifactMatch;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.mim.types.TransportType;
import org.eclipse.osee.orcs.OrcsApi;

public class TransportTypeApiImpl
implements TransportTypeApi {
    private ArtifactAccessor<TransportType> accessor;

    public TransportTypeApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new TransportTypeAccessor(orcsApi));
    }

    private void setAccessor(ArtifactAccessor<TransportType> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<TransportType> query(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, 0L, 0L);
    }

    @Override
    public Collection<TransportType> queryExact(BranchId branch, MimAttributeQuery query) {
        return this.queryExact(branch, query, 0L, 0L);
    }

    @Override
    public Collection<TransportType> query(BranchId branch, MimAttributeQuery query, boolean isExact) {
        return this.query(branch, query, isExact, 0L, 0L);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId) {
        return null;
    }

    @Override
    public Collection<TransportType> getAll(BranchId branch) {
        return this.getAll(branch, 0L, 0L);
    }

    @Override
    public TransportType get(BranchId branch, ArtifactId artId) {
        try {
            return this.accessor.get(branch, artId);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new TransportType();
        }
    }

    @Override
    public Collection<TransportType> query(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, false, pageNum, pageSize);
    }

    @Override
    public Collection<TransportType> queryExact(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, true, pageNum, pageSize);
    }

    @Override
    public Collection<TransportType> query(BranchId branch, MimAttributeQuery query, boolean isExact, long pageNum, long pageSize) {
        try {
            return this.accessor.getAllByQuery(branch, query, isExact, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<TransportType>();
        }
    }

    @Override
    public Collection<TransportType> getAll(BranchId branch, long pageNum, long pageSize) {
        return this.getAll(branch, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<TransportType> getAll(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<TransportType> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return this.accessor.getAll(branch, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<TransportType>();
        }
    }

    @Override
    public TransportType getFromConnection(BranchId branch, ArtifactId connectionId) {
        try {
            return this.accessor.getByRelationWithoutId(branch, CoreRelationTypes.InterfaceConnectionTransportType_InterfaceConnection, connectionId);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return TransportType.SENTINEL;
        }
    }
}

