/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.osee.mim.types.ClusterView;
import org.eclipse.osee.mim.types.ConnectionView;
import org.eclipse.osee.mim.types.NodeView;

public class GraphView {
    Collection<ConnectionView> edges;
    Collection<NodeView> nodes;
    Collection<ClusterView> clusters;

    public Collection<ConnectionView> getEdges() {
        return this.edges;
    }

    public void setEdges(Collection<ConnectionView> edges) {
        this.edges = edges;
    }

    public Collection<NodeView> getNodes() {
        return this.nodes;
    }

    public void setNodes(Collection<NodeView> nodes) {
        this.nodes = nodes;
    }

    @JsonIgnore
    public void addNode(NodeView node) {
        this.nodes.add(node);
    }

    @JsonIgnore
    public void removeNode(NodeView node) {
        if (this.nodes.contains(node)) {
            this.nodes.remove(node);
        }
    }

    @JsonIgnore
    public void removeNode(Long index) {
        this.nodes = this.nodes.stream().filter(x -> !x.getId().equals(index.toString())).collect(Collectors.toList());
    }

    @JsonIgnore
    public void addEdges(ConnectionView connection) {
        this.edges.add(connection);
    }

    @JsonIgnore
    public void removeEdges(ConnectionView connection) {
        if (this.edges.contains((Object)connection)) {
            this.edges.remove((Object)connection);
        }
    }

    @JsonIgnore
    public void removeEdges(Long index) {
        this.edges = this.edges.stream().filter(x -> x.getId() != index).collect(Collectors.toList());
    }

    public Collection<ClusterView> getClusters() {
        return this.clusters;
    }

    public void setClusters(Collection<ClusterView> clusters) {
        this.clusters = clusters;
    }
}

