/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceStructureToken
extends PLGenericDBObject {
    public static final InterfaceStructureToken SENTINEL = new InterfaceStructureToken();
    private String nameAbbrev;
    private String InterfaceStructureCategory;
    private String InterfaceMinSimultaneity;
    private String InterfaceMaxSimultaneity;
    private Integer InterfaceTaskFileType;
    private Integer numElements = 0;
    private Double sizeInBytes = 0.0;
    private String Description;
    private boolean autogenerated = false;
    private Collection<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
    private ApplicabilityToken applicability;
    private ArtifactReadable artifactReadable;

    public InterfaceStructureToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceStructureToken(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName(art.getName());
        this.setNameAbbrev((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.NameAbbrev, (Object)""));
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setInterfaceMaxSimultaneity((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMaxSimultaneity, (Object)""));
        this.setInterfaceMinSimultaneity((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMinSimultaneity, (Object)""));
        this.setInterfaceStructureCategory(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceStructureCategory, ""));
        this.setInterfaceTaskFileType((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceTaskFileType, (Object)0));
        this.setElements(art.getRelated(CoreRelationTypes.InterfaceStructureContent_DataElement).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceStructureElementToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.artifactReadable = art;
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceStructureToken(Long id, String name) {
        super(id, name);
    }

    public InterfaceStructureToken() {
    }

    public String getNameAbbrev() {
        return this.nameAbbrev;
    }

    public void setNameAbbrev(String nameAbbrev) {
        this.nameAbbrev = nameAbbrev;
    }

    public String getInterfaceStructureCategory() {
        return this.InterfaceStructureCategory;
    }

    public void setInterfaceStructureCategory(String interfaceStructureCategory) {
        this.InterfaceStructureCategory = interfaceStructureCategory;
    }

    public String getInterfaceMinSimultaneity() {
        return this.InterfaceMinSimultaneity;
    }

    public void setInterfaceMinSimultaneity(String interfaceMinSimultaneity) {
        this.InterfaceMinSimultaneity = interfaceMinSimultaneity;
    }

    public String getInterfaceMaxSimultaneity() {
        return this.InterfaceMaxSimultaneity;
    }

    public void setInterfaceMaxSimultaneity(String interfaceMaxSimultaneity) {
        this.InterfaceMaxSimultaneity = interfaceMaxSimultaneity;
    }

    public Integer getInterfaceTaskFileType() {
        return this.InterfaceTaskFileType;
    }

    public void setInterfaceTaskFileType(Integer interfaceTaskFileType) {
        this.InterfaceTaskFileType = interfaceTaskFileType;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public List<InterfaceStructureElementToken> getElements() {
        return (List)this.elements;
    }

    public void setElements(Collection<InterfaceStructureElementToken> elements) {
        this.elements = elements;
        this.setNumElements(elements.size());
        this.setSizeInBytes(elements.stream().filter(f -> f.isIncludedInCounts()).mapToDouble(InterfaceStructureElementToken::getElementSizeInBytes).sum());
    }

    public Integer getNumElements() {
        return this.numElements;
    }

    public void setNumElements(Integer numElements) {
        this.numElements = numElements;
    }

    public Double getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Double sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public boolean getIncorrectlySized() {
        return this.getSizeInBytes() % 8.0 != 0.0;
    }

    public Double getBytesPerSecondMaximum() {
        return this.getSizeInBytes() * (Strings.isNumeric((String)this.getInterfaceMaxSimultaneity()) ? Double.parseDouble(this.getInterfaceMaxSimultaneity()) : 0.0);
    }

    public Double getBytesPerSecondMinimum() {
        return this.getSizeInBytes() * (Strings.isNumeric((String)this.getInterfaceMinSimultaneity()) ? Double.parseDouble(this.getInterfaceMinSimultaneity()) : 0.0);
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public void setAutogenerated(boolean autogenerated) {
        this.autogenerated = autogenerated;
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.artifactReadable;
    }
}

