/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.mim.types.MimDifferenceReportItem;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class MimDifferenceReport {
    private final Map<ArtifactId, MimDifferenceReportItem> changeItems = new HashMap<ArtifactId, MimDifferenceReportItem>();
    private final List<ArtifactId> nodes = new LinkedList<ArtifactId>();
    private final List<ArtifactId> connections = new LinkedList<ArtifactId>();
    private final List<ArtifactId> messages = new LinkedList<ArtifactId>();
    private final List<ArtifactId> subMessages = new LinkedList<ArtifactId>();
    private final List<ArtifactId> structures = new LinkedList<ArtifactId>();
    private final List<ArtifactId> elements = new LinkedList<ArtifactId>();
    private final List<ArtifactId> enumSets = new LinkedList<ArtifactId>();

    public void addItem(PLGenericDBObject item) {
        this.addItem(item, new LinkedList<ChangeItem>());
    }

    public void addItem(PLGenericDBObject item, List<ChangeItem> changes) {
        MimDifferenceReportItem itemChanges = this.changeItems.getOrDefault(item.getArtifactId(), new MimDifferenceReportItem(item, new LinkedList<ChangeItem>()));
        itemChanges.getChanges().addAll(changes);
        this.changeItems.put(item.getArtifactId(), itemChanges);
    }

    public boolean containsItem(ArtifactId artId) {
        return this.changeItems.containsKey(artId);
    }

    public void addParent(ArtifactId item, ArtifactId parent) {
        MimDifferenceReportItem mapItem = this.changeItems.get(item);
        if (mapItem != null) {
            mapItem.addParent(parent);
        }
    }

    public boolean hasParents(ArtifactId artId) {
        MimDifferenceReportItem mapItem = this.changeItems.get(artId);
        if (mapItem != null) {
            return !mapItem.getParents().isEmpty();
        }
        return false;
    }

    public Map<ArtifactId, MimDifferenceReportItem> getChangeItems() {
        return this.changeItems;
    }

    public List<ArtifactId> getNodes() {
        return this.nodes;
    }

    public List<ArtifactId> getConnections() {
        return this.connections;
    }

    public List<ArtifactId> getMessages() {
        return this.messages;
    }

    public List<ArtifactId> getSubMessages() {
        return this.subMessages;
    }

    public List<ArtifactId> getStructures() {
        return this.structures;
    }

    public List<ArtifactId> getElements() {
        return this.elements;
    }

    public List<ArtifactId> getEnumSets() {
        return this.enumSets;
    }
}

