/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.access.BootstrapUsers;
import org.eclipse.osee.orcs.core.internal.access.UserGroupImpl;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class UserServiceImpl
implements UserService {
    private final ConcurrentHashMap<UserId, UserToken> accountIdToUser = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, UserToken> loginIdToUser = new ConcurrentHashMap();
    private final String loginKey;
    private final OrcsApi orcsApi;
    private final QueryBuilder query;
    private final ConcurrentHashMap<Thread, UserToken> threadToUser = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, UserToken> userIdToUser = new ConcurrentHashMap();

    public UserServiceImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
        this.loginKey = OseeProperties.getJwtLoginKey();
    }

    public void clearCaches() {
        this.loginIdToUser.clear();
    }

    public TransactionId createUsers(Iterable<UserToken> users, String comment) {
        this.ensureLoaded();
        UserToken currentUser = this.getUser();
        boolean isBootstrap = this.loginIdToUser.isEmpty();
        if (!isBootstrap) {
            this.requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.AccountAdmin});
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (UserId)this.getUser(), comment);
        ArtifactToken userGroupHeader = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)CoreArtifactTokens.UserGroups).asArtifactToken();
        HashMap<ArtifactToken, ArtifactToken> userGroupToArtifact = new HashMap<ArtifactToken, ArtifactToken>();
        List defaultGroups = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.UserGroup}).andAttributeIs((AttributeTypeToken)CoreAttributeTypes.DefaultGroup, "true").getResults().getList();
        List existingUsers = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).getResults().getList();
        Set<UserToken> bootstrapUsers = BootstrapUsers.getBoostrapUsers();
        for (UserToken userToken : users) {
            ArtifactToken userGroupArt;
            if (existingUsers.contains(userToken)) continue;
            ArtifactToken user = null;
            user = userToken.isValid() ? tx.createArtifact((ArtifactToken)userToken) : tx.createArtifact(CoreArtifactTypes.User, userToken.getName());
            tx.setSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)userToken.isActive());
            tx.setSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.UserId, (Object)userToken.getUserId());
            tx.setSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.Email, (Object)userToken.getEmail());
            for (String loginId : userToken.getLoginIds()) {
                if (bootstrapUsers.contains(userToken) && OseeProperties.isInTest()) {
                    tx.createAttributeNoAccess((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.LoginId, (Object)loginId);
                    continue;
                }
                if (!currentUser.getRoles().contains(CoreUserGroups.AccountAdmin)) continue;
                tx.createAttribute((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.LoginId, currentUser, (Object)loginId);
            }
            for (ArtifactToken userGroup : userToken.getRoles()) {
                userGroupArt = this.getOrCreate(userGroup, userGroupToArtifact, tx, userGroupHeader);
                tx.relate((ArtifactId)userGroupArt, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)user);
            }
            for (ArtifactToken userGroup : defaultGroups) {
                userGroupArt = this.getOrCreate(userGroup, userGroupToArtifact, tx, userGroupHeader);
                tx.relate((ArtifactId)userGroupArt, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)user);
            }
        }
        return tx.commit();
    }

    private synchronized void ensureLoaded() {
        if (this.loginIdToUser.isEmpty()) {
            for (ArtifactReadable userArtifact : this.query.andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).follow(CoreRelationTypes.Users_Artifact).asArtifacts()) {
                UserToken user = this.toUser(userArtifact);
                if (user.isValid() && !user.getIdString().isEmpty()) {
                    this.accountIdToUser.put(UserId.valueOf((Long)user.getId()), user);
                }
                String userId = user.getUserId();
                if (!user.isValid() || userId.isEmpty()) continue;
                this.userIdToUser.put(userId, user);
                for (String loginId : user.getLoginIds()) {
                    if (!Strings.isValid((String)loginId)) continue;
                    this.loginIdToUser.put(loginId, user);
                }
            }
        }
    }

    public String getLoginKey() {
        return this.loginKey;
    }

    public Collection<IUserGroupArtifactToken> getMyUserGroups() {
        return this.getUser().getRoles();
    }

    private ArtifactToken getOrCreate(ArtifactToken userGroup, Map<ArtifactToken, ArtifactToken> userGroupToArtifact, TransactionBuilder tx, ArtifactToken userGroupHeader) {
        ArtifactToken userGroupArt = userGroupToArtifact.get(userGroup);
        if (userGroupArt == null) {
            userGroupArt = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroup).getArtifactOrNull();
        }
        if (userGroupArt == null) {
            userGroupArt = tx.createArtifact(userGroup);
            tx.addChild((ArtifactId)userGroupHeader, (ArtifactId)userGroupArt);
        }
        userGroupToArtifact.put(userGroup, userGroupArt);
        return userGroupArt;
    }

    public UserToken getUser() {
        UserToken user = this.threadToUser.get(Thread.currentThread());
        if (user == null) {
            user = UserToken.SENTINEL;
        }
        return user;
    }

    public UserToken getUser(Long accountId) {
        this.ensureLoaded();
        UserToken user = this.accountIdToUser.get(UserId.valueOf((Long)accountId));
        if (user == null) {
            user = UserToken.SENTINEL;
        }
        return user;
    }

    public UserToken getUserByUserId(String userId) {
        this.ensureLoaded();
        UserToken user = this.userIdToUser.get(userId);
        if (user == null) {
            user = UserToken.SENTINEL;
        }
        return user;
    }

    public IUserGroup getUserGroup(ArtifactToken userGroupArt) {
        ArtifactToken art = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroupArt).getArtifactOrSentinal();
        return new UserGroupImpl(art);
    }

    public IUserGroup getUserGroup(IUserGroupArtifactToken userGroup) {
        IUserGroup group = this.getUserGroupOrNull(userGroup);
        if (group != null) {
            return group;
        }
        throw new OseeArgumentException("parameter must be artifact", new Object[0]);
    }

    public IUserGroup getUserGroupOrNull(IUserGroupArtifactToken userGroup) {
        ArtifactToken art;
        ArtifactReadable userGroupArt = null;
        if (userGroup instanceof ArtifactReadable) {
            userGroupArt = (ArtifactReadable)userGroup;
        }
        if (userGroupArt == null && (art = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroup).getArtifactOrSentinal()).isValid() && art instanceof ArtifactReadable) {
            userGroupArt = (ArtifactReadable)art;
        }
        if (userGroupArt != null) {
            return new UserGroupImpl((ArtifactToken)userGroupArt);
        }
        return null;
    }

    public UserToken getUserIfLoaded() {
        return UserToken.SENTINEL;
    }

    public UserToken getUserIfLoaded(Long accountId) {
        return UserToken.SENTINEL;
    }

    public Collection<UserToken> getUsers(IUserGroupArtifactToken userGroup) {
        throw new UnsupportedOperationException();
    }

    public boolean isBeforeUserCreation() {
        return false;
    }

    public boolean isUserMember(IUserGroupArtifactToken userGroup, Long id) {
        ArtifactToken art = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroup).getArtifactOrSentinal();
        if (art.isInvalid()) {
            return false;
        }
        return this.getUserGroup(userGroup).isMember(id);
    }

    public void setBeforeUserCreation(boolean beforeUserCreation) {
    }

    public void setUserForCurrentThread(String loginId) {
        List userArtifacts;
        this.ensureLoaded();
        UserToken user = this.loginIdToUser.get(loginId);
        if (user == null && (userArtifacts = this.query.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.LoginId, loginId).asArtifacts()).size() == 1) {
            user = this.toUser((ArtifactReadable)userArtifacts.get(0));
        }
        if (user != null && user.isValid()) {
            this.threadToUser.put(Thread.currentThread(), user);
        }
    }

    public void setUserForCurrentThread(UserId accountId) {
        if (accountId.isValid()) {
            List userArtifacts;
            this.ensureLoaded();
            UserToken user = this.accountIdToUser.get(accountId);
            if (user == null && (userArtifacts = this.query.andId((ArtifactId)accountId).asArtifacts()).size() == 1 && (user = this.toUser((ArtifactReadable)userArtifacts.get(0))).isValid()) {
                this.accountIdToUser.put((UserId)user, user);
            }
            if (user != null && user.isValid()) {
                this.threadToUser.put(Thread.currentThread(), user);
            }
        }
    }

    public void removeUserFromCurrentThread() {
        this.threadToUser.remove(Thread.currentThread());
    }

    private UserToken toUser(ArtifactReadable userArtifact) {
        try {
            List groups = userArtifact.getRelated(CoreRelationTypes.Users_Artifact, CoreArtifactTypes.UserGroup);
            ArrayList<UserGroupArtifactToken> roles = new ArrayList<UserGroupArtifactToken>(groups.size());
            for (ArtifactReadable group : groups) {
                roles.add(new UserGroupArtifactToken(group.getId(), group.getName()));
            }
            return UserToken.create((long)userArtifact.getId(), (String)userArtifact.getName(), (String)((String)userArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Email, (Object)"")), (String)((String)userArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId, (Object)"")), (boolean)((Boolean)userArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Active, (Object)false)), (List)userArtifact.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.LoginId), roles, (String)((String)userArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Phone, (Object)"")));
        }
        catch (Exception exception) {
            return UserToken.SENTINEL;
        }
    }

    public void setUserLoading(boolean loading) {
    }
}

