/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.BranchCategoryData;
import org.eclipse.osee.orcs.core.ds.HasOrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.OrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.OrcsVisitor;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactVisitor;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationVisitor;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;

public class ChangeSetBuilder
implements ArtifactVisitor,
RelationVisitor,
HasOrcsChangeSet {
    private final OrcsChangeSetImpl changeSet = new OrcsChangeSetImpl();

    @Override
    public void visit(Artifact artifact) {
        if (artifact.isDirty()) {
            this.changeSet.arts.add((ArtifactData)artifact.getOrcsData());
        }
    }

    @Override
    public void visit(Attribute<?> attribute) {
        if (attribute.isDirty()) {
            this.changeSet.attrs.add((AttributeData)attribute.getOrcsData());
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isDirty()) {
            this.changeSet.rels.add(relation.getOrcsData());
        }
    }

    public void handleOtherData(TxData txData) {
        this.changeSet.txData = txData;
    }

    @Override
    public OrcsChangeSet getChangeSet() {
        return this.changeSet;
    }

    private static final class OrcsChangeSetImpl
    implements OrcsChangeSet {
        private final Set<ArtifactData> arts = Sets.newLinkedHashSet();
        private final Set<AttributeData> attrs = Sets.newLinkedHashSet();
        private final Set<RelationData> rels = Sets.newLinkedHashSet();
        private TxData txData;

        private OrcsChangeSetImpl() {
        }

        @Override
        public void accept(OrcsVisitor visitor) {
            for (ArtifactData artifactData : this.getArtifactData()) {
                visitor.visit(artifactData);
            }
            for (AttributeData attributeData : this.getAttributeData()) {
                visitor.visit(attributeData);
            }
            for (RelationData relationData : this.getRelationData()) {
                visitor.visit(relationData);
            }
            for (TupleData tupleData : this.txData.getTuplesToAdd()) {
                visitor.visit(tupleData);
            }
            for (BranchCategoryData branchCategoryData : this.txData.getCategoriesToAdd()) {
                visitor.visit(branchCategoryData);
            }
            this.txData.getTuplesToDelete().forEachValue((key, gammaId) -> visitor.deleteTuple(this.txData.getBranch(), (SqlTable)key, (GammaId)gammaId));
            for (GammaId gammaId2 : this.txData.getBranchCategoriesToDelete()) {
                visitor.deleteBranchCategory(this.txData.getBranch(), gammaId2);
            }
        }

        @Override
        public Iterable<ArtifactData> getArtifactData() {
            return this.arts;
        }

        @Override
        public Iterable<AttributeData> getAttributeData() {
            return this.attrs;
        }

        @Override
        public Iterable<RelationData> getRelationData() {
            return this.rels;
        }

        @Override
        public TxData getTxData() {
            return this.txData;
        }

        @Override
        public boolean isEmpty() {
            return this.arts.isEmpty() && this.attrs.isEmpty() && this.rels.isEmpty() && this.txData.getTuplesToAdd().isEmpty() && this.txData.getTuplesToDelete().isEmpty() && this.txData.getCategoriesToAdd().isEmpty() && this.txData.getBranchCategoriesToDelete().isEmpty();
        }

        @Override
        public int size() {
            return this.arts.size() + this.attrs.size() + this.rels.size();
        }

        public String toString() {
            return "OrcsChangeSetImpl [arts=" + this.arts + ", attrs=" + this.attrs + ", rels=" + this.rels + "]";
        }
    }
}

