/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.tagger;

import java.util.Arrays;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagCollector;

public class TagEncoder {
    private static final char[] tagChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'l', 'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'v', 'w', 'y'};

    public void encode(String text, TagCollector collector) {
        int tagBitsPos = 0;
        long tagBits = 0L;
        int index = 0;
        while (index < text.length()) {
            char c = text.charAt(index);
            if (c == '\t' || c == '\n' || c == '\r' || tagBitsPos == 60) {
                if (tagBitsPos > 10) {
                    collector.addTag(text, tagBits);
                }
                tagBits = 0L;
                tagBitsPos = 0;
            } else {
                int pos;
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                tagBits = (pos = Arrays.binarySearch(tagChars, c)) < 0 ? (tagBits |= (long)(63 << (int)((long)tagBitsPos))) : (tagBits |= (long)(pos << (int)((long)tagBitsPos)));
                tagBitsPos += 4;
            }
            ++index;
        }
        if (tagBits != 0L) {
            collector.addTag(text, tagBits);
        }
    }

    public static final void main(String[] args) {
        new TagEncoder().encode("1", new TagCollector(){

            @Override
            public void addTag(String word, Long codedTag) {
                System.out.printf("%s %s\n", word, codedTag);
            }
        });
    }
}

