/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.define.operations.publishing.PublishingErrorLog;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactSpecification;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.util.ListMap;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class ChangedArtifactsTracker {
    private final IAtsBranchService atsBranchService;
    private final IAtsQueryService atsQueryService;
    private final ListMap<ArtifactId, ArtifactReadable> map;
    private final PublishingErrorLog publishingErrorLog;
    private final PublishingUtils publishingUtils;

    public ChangedArtifactsTracker(AtsApi atsApi, PublishingUtils publishingUtils, PublishingErrorLog publishingErrorLog) {
        Objects.requireNonNull(atsApi, "ChangedArtifactsTracker::new, parameter \"atsApi\" cannot be null.");
        Objects.requireNonNull(publishingUtils, "ChangedArtifactsTracker::new, parameter \"publishingUtils\" cannot be null.");
        Objects.requireNonNull(publishingErrorLog, "ChangedArtifactsTracker::new, parameter \"publishingErrorLog\" cannot be null.");
        this.publishingUtils = Objects.requireNonNull(publishingUtils);
        this.atsBranchService = Objects.requireNonNull(atsApi.getBranchService());
        this.atsQueryService = Objects.requireNonNull(atsApi.getQueryService());
        this.publishingErrorLog = Objects.requireNonNull(publishingErrorLog);
        this.map = new ListMap();
    }

    public List<ArtifactReadable> getList() {
        return Collections.unmodifiableList(this.map.listView());
    }

    private Stream<ArtifactId> getTeamworkflowArtifactIdentifiers(ArtifactId goalArtifactIdentifier) {
        return this.publishingUtils.getWorkFlowArtifactIdentifiers(goalArtifactIdentifier).orElseGet(() -> {
            this.publishingErrorLog.error(goalArtifactIdentifier, new Message().title((CharSequence)"Failed to get ATS Team Workflows for the goal Artifact.").segment((CharSequence)"Goal Artifact Identifier", (Object)goalArtifactIdentifier).segment((CharSequence)"Cause", (Object)this.publishingUtils.getLastCause()).reasonFollowsIfPresent(this.publishingUtils.getLastError()).toString());
            return List.of();
        }).stream();
    }

    public boolean isChangedArtifact(ArtifactId artifactId) {
        return this.map.mapView().containsKey(artifactId);
    }

    private boolean isRecursivelyRelated(HashSet<ArtifactReadable> goodParents, ArtifactReadable artifact) {
        if (goodParents.contains(artifact)) {
            return true;
        }
        LinkedList<ArtifactReadable> maybeParents = new LinkedList<ArtifactReadable>();
        maybeParents.add(artifact);
        ArtifactReadable ancestor = artifact.getParent();
        while (Objects.nonNull(ancestor)) {
            maybeParents.add(ancestor);
            if (goodParents.contains(ancestor)) {
                goodParents.addAll(maybeParents);
                return true;
            }
            ancestor = ancestor.getParent();
        }
        return false;
    }

    private boolean isTeamWorkflowBranchValidAndCommitted(IAtsTeamWorkflow teamWorkflow, BranchId goalArtifactBranchIdentifier) {
        BranchToken workflowBranchToken = this.atsBranchService.getBranch(teamWorkflow);
        if (!workflowBranchToken.isValid()) {
            return false;
        }
        if (!this.atsBranchService.isBranchesAllCommitted(teamWorkflow) && workflowBranchToken.equals(goalArtifactBranchIdentifier)) {
            this.publishingErrorLog.error(teamWorkflow, new Message().title((CharSequence)"The ATS Team Workflow branch has not been committed and will not be included in the publish.").indentInc().segment((CharSequence)"Goal Branch", (Object)goalArtifactBranchIdentifier.getIdString()).toString());
            return false;
        }
        return true;
    }

    public void loadByAtsTeamWorkflow(Collection<ArtifactReadable> headerArtifacts, ArtifactSpecification artifactSpecification) {
        Objects.requireNonNull(headerArtifacts, "ChangedArtifactsTracker::loadByAtsTeamWorkflow, parameter \"headerArtifacts\" cannot be null.");
        Objects.requireNonNull(artifactSpecification, "ChangedArtifactsTracker::loadByAtsTeamWorkflow, parameter \"artifactSpecification\" cannot be null.");
        if (headerArtifacts.isEmpty()) {
            return;
        }
        Set<ArtifactId> changedArtIds = this.getTeamworkflowArtifactIdentifiers(artifactSpecification.getArtifactId()).map(arg_0 -> ((IAtsQueryService)this.atsQueryService).getTeamWf(arg_0)).filter(teamWorkflow -> this.isTeamWorkflowBranchValidAndCommitted((IAtsTeamWorkflow)teamWorkflow, artifactSpecification.getBranchId())).map(teamWorkflow -> this.atsBranchService.getCommitTransactionRecord(teamWorkflow, artifactSpecification.getBranchId())).flatMap(commitTx -> this.atsBranchService.getChangeData((TransactionId)commitTx).stream()).map(ChangeItem::getArtId).collect(Collectors.toSet());
        if (changedArtIds.isEmpty()) {
            return;
        }
        HashSet<ArtifactReadable> goodParents = new HashSet<ArtifactReadable>(headerArtifacts);
        this.streamChangedArtifacts((BranchSpecification)artifactSpecification, changedArtIds).filter(artifactReadable -> this.isRecursivelyRelated(goodParents, (ArtifactReadable)artifactReadable)).collect(Collectors.toMap(Function.identity(), Function.identity(), (a, b) -> a, () -> this.map.mapView()));
    }

    public void loadByTransactionComment(BranchSpecification branchSpecification) {
        Objects.requireNonNull(branchSpecification, "ChangedArtifactsTracker::loadByTransactionComment, parameter \"branchSpecification\" cannot be null.");
        this.streamChangedArtifactReadables(branchSpecification).collect(Collectors.toMap(Function.identity(), Function.identity(), (a, b) -> a, () -> this.map.mapView()));
    }

    private Stream<ArtifactReadable> streamChangedArtifactReadables(BranchSpecification branchSpecification) {
        return this.publishingUtils.getArtifactReadablesFilterByTxCommentForChange(branchSpecification).orElseGet(() -> {
            this.publishingErrorLog.error(new Message().title((CharSequence)"Failed to get changed artifacts from branch by transaction comments.").segmentToMessage((CharSequence)"Goal Branch", (ToMessage)branchSpecification).segment((CharSequence)"Cause", (Object)this.publishingUtils.getLastCause()).reasonFollowsIfPresent(this.publishingUtils.getLastError()).toString());
            return List.of();
        }).stream();
    }

    private Stream<ArtifactReadable> streamChangedArtifacts(BranchSpecification branchSpecification, Collection<ArtifactId> changedArtifactIds) {
        return this.publishingUtils.getArtifactReadablesByIdentifiers(branchSpecification, changedArtifactIds).orElseGet(() -> {
            this.publishingErrorLog.error(new Message().title((CharSequence)"Failed to get changed artifacts identified from the ATS Team Workflow Artifacts for the goal Artifact.").segmentToMessage((CharSequence)"Goal Branch", (ToMessage)branchSpecification).segment((CharSequence)"Cause", (Object)this.publishingUtils.getLastCause()).reasonFollowsIfPresent(this.publishingUtils.getLastError()).toString());
            return List.of();
        }).stream();
    }
}

