/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.publishing.EnumRendererMap;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class PublishingOptionsFactory<K extends Enum<K>> {
    private final Map<K, RendererMap> map;

    private PublishingOptionsFactory(Map<K, RendererMap> publishingOptionsMap) {
        this.map = publishingOptionsMap;
    }

    private EnumRendererMap create(K key) {
        RendererMap parentPublishingOptions = this.map.get(key);
        EnumRendererMap publishingOptions = Objects.nonNull(parentPublishingOptions) ? new EnumRendererMap(parentPublishingOptions) : new EnumRendererMap();
        return publishingOptions;
    }

    public EnumRendererMap create(K key, BranchId branchId) {
        EnumRendererMap publishingOptions = this.create(key);
        if (Objects.isNull(branchId)) {
            return publishingOptions;
        }
        if (branchId.isInvalid()) {
            publishingOptions.setRendererOption(RendererOption.BRANCH, (Object)BranchId.SENTINEL);
            publishingOptions.setRendererOption(RendererOption.VIEW, (Object)ArtifactId.SENTINEL);
            return publishingOptions;
        }
        publishingOptions.setRendererOption(RendererOption.BRANCH, (Object)branchId);
        ArtifactId viewArtifactId = branchId.getViewId();
        if (Objects.isNull(viewArtifactId)) {
            return publishingOptions;
        }
        if (viewArtifactId.isInvalid()) {
            publishingOptions.setRendererOption(RendererOption.VIEW, (Object)ArtifactId.SENTINEL);
        }
        publishingOptions.setRendererOption(RendererOption.VIEW, (Object)viewArtifactId);
        return publishingOptions;
    }

    public EnumRendererMap create(K key, BranchId branchId, ArtifactId viewArtifactId) {
        assert (!Objects.nonNull(branchId) || !Objects.nonNull(branchId.getViewId()) || !Objects.nonNull(viewArtifactId) || ArtifactId.SENTINEL.equals(branchId.getViewId()) || ArtifactId.SENTINEL.equals(viewArtifactId) || !branchId.getViewId().equals(viewArtifactId)) : new Message().title((CharSequence)"PublishingOptionsFactory::create, The view identifier in the branch identifier is not consistent with the specified view identifier.").indentInc().segment((CharSequence)"Branch Identifier", (Object)branchId.getIdString()).segment((CharSequence)"View Identifier In Branch Identifier", (Object)branchId.getViewId().getIdString()).segment((CharSequence)"View Identifer From Parameter", (Object)viewArtifactId.getIdString()).toString();
        EnumRendererMap publishingOptions = this.create(key);
        if (Objects.isNull(branchId)) {
            return publishingOptions;
        }
        if (branchId.isInvalid()) {
            publishingOptions.setRendererOption(RendererOption.BRANCH, (Object)BranchId.SENTINEL);
            publishingOptions.setRendererOption(RendererOption.VIEW, (Object)ArtifactId.SENTINEL);
            return publishingOptions;
        }
        publishingOptions.setRendererOption(RendererOption.BRANCH, (Object)branchId);
        if (Objects.isNull(viewArtifactId)) {
            return publishingOptions;
        }
        if (viewArtifactId.isInvalid()) {
            publishingOptions.setRendererOption(RendererOption.VIEW, (Object)ArtifactId.SENTINEL);
        }
        publishingOptions.setRendererOption(RendererOption.VIEW, (Object)viewArtifactId);
        return publishingOptions;
    }

    public static <K extends Enum<K>> PublishingOptionsFactory<K> ofEntries(Class<K> enumerationKeyClass, Function<K, RendererMap> enumToPublishingOptionsFunction) {
        EnumMap map = new EnumMap(enumerationKeyClass);
        EnumSet.allOf(enumerationKeyClass).forEach(key -> {
            RendererMap rendererMap = map.put((Object)key, (RendererMap)enumToPublishingOptionsFunction.apply(key));
        });
        PublishingOptionsFactory<K> publishingOptionsFactory = new PublishingOptionsFactory<K>(map);
        return publishingOptionsFactory;
    }
}

