/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.osee.define.rest.internal.wordupdate.UpdateBookmarkIds;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.orcs.OrcsApi;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WordCoreUtilServer {
    public static final String LISTNUM_FIELD_HEAD = "<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr>";
    public static final String BODY_START = "<w:body>";
    public static final String BODY_END = "</w:body>";
    private static final Pattern referencePattern = Pattern.compile("(_Ref[0-9]{9}|Word\\.Bookmark\\.End)");
    private static int bookMarkId = 1000;
    private static UpdateBookmarkIds updateBookmarkIds = new UpdateBookmarkIds(bookMarkId);

    public static byte[] getFormattedContent(Element formattedItemElement) throws XMLStreamException {
        ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
        XMLStreamWriter xmlWriter = null;
        try {
            xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(data, "UTF-8");
            for (Element e : Jaxp.getChildDirects((Element)formattedItemElement)) {
                Jaxp.writeNode((XMLStreamWriter)xmlWriter, (Node)e, (boolean)false);
            }
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.flush();
                xmlWriter.close();
            }
        }
        return data.toByteArray();
    }

    public static Map<ApplicabilityId, ApplicabilityToken> getApplicabilityTokens(OrcsApi orcsApi, BranchId branchId) {
        return orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(branchId).entrySet().stream().collect(Collectors.toMap(entrySet -> ApplicabilityId.valueOf((Long)((Long)entrySet.getKey())), Map.Entry::getValue));
    }

    public static WordCoreUtil.pageType getPageOrientation(ArtifactReadable artifactReadable) {
        WordCoreUtil.pageType defaultPageType = WordCoreUtil.pageType.getDefault();
        if (artifactReadable.isInvalid()) {
            return defaultPageType;
        }
        if (!artifactReadable.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.PageOrientation)) {
            return defaultPageType;
        }
        try {
            String pageTypeString = artifactReadable.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.PageOrientation, defaultPageType.name());
            return WordCoreUtil.pageType.fromString((String)pageTypeString);
        }
        catch (Exception exception) {
            return defaultPageType;
        }
    }

    public static String referencesOnly(String content) {
        ArrayList<String> references = new ArrayList<String>();
        Matcher referenceMatcher = referencePattern.matcher(content);
        while (referenceMatcher.find()) {
            String reference = referenceMatcher.group(1);
            references.add(reference);
        }
        StringBuilder sb = new StringBuilder();
        for (String reference : references) {
            sb.append(reference);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean isHeadingStyle(String paragraphStyle) {
        if (paragraphStyle == null) {
            return false;
        }
        String style = paragraphStyle.toLowerCase();
        return style.startsWith("heading") || style.startsWith("toc") || style.startsWith("outline");
    }

    public static CharSequence reassignBookMarkID(CharSequence content) {
        return updateBookmarkIds.fixTags(content);
    }
}

