/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.forest;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.Direction;
import org.eclipse.osee.define.operations.synchronization.ForeignThingFamily;
import org.eclipse.osee.define.operations.synchronization.LinkType;
import org.eclipse.osee.define.operations.synchronization.forest.CreateGroveThingFromForeignThingException;
import org.eclipse.osee.define.operations.synchronization.forest.Grove;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.StreamEntry;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataTypeKey;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeHeader;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.AbstractGroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.AbstractMapGrove;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierFactory;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTypeGroup;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ParameterArray;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class Forest
implements ToMessage {
    private static int minPrimaryRank = 1;
    private static int maxPrimaryRank = 3;
    private static int minNativeRank = 1;
    private static int maxNativeRank = 3;
    private static Map<IdentifierType, GroveThingInitializationRecord> groveThingInitializers;
    private final Map<IdentifierType, Grove> groveMap;
    private final IdentifierFactory identifierFactory;
    private final Direction direction;
    private final Identifier identifier;

    static {
        Map.Entry[] entryArray = new Map.Entry[12];
        entryArray[0] = Map.entry(IdentifierType.ATTRIBUTE_DEFINITION, new GroveThingInitializationRecord(IdentifierType.ATTRIBUTE_DEFINITION, 2, 1, false, IdentifierType.DATA_TYPE_DEFINITION::equals, Map.of(IdentifierType.DATA_TYPE_DEFINITION, AbstractGroveThing.LinkRank.SCALAR), new IdentifierType[][]{{IdentifierType.SPECIFICATION_TYPE, IdentifierType.SPEC_OBJECT_TYPE, IdentifierType.SPEC_RELATION_TYPE}, {IdentifierType.ATTRIBUTE_DEFINITION}}, new Class[]{AttributeTypeToken.class}, null, null));
        entryArray[1] = Map.entry(IdentifierType.ATTRIBUTE_VALUE, new GroveThingInitializationRecord(IdentifierType.ATTRIBUTE_VALUE, 2, 1, false, IdentifierType.ATTRIBUTE_DEFINITION::equals, Map.of(IdentifierType.ATTRIBUTE_DEFINITION, AbstractGroveThing.LinkRank.SCALAR), new IdentifierType[][]{{IdentifierType.SPECIFICATION, IdentifierType.SPECTER_SPEC_OBJECT, IdentifierType.SPEC_OBJECT, IdentifierType.SPEC_RELATION}, {IdentifierType.ATTRIBUTE_VALUE}}, null, null, null));
        entryArray[2] = Map.entry(IdentifierType.DATA_TYPE_DEFINITION, new GroveThingInitializationRecord(IdentifierType.DATA_TYPE_DEFINITION, 1, 1, true, IdentifierType.ENUM_VALUE::equals, Map.of(IdentifierType.ENUM_VALUE, AbstractGroveThing.LinkRank.VECTOR), new IdentifierType[][]{{IdentifierType.DATA_TYPE_DEFINITION}}, new Class[]{NativeDataTypeKey.class}, new Class[]{NativeDataTypeKey.class}, new Function[]{nativeThing -> nativeThing}));
        entryArray[3] = Map.entry(IdentifierType.ENUM_VALUE, new GroveThingInitializationRecord(IdentifierType.ENUM_VALUE, 1, 2, true, null, Map.of(), new IdentifierType[][]{{IdentifierType.ENUM_VALUE}}, new Class[]{AttributeTypeToken.class, EnumToken.class}, new Class[]{Long.class, Long.class}, new Function[]{nativeThing -> ((Id)nativeThing).getId(), nativeThing -> ((Id)nativeThing).getId()}));
        entryArray[4] = Map.entry(IdentifierType.HEADER, new GroveThingInitializationRecord(IdentifierType.HEADER, 1, 1, false, null, Map.of(), new IdentifierType[][]{{IdentifierType.HEADER}}, new Class[]{NativeHeader.class}, null, null));
        entryArray[5] = Map.entry(IdentifierType.SPECIFICATION, new GroveThingInitializationRecord(IdentifierType.SPECIFICATION, 1, 1, true, IdentifierType.SPECIFICATION_TYPE::equals, Map.of(IdentifierType.SPECIFICATION_TYPE, AbstractGroveThing.LinkRank.SCALAR), new IdentifierType[][]{{IdentifierType.SPECIFICATION}}, new Class[]{ArtifactReadable.class}, new Class[]{Long.class}, new Function[]{nativeThing -> ((Id)nativeThing).getId()}));
        entryArray[6] = Map.entry(IdentifierType.SPECTER_SPEC_OBJECT, new GroveThingInitializationRecord(IdentifierType.SPECTER_SPEC_OBJECT, 1, 1, true, IdentifierType.SPEC_OBJECT_TYPE::equals, Map.of(IdentifierType.SPEC_OBJECT_TYPE, AbstractGroveThing.LinkRank.SCALAR), new IdentifierType[][]{{IdentifierType.SPECTER_SPEC_OBJECT}}, new Class[]{ArtifactReadable.class}, new Class[]{Long.class}, new Function[]{nativeThing -> ((Id)nativeThing).getId()}));
        entryArray[7] = Map.entry(IdentifierType.SPEC_OBJECT, new GroveThingInitializationRecord(IdentifierType.SPEC_OBJECT, 3, 1, true, IdentifierType.SPEC_OBJECT_TYPE::equals, Map.of(IdentifierType.SPEC_OBJECT_TYPE, AbstractGroveThing.LinkRank.SCALAR), new IdentifierType[][]{{IdentifierType.SPECIFICATION}, {IdentifierType.SPECIFICATION, IdentifierType.SPEC_OBJECT}, {IdentifierType.SPECIFICATION, IdentifierType.SPEC_OBJECT}}, new Class[]{ArtifactReadable.class}, new Class[]{Long.class}, new Function[]{nativeThing -> ((Id)nativeThing).getId()}));
        entryArray[8] = Map.entry(IdentifierType.SPEC_RELATION, new GroveThingInitializationRecord(IdentifierType.SPEC_RELATION, 1, 3, true, linkType -> IdentifierType.SPEC_RELATION_TYPE.equals(linkType) || IdentifierTypeGroup.RELATABLE_OBJECT.equals(linkType), Map.of(IdentifierType.SPEC_RELATION_TYPE, AbstractGroveThing.LinkRank.SCALAR, IdentifierTypeGroup.RELATABLE_OBJECT, AbstractGroveThing.LinkRank.VECTOR), new IdentifierType[][]{{IdentifierType.SPEC_RELATION}}, new Class[]{ArtifactReadable.class, ArtifactReadable.class, ArtifactReadable.class}, new Class[]{Long.class, Long.class, Long.class}, new Function[]{nativeThing -> ((Id)nativeThing).getId(), nativeThing -> ((Id)nativeThing).getId(), nativeThing -> ((Id)nativeThing).getId()}));
        entryArray[9] = Map.entry(IdentifierType.SPECIFICATION_TYPE, new GroveThingInitializationRecord(IdentifierType.SPECIFICATION_TYPE, 1, 1, true, IdentifierType.ATTRIBUTE_DEFINITION::equals, Map.of(IdentifierType.ATTRIBUTE_DEFINITION, AbstractGroveThing.LinkRank.MAP), new IdentifierType[][]{{IdentifierType.SPECIFICATION_TYPE}}, new Class[]{ArtifactTypeToken.class}, new Class[]{Long.class}, new Function[]{nativeThing -> ((Id)nativeThing).getId()}));
        entryArray[10] = Map.entry(IdentifierType.SPEC_OBJECT_TYPE, new GroveThingInitializationRecord(IdentifierType.SPEC_OBJECT_TYPE, 1, 1, true, IdentifierType.ATTRIBUTE_DEFINITION::equals, Map.of(IdentifierType.ATTRIBUTE_DEFINITION, AbstractGroveThing.LinkRank.MAP), new IdentifierType[][]{{IdentifierType.SPEC_OBJECT_TYPE}}, new Class[]{ArtifactTypeToken.class}, new Class[]{Long.class}, new Function[]{nativeThing -> ((Id)nativeThing).getId()}));
        entryArray[11] = Map.entry(IdentifierType.SPEC_RELATION_TYPE, new GroveThingInitializationRecord(IdentifierType.SPEC_RELATION_TYPE, 1, 1, true, IdentifierType.ATTRIBUTE_DEFINITION::equals, Map.of(IdentifierType.ATTRIBUTE_DEFINITION, AbstractGroveThing.LinkRank.MAP), new IdentifierType[][]{{IdentifierType.SPEC_RELATION_TYPE}}, new Class[]{ArtifactTypeToken.class}, new Class[]{Long.class}, new Function[]{nativeThing -> ((Id)nativeThing).getId()}));
        groveThingInitializers = Map.ofEntries(entryArray);
    }

    public Forest(Direction direction) {
        var groveMap;
        Objects.requireNonNull(direction, "Forest::new, parameter \"direction\" is null.");
        this.groveMap = groveMap = new LinkedHashMap<IdentifierType, Grove>(){
            private static final long serialVersionUID = 1L;

            public void put(Grove grove) {
                this.put(grove.getType(), grove);
            }
        };
        groveMap.put(Forest.createGrove(IdentifierType.HEADER));
        groveMap.put(Forest.createGrove(IdentifierType.ENUM_VALUE));
        groveMap.put(Forest.createGrove(IdentifierType.DATA_TYPE_DEFINITION));
        groveMap.put(Forest.createGrove(IdentifierType.SPECIFICATION_TYPE));
        groveMap.put(Forest.createGrove(IdentifierType.SPEC_OBJECT_TYPE));
        groveMap.put(Forest.createGrove(IdentifierType.SPEC_RELATION_TYPE));
        groveMap.put(Forest.createGrove(IdentifierType.ATTRIBUTE_DEFINITION));
        groveMap.put(Forest.createGrove(IdentifierType.SPECIFICATION));
        groveMap.put(Forest.createGrove(IdentifierType.SPECTER_SPEC_OBJECT));
        groveMap.put(Forest.createGrove(IdentifierType.SPEC_OBJECT));
        groveMap.put(Forest.createGrove(IdentifierType.SPEC_RELATION));
        groveMap.put(Forest.createGrove(IdentifierType.ATTRIBUTE_VALUE));
        this.direction = direction;
        this.identifierFactory = new IdentifierFactory(direction.getIdentifierFactoryType());
        this.identifier = Direction.EXPORT.equals((Object)direction) ? this.identifierFactory.createIdentifier(IdentifierType.FOREST) : this.identifierFactory.createIdentifier(IdentifierType.FOREST, "F-0");
    }

    private static Grove createGrove(IdentifierType identifierType) {
        GroveThingInitializationRecord groveThingInitializer = groveThingInitializers.get(identifierType);
        return new AbstractMapGrove(identifierType, groveThingInitializer.providesNativeKeys, groveThingInitializer.getPrimaryKeyValidators(), groveThingInitializer.getNativeKeyValidators());
    }

    public GroveThing createGroveThing(IdentifierType identifierType, GroveThing ... parents) {
        if (!Direction.EXPORT.equals((Object)this.direction)) {
            throw new IllegalStateException();
        }
        GroveThingInitializationRecord groveThingInitializer = groveThingInitializers.get(identifierType);
        return new AbstractGroveThing(this.identifierFactory.createIdentifier(identifierType), groveThingInitializer.primaryRank, groveThingInitializer.nativeRank, groveThingInitializer.providesNativeKeys, groveThingInitializer.linkTypeValidator, groveThingInitializer.linkRank, groveThingInitializer.parentsValidator, groveThingInitializer.nativeThingsValidator, groveThingInitializer.nativeKeyFunctions, parents);
    }

    public GroveThing createGroveThingFromForeignThing(IdentifierType groveIdentifierType, ForeignThingFamily foreignThingFamily) {
        if (!Direction.IMPORT.equals((Object)this.direction)) {
            throw new IllegalStateException();
        }
        String[] stringForeignKeys = foreignThingFamily.getForeignIdentifiersAsStrings();
        IdentifierType[] identifierTypes = foreignThingFamily.getIdentifierTypes();
        Object foreignThing = foreignThingFamily.getChild();
        if (Objects.isNull(stringForeignKeys) || stringForeignKeys.length <= 0 || Objects.isNull(identifierTypes) || identifierTypes.length != stringForeignKeys.length || Objects.isNull(foreignThing)) {
            throw new CreateGroveThingFromForeignThingException("bad foreign thing record", foreignThingFamily);
        }
        int count = stringForeignKeys.length;
        GroveThing[] parents = new GroveThing[count - 1];
        IdentifierType groveThingIdentifierType = identifierTypes[count - 1];
        if (groveThingIdentifierType != groveIdentifierType) {
            Grove grove = this.getGrove(groveThingIdentifierType);
            String groveThingForeignIdentifierString = stringForeignKeys[count - 1];
            Identifier primaryIdentifier = this.getPrimaryIdentifierByForeignIdentifierString(groveThingIdentifierType, groveThingForeignIdentifierString).get();
            GroveThing groveThing = grove.getByUniquePrimaryKey(primaryIdentifier).get();
            return groveThing;
        }
        int i = 0;
        while (i < count - 1) {
            IdentifierType identifierType = identifierTypes[i];
            String stringForeignKey = stringForeignKeys[i];
            Identifier primaryIdentifier = this.getPrimaryIdentifierByForeignIdentifierString(identifierType, stringForeignKey).orElseThrow(() -> new CreateGroveThingFromForeignThingException("failed to get primary identifier from foreign thing identifier", stringForeignKey, foreignThingFamily));
            parents[i] = this.getGrove(identifierType).getByUniquePrimaryKey(primaryIdentifier).orElseThrow(() -> new CreateGroveThingFromForeignThingException("grove thing not found for foreign thing identifier", stringForeignKey, foreignThingFamily));
            ++i;
        }
        GroveThingInitializationRecord groveThingInitializer = groveThingInitializers.get(groveThingIdentifierType);
        AbstractGroveThing groveThing = new AbstractGroveThing(this.identifierFactory.createIdentifier(groveThingIdentifierType, stringForeignKeys[count - 1]), groveThingInitializer.primaryRank, groveThingInitializer.nativeRank, groveThingInitializer.providesNativeKeys, groveThingInitializer.linkTypeValidator, groveThingInitializer.linkRank, groveThingInitializer.parentsValidator, groveThingInitializer.nativeThingsValidator, groveThingInitializer.nativeKeyFunctions, parents);
        groveThing.setForeignThing(foreignThing);
        return groveThing;
    }

    public Grove getGrove(IdentifierType identifierType) {
        return this.groveMap.get(identifierType);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Optional<Identifier> getPrimaryIdentifierByForeignIdentifierString(IdentifierType identifierType, String foreignIdentifierString) {
        return this.identifierFactory.getPrimaryIdentifierByForeignIdentifierString(identifierType, foreignIdentifierString);
    }

    public Stream<Grove> stream() {
        return this.groveMap.values().stream();
    }

    public Stream<GroveThing> streamGroves(IdentifierType ... groveIdentifierTypes) {
        assert (Objects.nonNull(groveIdentifierTypes) && groveIdentifierTypes.length > 0) : "Forest::streamGroves, no groves specified.";
        return Arrays.stream(groveIdentifierTypes).map(this::getGrove).flatMap(grove -> grove.stream(new Identifier[0]));
    }

    public Stream<GroveThing> streamGroves(StreamEntry ... streamEntries) {
        assert (Objects.nonNull(streamEntries) && streamEntries.length > 0) : "Forest::streamGroves, no groves specified.";
        return Arrays.stream(streamEntries).flatMap(streamEntry -> {
            Grove grove = this.groveMap.get(streamEntry.getIdentifierType());
            return streamEntry.hasFilter() ? grove.stream(new Identifier[0]).filter(streamEntry.getFilter()) : grove.stream(new Identifier[0]);
        });
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        String name = this.getClass().getName();
        outMessage.indent(indent).title((CharSequence)name).indentInc().segment((CharSequence)"Direction", (Object)this.direction).title((CharSequence)"Grove Map").indentInc();
        this.groveMap.values().stream().forEach(grove -> {
            Message message2 = outMessage.blank().segment((CharSequence)"Type", (Object)grove.getType()).segment((CharSequence)"Grove Size", (Object)grove.size()).segment((CharSequence)"Native Rank", (Object)grove.nativeRank()).segment((CharSequence)"Rank", (Object)grove.rank());
        });
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    private static class GroveThingInitializationRecord {
        IdentifierType identifierType;
        Map<LinkType, AbstractGroveThing.LinkRank> linkRank;
        Predicate<LinkType> linkTypeValidator;
        Function<Object, Object>[] nativeKeyFunctions;
        Predicate<Object[]> nativeThingsValidator;
        int nativeRank;
        Predicate<GroveThing[]> parentsValidator;
        int primaryRank;
        boolean providesNativeKeys;
        Class<?>[] validNativeKeyTypes;
        Class<?>[] validNativeThings;
        IdentifierType[][] validPrimaryKeyTypes;

        GroveThingInitializationRecord(IdentifierType identifierType, int primaryRank, int nativeRank, boolean providesNativeKeys, Predicate<LinkType> linkTypeValidator, Map<LinkType, AbstractGroveThing.LinkRank> linkRank, IdentifierType[][] validPrimaryKeyTypes, Class<?>[] validNativeThings, Class<?>[] validNativeKeyTypes, Function<Object, Object>[] nativeKeyFunctions) {
            assert (Objects.nonNull(identifierType)) : "Bad GroveThingInitializationRecord, identifier type is null.";
            assert (primaryRank >= minPrimaryRank && primaryRank <= maxPrimaryRank) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " primaryRank is out of range.";
            assert (nativeRank >= minNativeRank && nativeRank <= maxNativeRank) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " nativeRank is out of range.";
            assert (Objects.nonNull(linkRank) && (linkRank.size() >= 1 && Objects.nonNull(linkTypeValidator) || linkRank.size() == 0 && Objects.isNull(linkTypeValidator))) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " linkTypeValidator must be specified when the linkRank map has entries.";
            assert (Objects.nonNull(validPrimaryKeyTypes)) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " validPrimayKeyTypes is null.";
            assert (validPrimaryKeyTypes.length == primaryRank) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " validPrimayKeyTypes length does not equal primaryRank.";
            assert (Objects.isNull(validNativeThings) || validNativeThings.length == nativeRank) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " validNativeThings are provided and length does not match nativeRank.";
            assert (!providesNativeKeys && Objects.isNull(validNativeKeyTypes) || providesNativeKeys && Objects.nonNull(validNativeKeyTypes)) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " when providesNativeKeys is true validNativeKeyTypes must be non-null and when providesNativeKeys is flase validNatieKeyTypes must be null.";
            assert (Objects.isNull(validNativeKeyTypes) || validNativeKeyTypes.length == nativeRank) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " validNativeKeyTypes are provided and length does not match nativeRank.";
            assert (!providesNativeKeys && Objects.isNull(nativeKeyFunctions) || providesNativeKeys && Objects.nonNull(nativeKeyFunctions)) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " when providesNativeKeys is true nativeKeyFunctions must be non-null and when providesNativeKeys is flase natieKeyFunctions must be null.";
            assert (Objects.isNull(nativeKeyFunctions) || nativeKeyFunctions.length == nativeRank) : "Bad GroveThingInitializationRecord for " + identifierType.toString() + " nativeKeyFunctions are provided and length does not match nativeRank.";
            this.identifierType = identifierType;
            this.primaryRank = primaryRank;
            this.nativeRank = nativeRank;
            this.providesNativeKeys = providesNativeKeys;
            this.linkTypeValidator = linkTypeValidator;
            this.linkRank = linkRank;
            this.validPrimaryKeyTypes = validPrimaryKeyTypes;
            this.validNativeThings = validNativeThings;
            this.validNativeKeyTypes = validNativeKeyTypes;
            this.nativeKeyFunctions = nativeKeyFunctions;
            this.parentsValidator = this.getParentsValidator();
            this.nativeThingsValidator = this.getNativeThingsValidator();
        }

        Predicate<GroveThing[]> getParentsValidator() {
            return this.primaryRank > 1 ? new Predicate<GroveThing[]>(){

                @Override
                public boolean test(GroveThing[] parents) {
                    if (!ParameterArray.validateNonNullAndSize((Object[])parents, (int)(primaryRank - 1), (int)(primaryRank - 1))) {
                        return false;
                    }
                    int i = 0;
                    while (i < primaryRank - 1) {
                        int j = 0;
                        while (j < validPrimaryKeyTypes[i].length) {
                            if (parents[i].isType(validPrimaryKeyTypes[i][j])) break;
                            ++j;
                        }
                        if (j >= validPrimaryKeyTypes[i].length) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            } : new Predicate<GroveThing[]>(){

                @Override
                public boolean test(GroveThing[] parents) {
                    return ParameterArray.validateNullOrEmpty((Object[])parents);
                }
            };
        }

        Predicate<Object>[] getPrimaryKeyValidators() {
            Predicate[] primaryKeyValidators = new Predicate[this.primaryRank];
            int i = 0;
            while (i < this.primaryRank) {
                IdentifierType[] identifierTypesForRank = this.validPrimaryKeyTypes[i];
                primaryKeyValidators[i] = identifierTypesForRank.length == 1 ? new Predicate<Object>(identifierTypesForRank){
                    IdentifierType identifierType;
                    {
                        this.identifierType = identifierTypeArray[0];
                    }

                    @Override
                    public boolean test(Object key) {
                        return Objects.nonNull(key) && key instanceof Identifier && ((Identifier)key).getType().equals(this.identifierType);
                    }
                } : new Predicate<Object>(identifierTypesForRank){
                    IdentifierType[] identifierTypes;
                    {
                        this.identifierTypes = identifierTypeArray;
                    }

                    @Override
                    public boolean test(Object key) {
                        if (Objects.isNull(key) || !(key instanceof Identifier)) {
                            return false;
                        }
                        IdentifierType keyType = ((Identifier)key).getType();
                        int i = 0;
                        while (i < this.identifierTypes.length) {
                            if (keyType.equals(this.identifierTypes[i])) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                };
                ++i;
            }
            return primaryKeyValidators;
        }

        Predicate<Object[]> getNativeThingsValidator() {
            return Objects.nonNull(this.validNativeThings) ? new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] nativeThings) {
                    if (!ParameterArray.validateNonNullAndSize((Object[])nativeThings, (int)nativeRank, (int)nativeRank)) {
                        return false;
                    }
                    int i = 0;
                    while (i < nativeRank) {
                        if (!validNativeThings[i].isInstance(nativeThings[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            } : new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] nativeThings) {
                    return ParameterArray.validateNonNullAndSize((Object[])nativeThings, (int)nativeRank, (int)nativeRank);
                }
            };
        }

        Predicate<Object>[] getNativeKeyValidators() {
            if (Objects.isNull(this.validNativeKeyTypes)) {
                return null;
            }
            Predicate[] nativeKeyValidators = new Predicate[this.nativeRank];
            int i = 0;
            while (i < this.nativeRank) {
                Class<?> keyClassForRank = this.validNativeKeyTypes[i];
                nativeKeyValidators[i] = new Predicate<Object>(keyClassForRank){
                    Class<?> keyClass;
                    {
                        this.keyClass = clazz;
                    }

                    @Override
                    public boolean test(Object key) {
                        return Objects.nonNull(key) && this.keyClass.isInstance(key);
                    }
                };
                ++i;
            }
            return nativeKeyValidators;
        }
    }
}

