/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.publishingdombuilder;

import java.util.Objects;
import org.eclipse.osee.define.operations.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeDefinitionImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class AttributeDefinitionConverter {
    private final DocumentMap documentMap;

    public AttributeDefinitionConverter(DocumentMap documentMap) {
        this.documentMap = documentMap;
    }

    void convert(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing.isType(IdentifierType.ATTRIBUTE_DEFINITION)) : UnexpectedGroveThingTypeException.buildMessage(groveThing, IdentifierType.ATTRIBUTE_DEFINITION);
        Identifier identifier = groveThing.getIdentifier();
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)groveThing.getNativeThing();
        String description = nativeAttributeTypeToken.getDescription();
        String name = nativeAttributeTypeToken.getName();
        AttributeDefinitionImpl attributeDefinition = this.documentMap.createAttributeDefinition(identifier, name, description);
        groveThing.setForeignThing(attributeDefinition);
    }
}

