/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder;

import java.math.BigInteger;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.operations.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataType;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataTypeKey;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder.ReqIFSynchronizationArtifactBuilder;
import org.eclipse.osee.framework.jdk.core.util.EnumBiConsumerMap;
import org.eclipse.osee.framework.jdk.core.util.EnumSupplierMap;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.ReqIF10Factory;

class DataTypeDefinitionConverter {
    private static final EnumSupplierMap<NativeDataType, DatatypeDefinition> reqifDatatypeDefinitionFactoryMap;
    private static final EnumBiConsumerMap<NativeDataType, GroveThing, DatatypeDefinition> reqifDatatypeDefinitionDatatypeConverterMap;
    private static final EnumMap<NativeDataType, ReqifDatatypeRecord> reqifDatatypeDefinitionRecordMap;

    static {
        Map.Entry[] entryArray = new Map.Entry[13];
        entryArray[0] = Map.entry(NativeDataType.ARTIFACT_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionInteger());
        entryArray[1] = Map.entry(NativeDataType.BRANCH_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionInteger());
        entryArray[2] = Map.entry(NativeDataType.BOOLEAN, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionBoolean());
        entryArray[3] = Map.entry(NativeDataType.DATE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionDate());
        entryArray[4] = Map.entry(NativeDataType.DOUBLE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionReal());
        entryArray[5] = Map.entry(NativeDataType.ENUMERATED, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionEnumeration());
        entryArray[6] = Map.entry(NativeDataType.INPUT_STREAM, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        entryArray[7] = Map.entry(NativeDataType.INTEGER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionInteger());
        entryArray[8] = Map.entry(NativeDataType.JAVA_OBJECT, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        entryArray[9] = Map.entry(NativeDataType.LONG, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionInteger());
        entryArray[10] = Map.entry(NativeDataType.STRING, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        entryArray[11] = Map.entry(NativeDataType.STRING_WORD_ML, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionXHTML());
        entryArray[12] = Map.entry(NativeDataType.URI, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        reqifDatatypeDefinitionFactoryMap = EnumSupplierMap.ofEntries(NativeDataType.class, (Map.Entry[])entryArray);
        reqifDatatypeDefinitionDatatypeConverterMap = EnumBiConsumerMap.ofEntries(NativeDataType.class, (Map.Entry[])new Map.Entry[]{Map.entry(NativeDataType.ARTIFACT_IDENTIFIER, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionInteger), Map.entry(NativeDataType.BRANCH_IDENTIFIER, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionInteger), Map.entry(NativeDataType.DOUBLE, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionReal), Map.entry(NativeDataType.INPUT_STREAM, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionString), Map.entry(NativeDataType.INTEGER, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionInteger), Map.entry(NativeDataType.JAVA_OBJECT, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionString), Map.entry(NativeDataType.LONG, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionInteger), Map.entry(NativeDataType.STRING, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionString), Map.entry(NativeDataType.URI, DataTypeDefinitionConverter::convertDataTypeDefinitionReqIfDatatypeDefinitionString)});
        reqifDatatypeDefinitionRecordMap = new EnumMap(NativeDataType.class);
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.ARTIFACT_IDENTIFIER, new ReqifDatatypeIntegerRecord(Long.MAX_VALUE, Long.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.BRANCH_IDENTIFIER, new ReqifDatatypeIntegerRecord(Long.MAX_VALUE, Long.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.DOUBLE, new ReqifDatatypeDoubleRecord(64L, (Double)Double.MAX_VALUE, (Double)Double.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.INPUT_STREAM, new ReqifDatatypeStringRecord(0x100000L));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.INTEGER, new ReqifDatatypeIntegerRecord((Long)Integer.MAX_VALUE, (Long)Integer.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.JAVA_OBJECT, new ReqifDatatypeStringRecord(1024L));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.LONG, new ReqifDatatypeIntegerRecord(Long.MAX_VALUE, Long.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.STRING, new ReqifDatatypeStringRecord(8192L));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.URI, new ReqifDatatypeStringRecord(2048L));
    }

    private DataTypeDefinitionConverter() {
    }

    static void convert(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing.isType(IdentifierType.DATA_TYPE_DEFINITION)) : UnexpectedGroveThingTypeException.buildMessage(groveThing, IdentifierType.DATA_TYPE_DEFINITION);
        NativeDataType nativeDataType = ((NativeDataTypeKey)groveThing.getNativeThing()).getNativeDataType();
        DatatypeDefinition reqifDatatypeDefinition = (DatatypeDefinition)reqifDatatypeDefinitionFactoryMap.get((Enum)nativeDataType);
        DataTypeDefinitionConverter.convertDataTypeDefinitionReqIfDatatypeDefinition(groveThing, reqifDatatypeDefinition);
        if (reqifDatatypeDefinitionDatatypeConverterMap.containsKey((Enum)nativeDataType)) {
            reqifDatatypeDefinitionDatatypeConverterMap.accept((Enum)nativeDataType, (Object)groveThing, (Object)reqifDatatypeDefinition);
        }
        groveThing.setForeignThing(reqifDatatypeDefinition);
    }

    private static void convertDataTypeDefinitionReqIfDatatypeDefinition(GroveThing dataTypeDefinitionGroveThing, DatatypeDefinition reqifDatatypeDefinition) {
        NativeDataTypeKey nativeDataTypeKey = (NativeDataTypeKey)dataTypeDefinitionGroveThing.getNativeThing();
        NativeDataType nativeDataType = nativeDataTypeKey.getNativeDataType();
        reqifDatatypeDefinition.setDesc(nativeDataType.toString());
        reqifDatatypeDefinition.setIdentifier(dataTypeDefinitionGroveThing.getIdentifier().toString());
        reqifDatatypeDefinition.setLastChange(ReqIFSynchronizationArtifactBuilder.lastChangeEpoch);
        reqifDatatypeDefinition.setLongName(nativeDataTypeKey.name());
    }

    private static void convertDataTypeDefinitionReqIfDatatypeDefinitionInteger(GroveThing dataTypeDefinitionGroveThing, DatatypeDefinition reqifDatatypeDefinition) {
        assert (reqifDatatypeDefinition instanceof DatatypeDefinitionInteger);
        DatatypeDefinitionInteger reqifDatatypeDefinitionInteger = (DatatypeDefinitionInteger)reqifDatatypeDefinition;
        NativeDataType nativeDataType = ((NativeDataTypeKey)dataTypeDefinitionGroveThing.getNativeThing()).getNativeDataType();
        assert (reqifDatatypeDefinitionRecordMap.containsKey((Object)nativeDataType));
        ReqifDatatypeRecord reqifDatatypeRecord = reqifDatatypeDefinitionRecordMap.get((Object)nativeDataType);
        assert (reqifDatatypeRecord instanceof ReqifDatatypeIntegerRecord);
        ReqifDatatypeIntegerRecord reqifDatatypeIntegerRecord = (ReqifDatatypeIntegerRecord)reqifDatatypeRecord;
        reqifDatatypeDefinitionInteger.setMax(BigInteger.valueOf(reqifDatatypeIntegerRecord.max));
        reqifDatatypeDefinitionInteger.setMin(BigInteger.valueOf(reqifDatatypeIntegerRecord.min));
    }

    private static void convertDataTypeDefinitionReqIfDatatypeDefinitionReal(GroveThing dataTypeDefinitionGroveThing, DatatypeDefinition reqifDatatypeDefinition) {
        assert (reqifDatatypeDefinition instanceof DatatypeDefinitionReal);
        DatatypeDefinitionReal reqifDatatypeDefinitionReal = (DatatypeDefinitionReal)reqifDatatypeDefinition;
        NativeDataType nativeDataType = ((NativeDataTypeKey)dataTypeDefinitionGroveThing.getNativeThing()).getNativeDataType();
        assert (reqifDatatypeDefinitionRecordMap.containsKey((Object)nativeDataType));
        ReqifDatatypeRecord reqifDatatypeRecord = reqifDatatypeDefinitionRecordMap.get((Object)nativeDataType);
        assert (reqifDatatypeRecord instanceof ReqifDatatypeDoubleRecord);
        ReqifDatatypeDoubleRecord reqifDatatypeDoubleRecord = (ReqifDatatypeDoubleRecord)reqifDatatypeRecord;
        reqifDatatypeDefinitionReal.setAccuracy(BigInteger.valueOf(reqifDatatypeDoubleRecord.accuracy));
        reqifDatatypeDefinitionReal.setMax(reqifDatatypeDoubleRecord.max.doubleValue());
        reqifDatatypeDefinitionReal.setMin(reqifDatatypeDoubleRecord.min.doubleValue());
    }

    private static void convertDataTypeDefinitionReqIfDatatypeDefinitionString(GroveThing dataTypeDefinitionGroveThing, DatatypeDefinition reqifDatatypeDefinition) {
        assert (reqifDatatypeDefinition instanceof DatatypeDefinitionString);
        DatatypeDefinitionString reqifDatatypeDefinitionString = (DatatypeDefinitionString)reqifDatatypeDefinition;
        NativeDataType nativeDataType = ((NativeDataTypeKey)dataTypeDefinitionGroveThing.getNativeThing()).getNativeDataType();
        assert (reqifDatatypeDefinitionRecordMap.containsKey((Object)nativeDataType));
        ReqifDatatypeRecord reqifDatatypeRecord = reqifDatatypeDefinitionRecordMap.get((Object)nativeDataType);
        assert (reqifDatatypeRecord instanceof ReqifDatatypeStringRecord);
        ReqifDatatypeStringRecord reqifDatatypeStringRecord = (ReqifDatatypeStringRecord)reqifDatatypeRecord;
        reqifDatatypeDefinitionString.setMaxLength(BigInteger.valueOf(reqifDatatypeStringRecord.maxLength));
    }

    private static class ReqifDatatypeDoubleRecord
    implements ReqifDatatypeRecord {
        final Long accuracy;
        final Double max;
        final Double min;

        ReqifDatatypeDoubleRecord(Long accuracy, Double max, Double min) {
            this.accuracy = accuracy;
            this.max = max;
            this.min = min;
        }
    }

    private static class ReqifDatatypeIntegerRecord
    implements ReqifDatatypeRecord {
        final Long max;
        final Long min;

        ReqifDatatypeIntegerRecord(Long max, Long min) {
            this.max = max;
            this.min = min;
        }
    }

    private static interface ReqifDatatypeRecord {
    }

    private static class ReqifDatatypeStringRecord
    implements ReqifDatatypeRecord {
        final Long maxLength;

        ReqifDatatypeStringRecord(Long maxLength) {
            this.maxLength = maxLength;
        }
    }
}

