/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.util;

import java.math.BigInteger;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.xhtml.XhtmlDivType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlFactory;

public class DataConverters {
    private static final ZoneId zoneIdZ = ZoneId.of("Z");
    private static final TimeZone timeZoneZ = TimeZone.getTimeZone(zoneIdZ);

    private DataConverters() {
    }

    public static GregorianCalendar dateToGregorianCalendar(Date value) {
        assert (Objects.nonNull(value));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(value);
        gregorianCalendar.setTimeZone(timeZoneZ);
        return gregorianCalendar;
    }

    public static BigInteger idToBigInteger(Id value) {
        assert (Objects.nonNull(value));
        return BigInteger.valueOf(value.getId());
    }

    public static BigInteger integerToBigInteger(Integer value) {
        assert (Objects.nonNull(value));
        return BigInteger.valueOf(value.intValue());
    }

    public static BigInteger longToBigInteger(Long value) {
        assert (Objects.nonNull(value));
        return BigInteger.valueOf(value);
    }

    public static XhtmlContent wordMlStringToXhtmlContent(String value) {
        assert (Objects.nonNull(value));
        value = value.replaceAll("<[^>]*>", " ").replaceAll("[ \t\n]+", " ");
        XhtmlContent xhtmlContent = ReqIF10Factory.eINSTANCE.createXhtmlContent();
        XhtmlDivType div = XhtmlFactory.eINSTANCE.createXhtmlDivType();
        FeatureMap featureMap = div.getMixed();
        FeatureMapUtil.addText((FeatureMap)featureMap, (String)value);
        xhtmlContent.setXhtml((EObject)div);
        return xhtmlContent;
    }
}

