/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.excel.pojo;

import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.ECell;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EFile;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EHeaderCell;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EHeaderRow;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.ERow;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EWorksheet;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelToPojoOperation {
    private final File file;

    public ExcelToPojoOperation(String excelFile) {
        this(new File(excelFile));
    }

    public ExcelToPojoOperation(File file) {
        this.file = file;
    }

    public EFile run() {
        EFile eFile = new EFile(this.file.getAbsolutePath());
        eFile.getResults().log("Reading input: " + this.file.getAbsolutePath());
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            try (InputStreamReader inputStream = null;){
                try {
                    xmlReader.setContentHandler(new ExcelSaxHandler(new InternalRowProcessor(eFile), true));
                    inputStream = new InputStreamReader(this.file.toURL().openStream(), "UTF-8");
                    xmlReader.parse(new InputSource(inputStream));
                }
                catch (Exception ex) {
                    eFile.getResults().errorf("Exception in parsing import (see log for details) %s\n", Strings.isValid(ex.getLocalizedMessage()) ? ex.getLocalizedMessage() : "");
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            eFile.getResults().errorf("Exception reading input: %s", Lib.exceptionToString(ex));
        }
        return eFile;
    }

    private static final class InternalRowProcessor
    implements RowProcessor {
        private int rowNum = 1;
        private final XResultData rd;
        private EWorksheet eSheet;
        private final EFile eFile;
        private final Map<Integer, EHeaderCell> idToHeaderCell = new HashMap<Integer, EHeaderCell>();

        protected InternalRowProcessor(EFile eFile) {
            this.eFile = eFile;
            this.rd = eFile.getResults();
        }

        @Override
        public void processEmptyRow() {
        }

        @Override
        public void processCommentRow(String[] row) {
        }

        @Override
        public void reachedEndOfWorksheet() {
        }

        @Override
        public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
        }

        @Override
        public void foundStartOfWorksheet(String sheetName) {
            this.eSheet = new EWorksheet(this.eFile.getWorkbook(), sheetName);
        }

        @Override
        public void processHeaderRow(String[] headerRow) {
            EHeaderRow hRow = new EHeaderRow(this.eSheet);
            int x = 1;
            String[] stringArray = headerRow;
            int n = headerRow.length;
            int n2 = 0;
            while (n2 < n) {
                String headerStr = stringArray[n2];
                EHeaderCell hCell = new EHeaderCell(hRow, headerStr, x);
                this.idToHeaderCell.put(x - 1, hCell);
                ++x;
                ++n2;
            }
        }

        @Override
        public void processRow(String[] cols) {
            ++this.rowNum;
            boolean fullRow = false;
            int i = 0;
            while (i < cols.length) {
                if (Strings.isValid(cols[i])) {
                    fullRow = true;
                    break;
                }
                ++i;
            }
            if (!fullRow) {
                this.rd.warning("Empty Row Found => " + this.rowNum + " skipping...");
                return;
            }
            ERow row = new ERow(this.eSheet, this.rowNum);
            int colNum = 0;
            while (colNum < cols.length) {
                EHeaderCell hCell = this.idToHeaderCell.get(colNum);
                String value = cols[colNum];
                if (value == null) {
                    value = "";
                }
                new ECell(row, hCell, value);
                ++colNum;
            }
        }
    }
}

