/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.applications;

import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitable;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitor;
import org.eclipse.osee.jaxrs.server.internal.applications.AbstractJaxRsApplicationContainer;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsApplicationRegistry;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsProvider;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsProviders;
import org.eclipse.osee.logger.Log;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpService;

public abstract class AbstractJaxRsContainer<H extends HttpServlet, C extends AbstractJaxRsApplicationContainer, F extends JaxRsProvider>
implements JaxRsApplicationRegistry.JaxRsContainer,
JaxRsVisitable,
JaxRsProviders {
    private final Log logger;
    private final HttpService httpService;
    private final Dictionary<String, Object> props;
    private final ConcurrentHashMap<String, C> applications = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, F> providers = new ConcurrentHashMap();
    private final Map<String, String> componentToContext = new ConcurrentHashMap<String, String>();
    private final AtomicReference<String> servletContextName = new AtomicReference();
    private final AtomicBoolean isRegistered = new AtomicBoolean(false);
    private volatile H baseJaxsRsServlet;

    public AbstractJaxRsContainer(Log logger, HttpService httpService, Dictionary<String, Object> props) {
        this.logger = logger;
        this.httpService = httpService;
        this.props = props;
    }

    protected HttpService getHttpService() {
        return this.httpService;
    }

    protected Dictionary<String, Object> getServletProperties() {
        return this.props;
    }

    protected H getBaseServlet() {
        return this.baseJaxsRsServlet;
    }

    @Override
    public String getServletContext() {
        return this.servletContextName.get();
    }

    @Override
    public void setServletContext(String contextName) {
        this.servletContextName.set(contextName);
    }

    @Override
    public boolean isEmpty() {
        return this.applications.isEmpty() && this.providers.isEmpty();
    }

    @Override
    public boolean hasProviders() {
        return !this.providers.isEmpty();
    }

    @Override
    public Iterable<? extends JaxRsProvider> getProviders() {
        return this.providers.values();
    }

    @Override
    public void accept(JaxRsVisitor visitor) {
        visitor.onServletContext(this.getServletContext(), this.applications.size());
        for (AbstractJaxRsApplicationContainer abstractJaxRsApplicationContainer : this.applications.values()) {
            abstractJaxRsApplicationContainer.accept(visitor);
        }
        for (Map.Entry entry : this.providers.entrySet()) {
            JaxRsProvider value = (JaxRsProvider)entry.getValue();
            visitor.onProvider((String)entry.getKey(), value.getBundle(), value.getProvider());
        }
    }

    protected abstract C createApplicationContainer(String var1);

    protected abstract H createBaseJaxsRsServlet(JaxRsVisitable var1);

    protected abstract void startContainer(C var1);

    protected abstract void stopContainer(C var1);

    protected abstract F createJaxRsProvider(Bundle var1, Object var2);

    private C getContextContainerInitIfNull(String applicationContext) {
        C newContainer;
        AbstractJaxRsApplicationContainer container = (AbstractJaxRsApplicationContainer)this.applications.get(applicationContext);
        if (container == null && (container = (AbstractJaxRsApplicationContainer)this.applications.putIfAbsent(applicationContext, newContainer = this.createApplicationContainer(applicationContext))) == null) {
            container = newContainer;
        }
        return (C)container;
    }

    private C getContextContainerOrNull(String applicationContext) {
        return (C)((AbstractJaxRsApplicationContainer)this.applications.get(applicationContext));
    }

    @Override
    public synchronized void addApplication(String componentName, String applicationContext, Bundle bundle, Application application) {
        this.logger.trace("Add Application - [%s] - application[%s]", new Object[]{this, componentName});
        this.startServlet();
        C container = this.getContextContainerInitIfNull(applicationContext);
        this.stopContainer(container);
        ((AbstractJaxRsApplicationContainer)container).add(componentName, bundle, application);
        this.componentToContext.put(componentName, applicationContext);
        try {
            this.startContainer(container);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error activating application [%s] on [%s]", new Object[]{this, componentName});
        }
    }

    @Override
    public synchronized void removeApplication(String componentName) {
        this.logger.trace("Remove Application - [%s] - application[%s]", new Object[]{this, componentName});
        String contextName = this.componentToContext.remove(componentName);
        C container = this.getContextContainerOrNull(contextName);
        if (container != null) {
            this.stopContainer(container);
            ((AbstractJaxRsApplicationContainer)container).remove(componentName);
            if (((AbstractJaxRsApplicationContainer)container).isEmpty()) {
                this.applications.remove(contextName);
            } else {
                this.startContainer(container);
            }
        }
    }

    private void registerProviders() {
        this.startServlet();
        for (AbstractJaxRsApplicationContainer container : this.applications.values()) {
            this.stopContainer(container);
            try {
                this.startContainer(container);
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, "Error starting container [%s] on [%s]", new Object[]{this, container});
            }
        }
    }

    @Override
    public synchronized void addProvider(String componentName, Bundle bundle, Object provider) {
        this.logger.trace("Add Provider - [%s] - provider[%s]", new Object[]{this, componentName});
        F entry = this.createJaxRsProvider(bundle, provider);
        this.providers.put(componentName, entry);
        this.registerProviders();
    }

    @Override
    public synchronized void removeProvider(String componentName) {
        this.logger.trace("Remove Provider - [%s] - provider[%s]", new Object[]{this, componentName});
        JaxRsProvider feature = (JaxRsProvider)this.providers.remove(componentName);
        if (feature != null) {
            for (Map.Entry<String, C> entry : this.applications.entrySet()) {
                AbstractJaxRsApplicationContainer container = (AbstractJaxRsApplicationContainer)entry.getValue();
                this.stopContainer(container);
                if (container.isEmpty()) {
                    this.applications.remove(entry.getKey());
                    continue;
                }
                this.startContainer(container);
            }
        }
    }

    @Override
    public synchronized void start() {
        this.startServlet();
        for (AbstractJaxRsApplicationContainer container : this.applications.values()) {
            this.startContainer(container);
        }
    }

    @Override
    public synchronized void stop() {
        for (AbstractJaxRsApplicationContainer container : this.applications.values()) {
            this.stopContainer(container);
        }
        this.stopServlet();
    }

    private void startServlet() {
        if (!this.isRegistered.getAndSet(true)) {
            this.baseJaxsRsServlet = this.createBaseJaxsRsServlet(this);
            this.logger.trace("Register Servlet - [%s] - [%s]", new Object[]{this, this.baseJaxsRsServlet});
            try {
                String contextName = this.getServletContext();
                this.getHttpService().registerServlet(contextName, this.baseJaxsRsServlet, this.props, null);
            }
            catch (Exception ex) {
                throw new OseeWebApplicationException((Throwable)ex, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Error registering servlet [%s] ", new Object[]{this.servletContextName});
            }
        }
    }

    private void stopServlet() {
        if (this.isRegistered.getAndSet(false)) {
            String contextName = this.getServletContext();
            this.logger.trace("De-register Servlet - [%s] - [%s]", new Object[]{this, this.baseJaxsRsServlet});
            this.getHttpService().unregister(contextName);
            this.baseJaxsRsServlet = null;
        }
    }

    public String toString() {
        return "JaxRsContainerImpl [id=" + Integer.toHexString(this.hashCode()) + ", contextName=" + this.servletContextName + "]";
    }
}

