/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters;

import com.google.common.io.ByteSource;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.eclipse.osee.framework.jdk.core.type.Identity;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;

public class ApplicationClient
extends Client
implements OAuthClient {
    private static final long serialVersionUID = -5666467776236248089L;
    private final long clientUuid;
    private final long subjectId;
    private final String guid;
    private ByteSource logoSupplier;

    public ApplicationClient(long clientUuid, long subjectId, String guid) {
        this.clientUuid = clientUuid;
        this.subjectId = subjectId;
        this.guid = guid;
    }

    @Override
    public long getClientUuid() {
        return this.clientUuid;
    }

    @Override
    public long getSubjectId() {
        return this.subjectId;
    }

    public String getGuid() {
        return this.guid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Identity) {
            Identity identity = (Identity)obj;
            if (this.getGuid() == identity.getGuid()) {
                equal = true;
            } else if (this.getGuid() != null) {
                equal = this.getGuid().equals(identity.getGuid());
            }
        }
        return equal;
    }

    @Override
    public boolean hasApplicationLogoSupplier() {
        return this.logoSupplier != null;
    }

    @Override
    public ByteSource getApplicationLogoSupplier() {
        return this.logoSupplier;
    }

    public void setApplicationLogoSupplier(ByteSource logoSupplier) {
        this.logoSupplier = logoSupplier;
    }
}

