/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.action;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class ActionServiceOperations {
    private final AtsApi atsApi;

    public ActionServiceOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public String getActionStateJson(Collection<IAtsWorkItem> workItems, JsonFactory jsonFactory) {
        try {
            JsonGenerator writer = null;
            StringWriter stringWriter = new StringWriter();
            writer = jsonFactory.createGenerator((Writer)stringWriter);
            if (workItems.size() > 1) {
                writer.writeStartArray();
            }
            for (IAtsWorkItem workItem : workItems) {
                writer.writeStartObject();
                writer.writeStringField("id", workItem.getIdString());
                writer.writeStringField("atsId", workItem.getAtsId());
                writer.writeStringField("legacyId", (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.LegacyPcrId, (Object)""));
                writer.writeStringField("stateType", workItem.getCurrentStateType().name());
                writer.writeStringField("state", this.atsApi.getWorkItemService().getCurrentStateName(workItem));
                writer.writeEndObject();
            }
            if (workItems.size() > 1) {
                writer.writeEndArray();
            }
            writer.close();
            return stringWriter.toString();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }
}

