/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review;

import java.rmi.activation.Activator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.AtsConfigKey;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewDefectManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.review.ReviewDefectError;
import org.eclipse.osee.ats.core.util.ArtifactValueProvider;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;

public class ReviewDefectManager
implements IAtsPeerReviewDefectManager {
    private static final String DEFECT_ITEM_TAG = "Item";
    private final Matcher defectMatcher = Pattern.compile("<Item>(.*?)</Item>", 40).matcher("");
    private final IValueProvider valueProvider;
    private Set<ReviewDefectItem> defectItems = null;
    private AtsApi atsApi;
    private Boolean asGuid;
    private IAtsPeerToPeerReview review;

    public ReviewDefectManager(IAtsPeerToPeerReview review, AtsApi atsApi) {
        this.atsApi = atsApi;
        this.valueProvider = new ArtifactValueProvider(review.getStoreObject(), (AttributeTypeToken)AtsAttributeTypes.ReviewDefect, atsApi);
        this.review = review;
    }

    public ReviewDefectManager(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public String getHtml() {
        if (this.getDefectItems().isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(AHTML.addSpace((int)1)) + AHTML.getLabelStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Defects"));
        sb.append(this.getTable());
        return sb.toString();
    }

    public void ensureLoaded() {
        if (this.defectItems == null) {
            this.defectItems = new HashSet<ReviewDefectItem>();
            for (String xml : this.valueProvider.getValues()) {
                this.defectMatcher.reset(xml);
                while (this.defectMatcher.find()) {
                    ReviewDefectItem item = new ReviewDefectItem(this.defectMatcher.group(), false, this.review);
                    this.defectItems.add(item);
                }
            }
        }
    }

    public Set<ReviewDefectItem> getDefectItems() {
        this.ensureLoaded();
        return this.defectItems;
    }

    public int getNumMajor(AtsUser user) {
        int x = 0;
        for (ReviewDefectItem dItem : this.getDefectItems()) {
            if (dItem.getSeverity() != ReviewDefectItem.Severity.Major || !dItem.getUserId().equals(user.getUserId())) continue;
            ++x;
        }
        return x;
    }

    public int getNumMinor(AtsUser user) {
        int x = 0;
        for (ReviewDefectItem dItem : this.getDefectItems()) {
            if (dItem.getSeverity() != ReviewDefectItem.Severity.Minor || !dItem.getUserId().equals(user.getUserId())) continue;
            ++x;
        }
        return x;
    }

    public int getNumIssues(AtsUser user) {
        int x = 0;
        for (ReviewDefectItem dItem : this.getDefectItems()) {
            if (dItem.getSeverity() != ReviewDefectItem.Severity.Issue || !dItem.getUserId().equals(user.getUserId())) continue;
            ++x;
        }
        return x;
    }

    public int getNumMajor() {
        int x = 0;
        for (ReviewDefectItem dItem : this.getDefectItems()) {
            if (dItem.getSeverity() != ReviewDefectItem.Severity.Major) continue;
            ++x;
        }
        return x;
    }

    public int getNumMinor() {
        int x = 0;
        for (ReviewDefectItem dItem : this.getDefectItems()) {
            if (dItem.getSeverity() != ReviewDefectItem.Severity.Minor) continue;
            ++x;
        }
        return x;
    }

    public int getNumIssues() {
        int x = 0;
        for (ReviewDefectItem dItem : this.getDefectItems()) {
            if (dItem.getSeverity() != ReviewDefectItem.Severity.Issue) continue;
            ++x;
        }
        return x;
    }

    private boolean asGuid() {
        if (this.asGuid == null) {
            this.asGuid = "true".equals(this.atsApi.getConfigValue(AtsConfigKey.PeerDefectAsGuid, "false"));
        }
        return this.asGuid;
    }

    private List<ReviewDefectItem> getStoredDefectItems(IAtsPeerToPeerReview peerRev) {
        ArrayList<ReviewDefectItem> storedDefectItems = new ArrayList<ReviewDefectItem>();
        for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)peerRev, (AttributeTypeToken)AtsAttributeTypes.ReviewDefect)) {
            ReviewDefectItem storedRole = new ReviewDefectItem((String)attr.getValue(), this.asGuid(), peerRev);
            storedDefectItems.add(storedRole);
        }
        return storedDefectItems;
    }

    public void saveToArtifact(IAtsPeerToPeerReview peerRev, IAtsChangeSet changes) {
        for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)peerRev, (AttributeTypeToken)AtsAttributeTypes.ReviewDefect)) {
            ReviewDefectItem storedDefect = new ReviewDefectItem((String)attr.getValue(), this.asGuid(), peerRev);
            for (ReviewDefectItem defectItem : this.getDefectItems()) {
                if (!defectItem.equals((Object)storedDefect)) continue;
                changes.setAttribute((IAtsWorkItem)peerRev, (AttributeId)attr, (Object)AXml.addTagData((String)DEFECT_ITEM_TAG, (String)defectItem.toXml(this.asGuid())));
            }
        }
        List<ReviewDefectItem> storedDefectItems = this.getStoredDefectItems(peerRev);
        for (ReviewDefectItem delItem : Collections.setComplement(storedDefectItems, this.getDefectItems())) {
            for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)peerRev, (AttributeTypeToken)AtsAttributeTypes.ReviewDefect)) {
                ReviewDefectItem storedItem = new ReviewDefectItem((String)attr.getValue(), this.asGuid(), peerRev);
                if (!storedItem.equals((Object)delItem)) continue;
                changes.deleteAttribute((IAtsWorkItem)peerRev, attr);
            }
        }
        for (ReviewDefectItem newDefect : Collections.setComplement(this.getDefectItems(), storedDefectItems)) {
            changes.addAttribute((IAtsObject)peerRev, (AttributeTypeToken)AtsAttributeTypes.ReviewDefect, (Object)AXml.addTagData((String)DEFECT_ITEM_TAG, (String)newDefect.toXml(this.asGuid())));
        }
    }

    public void addOrUpdateDefectItem(ReviewDefectItem defectItem) {
        Set<ReviewDefectItem> defectItems = this.getDefectItems();
        boolean found = false;
        for (ReviewDefectItem dItem : defectItems) {
            if (!defectItem.equals((Object)dItem)) continue;
            dItem.update(defectItem, this.asGuid(), this.review);
            found = true;
        }
        if (!found) {
            defectItems.add(defectItem);
        }
    }

    public void removeDefectItem(ReviewDefectItem defectItem) {
        Set<ReviewDefectItem> defectItems = this.getDefectItems();
        defectItems.remove(defectItem);
    }

    public void addDefectItem(String description) {
        ReviewDefectItem item = new ReviewDefectItem();
        item.setUserId(this.atsApi.getUserService().getCurrentUserId());
        item.setDescription(description);
        this.addOrUpdateDefectItem(item);
    }

    public String getTable() {
        StringBuilder builder = new StringBuilder();
        builder.append("<TABLE BORDER=\"1\" cellspacing=\"1\" cellpadding=\"3%\" width=\"100%\"><THEAD><TR><TH>Severity</TH><TH>Disposition</TH><TH>Injection</TH><TH>User</TH><TH>Date</TH><TH>Description</TH><TH>Location</TH><TH>Resolution</TH><TH>Id</TH><TH>Closed</TH><TH>Closed</TH></THEAD></TR>");
        for (ReviewDefectItem item : this.getDefectItems()) {
            String userId = item.getUserId();
            AtsUser user = this.atsApi.getUserService().getUserByUserId(userId);
            builder.append("<TR>");
            builder.append("<TD>" + item.getSeverity() + "</TD>");
            builder.append("<TD>" + item.getDisposition() + "</TD>");
            builder.append("<TD>" + item.getInjectionActivity() + "</TD>");
            if (user != null && user.equals((Object)this.atsApi.getUserService().getCurrentUser())) {
                builder.append("<TD bgcolor=\"#CCCCCC\">" + user.getName() + "</TD>");
            } else {
                builder.append("<TD>NONE</TD>");
            }
            builder.append("<TD>" + DateUtil.getMMDDYYHHMM((Date)item.getDate()) + "</TD>");
            builder.append("<TD>" + item.getDescription() + "</TD>");
            builder.append("<TD>" + item.getLocation() + "</TD>");
            builder.append("<TD>" + item.getResolution() + "</TD>");
            builder.append("<TD>" + item.getId() + "</TD>");
            builder.append("<TD>" + item.isClosed() + "</TD>");
            String closedUserId = item.getClosedUserId();
            AtsUser closedUser = this.atsApi.getUserService().getUserByUserId(closedUserId);
            builder.append("<TD>" + closedUser.getName() + "</TD>");
            builder.append("</TR>");
        }
        builder.append("</TABLE>");
        return builder.toString();
    }

    public static ReviewDefectError isValid(ArtifactToken artifact) {
        try {
            ReviewDefectManager mgr;
            ReviewDefectError result;
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview}) && !(result = ReviewDefectManager.isValid((mgr = new ReviewDefectManager((IAtsPeerToPeerReview)artifact, AtsApiService.get())).getDefectItems())).isOK()) {
                return result;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return ReviewDefectError.ExceptionValidatingRoles;
        }
        return ReviewDefectError.None;
    }

    public static ReviewDefectError isValid(Set<ReviewDefectItem> defectItems) {
        try {
            for (ReviewDefectItem item : defectItems) {
                if (item.isClosed() && item.getDisposition() != ReviewDefectItem.Disposition.None && (item.getSeverity() != ReviewDefectItem.Severity.None || item.getDisposition() == ReviewDefectItem.Disposition.Duplicate || item.getDisposition() == ReviewDefectItem.Disposition.Reject)) continue;
                return ReviewDefectError.AllItemsMustBeMarkedAndClosed;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return ReviewDefectError.ExceptionValidatingRoles;
        }
        return ReviewDefectError.None;
    }
}

