/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task.related;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.IAtsTaskProvider;
import org.eclipse.osee.ats.api.task.related.DerivedFromTaskData;
import org.eclipse.osee.ats.api.task.related.IAtsTaskRelatedService;
import org.eclipse.osee.ats.api.task.related.IAutoGenTaskData;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.task.internal.AtsTaskProviderCollector;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;

public abstract class AbstractAtsTaskRelatedService
implements IAtsTaskRelatedService {
    protected final AtsApi atsApi;

    public AbstractAtsTaskRelatedService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public DerivedFromTaskData populateDerivedFromTaskData(DerivedFromTaskData trd) {
        boolean deleted = (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)trd.getTask(), (AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactDeleted, (Object)false);
        trd.setDeleted(deleted);
        this.getDerivedTeamWf(trd);
        if (trd.getResults().isErrors()) {
            return trd;
        }
        this.getRelatedChangedArtifact(trd);
        if (trd.getResults().isErrors()) {
            return trd;
        }
        this.getRelatedChangedArtifactFromChangeReport(trd);
        if (trd.getResults().isErrors()) {
            return trd;
        }
        return trd;
    }

    private DerivedFromTaskData getRelatedChangedArtifact(DerivedFromTaskData trd) {
        ArtifactId artifact;
        if (trd.getDerivedFromTeamWf() == null) {
            trd.getResults().error("Requirement Team Workflow can't be found\n");
        }
        if ((artifact = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)trd.getTask(), (AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, (Object)ArtifactId.SENTINEL)).isValid()) {
            this.getRelatedChangedArtifact(trd, artifact);
            return trd;
        }
        trd.getResults().errorf("No related change artifact for %s", new Object[]{trd.getTask().toStringWithId()});
        return trd;
    }

    public DerivedFromTaskData getDerivedTeamWf(DerivedFromTaskData trd) {
        if (trd.getTask() == null) {
            trd.getResults().error("Task must be specified");
        }
        IAtsTeamWorkflow teamWf = trd.getTask().getParentTeamWorkflow();
        ArtifactToken derivedFromArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)teamWf, AtsRelationTypes.Derive_From);
        if (derivedFromArt.isValid()) {
            trd.setDerived(true);
            if (!derivedFromArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                trd.getResults().error("Derived-From is not a Team Workflow");
            }
            teamWf = this.atsApi.getWorkItemService().getTeamWf(derivedFromArt);
            trd.setDerivedFromTeamWf(teamWf);
        } else {
            trd.setDerived(false);
            trd.setDerivedFromTeamWf(teamWf);
        }
        return trd;
    }

    private void getRelatedChangedArtifact(DerivedFromTaskData dftd, ArtifactId relatedArtifact) {
        IAutoGenTaskData nameData = this.atsApi.getTaskRelatedService().getAutoGenTaskData(dftd.getTask());
        if (nameData == null) {
            dftd.getResults().error("Can't retrieve Auto Gen Task Data");
            return;
        }
        if (nameData.isNoChangedArtifact()) {
            dftd.getResults().error("No changed artifact to show");
            return;
        }
        if (!nameData.hasRelatedArt()) {
            dftd.getResults().error("Task is not against changed artifact or is named incorrectly.\n\nMust be \"Code|Test \"<partition>\" for \"<requirement name>\"");
        }
        this.findHeadArtifact(dftd, relatedArtifact, nameData.getAddDetails());
        if (dftd.getResults().isErrors()) {
            return;
        }
        if (dftd.getHeadArtifact() == null) {
            dftd.getResults().error("Corresponding changed artifact can not be found.");
        }
        ArtifactToken latestArt = null;
        if (!this.atsApi.getStoreService().isDeleted((ArtifactId)dftd.getHeadArtifact())) {
            latestArt = this.atsApi.getQueryService().getArtifact((ArtifactId)dftd.getHeadArtifact(), (BranchId)this.atsApi.getAtsBranch(), DeletionFlag.INCLUDE_DELETED);
            dftd.setLatestArt(latestArt);
        }
    }

    private void findHeadArtifact(DerivedFromTaskData trd, ArtifactId relatedArtifact, String addDetails) {
        TransactionToken transaction;
        if (trd.getDerivedFromTeamWf() == null) {
            trd.getResults().error("Derived From Team Wf can not be null");
            return;
        }
        boolean foundBranchOrTransId = false;
        BranchToken workingBranch = this.atsApi.getBranchService().getWorkingBranchInWork(trd.getDerivedFromTeamWf());
        if (workingBranch.isValid()) {
            ArtifactToken headArt = this.atsApi.getQueryService().getArtifact(relatedArtifact, (BranchId)workingBranch, DeletionFlag.INCLUDE_DELETED);
            trd.setHeadArtifact(headArt);
            foundBranchOrTransId = true;
        }
        if (!foundBranchOrTransId && (transaction = this.atsApi.getBranchService().getEarliestTransactionId(trd.getDerivedFromTeamWf())).isValid()) {
            ArtifactToken headArt = this.atsApi.getQueryService().getHistoricalArtifactOrNull(relatedArtifact, transaction, DeletionFlag.INCLUDE_DELETED);
            trd.setHeadArtifact(headArt);
            foundBranchOrTransId = true;
        }
        if (!foundBranchOrTransId) {
            trd.getResults().error("Derived relation but no working branch or transaction found.");
        }
    }

    public boolean isAutoGenTask(IAtsTask task) {
        for (IAtsTaskProvider provider : AtsTaskProviderCollector.getTaskProviders()) {
            if (!provider.isAutoGen(task)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoGenTasks(Collection<IAtsTask> tasks) {
        for (IAtsTask task : tasks) {
            if (this.isAutoGenTask(task)) continue;
            return false;
        }
        return true;
    }

    public boolean isAutoGenChangeReportRelatedTasks(Collection<IAtsTask> tasks) {
        for (IAtsTask task : tasks) {
            if (this.isAutoGenChangeReportRelatedTask(task)) continue;
            return false;
        }
        return true;
    }

    public boolean isAutoGenChangeReportRelatedTask(IAtsTask task) {
        return this.isAutoGenTask(task) && this.atsApi.getAttributeResolver().getAttributeCount((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference) > 0;
    }
}

