/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.users;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.AtsConfigKey;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;

public abstract class SyncOseeAndUserDB {
    public static String OSEE_AUTORUN_USER_RELATIONS_CHECKED = "osee.autorun.userRelationsChecked";
    private final String LAST_DATE_ACCOUNT_LOGGED_ACTIVITY = "SELECT start_timestamp FROM osee_activity WHERE account_id = ? ORDER BY START_TIMESTAMP desc";
    public static String NO_EMAIL_STATIC_ID = "noEmail";
    public static String FIRST_NOTIFICATION_STATIC_ID = "FirstInactiveNotification";
    public static String SECOND_NOTIFICATION_STATIC_ID = "SecondInactiveNotification";
    protected XResultData results = null;
    protected final AtsApi atsApi;
    protected final boolean persist;
    protected final boolean debug;
    protected final JdbcClient jdbcClient;
    protected final String IGNORE_DUP_NAMES = "IgnoreDupNames";
    protected final List<ArtifactReadable> ignoreDupNames = new ArrayList<ArtifactReadable>();
    protected IAtsChangeSet changes;
    protected List<String> ignoreStaticIds;

    public SyncOseeAndUserDB(boolean persist, boolean debug, AtsApi atsApi) {
        this.jdbcClient = atsApi.getJdbcService().getClient();
        this.atsApi = atsApi;
        this.persist = persist;
        this.debug = debug;
    }

    protected abstract List<String> getIgnoreStaticIds();

    protected String getTitle() {
        return "Sync OSEE and User DB";
    }

    public XResultData run() {
        try {
            this.ignoreStaticIds = this.getIgnoreStaticIds();
            this.results = new XResultData(false);
            this.results.log(String.valueOf(this.getTitle()) + "\n");
            ArrayList<UserToken> users = new ArrayList<UserToken>();
            ElapsedTime time = new ElapsedTime("Loading Users", this.debug);
            for (ArtifactToken art : this.atsApi.getQueryService().getArtifacts(CoreArtifactTypes.User)) {
                UserToken userToken = this.createUserToken(art);
                users.add(userToken);
            }
            time.end();
            time = new ElapsedTime("Filtering Users", this.debug);
            List<UserToken> regUsers = users.stream().filter(u -> !SystemUser.values.contains(u)).filter(u -> org.eclipse.osee.framework.jdk.core.util.Collections.setIntersection(this.getUserStaticIds((UserToken)u), this.ignoreStaticIds).isEmpty()).collect(Collectors.toList());
            time.end();
            time = new ElapsedTime("testForDuplicates", this.debug);
            this.testForDuplicates(regUsers);
            time.end();
            if (this.results.isErrors()) {
                this.results.logf("\nError: Error: Error: Sync aborted cause duplicates found; <b>RESOLVE THESE FIRST!!</b>\n", new Object[0]);
            } else {
                if (this.persist) {
                    AtsUser user = this.atsApi.getUserService().getCurrentUserOrNull();
                    if (user == null) {
                        user = this.atsApi.getUserService().getUserById((ArtifactId)SystemUser.OseeSystem);
                    }
                    this.changes = this.atsApi.createChangeSet(this.getTitle(), user);
                }
                time = new ElapsedTime("testCauseWentInactive", this.debug);
                this.testInactiveCauseWentInactive(regUsers);
                time.end();
                time = new ElapsedTime("testCauseHaveNotAccessed", this.debug);
                this.testInactiveCauseHaveNotAccessed(regUsers);
                time.end();
                time = new ElapsedTime("testUserGroups", this.debug);
                this.testUserGroups(regUsers);
                time.end();
                time = new ElapsedTime("testUserAttributes", this.debug);
                this.testUserAttributes(regUsers);
                time.end();
            }
            if (this.changes != null && this.persist) {
                TransactionToken tx = this.changes.executeIfNeeded();
                if (tx != null) {
                    this.results.logf("\nChanges persisted with Transaction %s\n", new Object[]{tx.getIdString()});
                } else {
                    this.results.logf("\nNo Changes to Persist\n", new Object[0]);
                }
            } else {
                this.results.logf("\nReport Only - Changes NOT persisted\n", new Object[0]);
            }
            this.results.log("\nProcessed " + users.size() + " users!\n");
        }
        catch (Exception ex) {
            this.results.errorf("\nException: %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return this.results;
    }

    protected abstract void testUserGroups(List<UserToken> var1);

    protected void addMember(IUserGroup everyoneGroup, UserToken user) {
        this.changes.relate((ArtifactId)everyoneGroup.getArtifact(), CoreRelationTypes.Users_User, (ArtifactId)user);
    }

    protected abstract AtsUser getUserByUserId(String var1);

    protected abstract Date getTxDate(ArtifactToken var1);

    protected List<String> getUserStaticIds(UserToken user) {
        return this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)user.getArtifact(), (AttributeTypeToken)CoreAttributeTypes.StaticId);
    }

    protected void testUserAttributes(List<UserToken> regUsers) throws Exception {
        for (UserToken user : regUsers) {
            AtsUser atsUser;
            if (!user.isActive() || (atsUser = this.getUserByUserId(user.getUserId())) == null) continue;
            String wssoBemsId = atsUser.getUserId();
            String wssoLoginId = (String)atsUser.getLoginIds().get(0);
            String wssoUserName = atsUser.getName();
            String wssoMail = atsUser.getEmail();
            String wssoPhone = atsUser.getPhone();
            if (Strings.isInvalid((String)wssoUserName)) continue;
            if (this.debug && !user.getLoginIds().contains(wssoLoginId) && Strings.isValid((String)wssoLoginId)) {
                this.results.warningf("[%s] login ids [%s] appear invalid; should be [%s] - NO FIX\n", new Object[]{user.toStringWithId(), user.getLoginIds(), wssoLoginId});
            }
            if (wssoLoginId != null) {
                if (!EmailUtil.isEmailValid((String)wssoMail)) {
                    if (!this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)user.getArtifact(), (AttributeTypeToken)CoreAttributeTypes.StaticId).contains(NO_EMAIL_STATIC_ID) && this.debug) {
                        this.results.errorf("[%s] WSSO User Email [%s] is invalid\n", new Object[]{user.toStringWithId(), wssoMail});
                    }
                } else if (!user.getEmail().equals(wssoMail)) {
                    this.results.warningf("[%s] wsso.email [%s] != user.email [%s]\n", new Object[]{user.toStringWithId(), wssoMail, user.getEmail()});
                    if (this.persist) {
                        this.changes.setSoleAttributeValue((ArtifactId)user.getArtifact(), (AttributeTypeToken)CoreAttributeTypes.Email, (Object)wssoMail);
                        this.results.logf("Fixed Email to %s\n", new Object[]{wssoMail});
                    }
                }
            }
            String phone = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)user.getArtifact(), (AttributeTypeToken)CoreAttributeTypes.Phone, (Object)"");
            if (Strings.isValid((String)wssoPhone) && !wssoPhone.equals(phone)) {
                this.results.warningf("[%s] wsso.phone [%s] != user.phone [%s]\n", new Object[]{user.toStringWithId(), wssoPhone, phone});
                if (this.persist) {
                    this.changes.setSoleAttributeValue((ArtifactId)user.getArtifact(), (AttributeTypeToken)CoreAttributeTypes.Phone, (Object)wssoPhone);
                    this.results.log("Fixed");
                }
            }
            if (!wssoUserName.equals(user.getName())) {
                this.results.warningf("[%s] wsso.name [%s] != user.name [%s]\n", new Object[]{user.toStringWithId(), wssoUserName, user.getName()});
                if (this.persist) {
                    this.changes.setName(user.getArtifact(), wssoUserName);
                    this.results.log("Fixed");
                }
            }
            if (!wssoBemsId.equals(user.getUserId())) {
                if (!user.getUserId().matches("\\d{1,9}")) {
                    if (this.debug) {
                        this.results.warningf("[%s] wsso.bems [%s] invalid\n", new Object[]{user.toStringWithId(), wssoBemsId});
                    }
                } else {
                    this.results.warningf("[%s] wsso.bems [%s] != user.userId [%s]\n", new Object[]{wssoBemsId, user.getUserId(), user.toStringWithId()});
                    if (this.persist) {
                        this.changes.setSoleAttributeValue((ArtifactId)user.getArtifact(), (AttributeTypeToken)CoreAttributeTypes.UserId, (Object)wssoBemsId);
                        this.results.log("Fixed");
                    }
                }
            }
            if (user.getName().contains(",") || !this.debug) continue;
            this.results.errorf("[%s] name doesn't contain last, first??", new Object[]{user});
        }
    }

    private void testInactiveCauseWentInactive(List<UserToken> regUsers) throws Exception {
        for (UserToken user : regUsers) {
            AtsUser atsUser = this.getUserByUserId(user.getUserId());
            if (atsUser == null) continue;
            boolean inActive = false;
            if (!user.isActive()) continue;
            if (Strings.isInvalid((String)atsUser.getName())) {
                this.results.warningf("WssoUser record not found [%s]; Should set Inactive\n", new Object[]{user.toStringWithId()});
                inActive = true;
            } else if (!atsUser.isActive()) {
                this.results.warningf("User [%s] User.active [%s] != WssoUser.active [%s]; Should set Inactive\n", new Object[]{user.toStringWithId(), user.isActive(), atsUser.isActive()});
                inActive = true;
            }
            if (!inActive || !this.persist) continue;
            this.changes.setSoleAttributeValue((ArtifactId)user.getArtifact(), (AttributeTypeToken)CoreAttributeTypes.Active, (Object)atsUser.isActive());
            this.results.logf("Fixed Active to %s\n", new Object[]{atsUser.isActive()});
        }
    }

    private void testInactiveCauseHaveNotAccessed(List<UserToken> regUsers) throws Exception {
        this.results.logf("\ngetDaysTillFirstInActiveNotice %s\n", new Object[]{this.getDaysTillFirstInActiveNotice()});
        this.results.logf("getDaysTillLastInActiveNotice %s\n", new Object[]{this.getDaysTillLastInActiveNotice()});
        this.results.logf("getDaysTillInActive %s\n\n", new Object[]{this.getDaysTillInActive()});
        for (UserToken user : regUsers) {
            if (!user.isActive()) continue;
            int leastDaysOfActivity = this.getLeastDaysLastActivity(user);
            if (leastDaysOfActivity > this.getDaysTillInActive()) {
                this.disableUserAccount(user, leastDaysOfActivity);
                continue;
            }
            if (leastDaysOfActivity > this.getDaysTillLastInActiveNotice()) {
                this.sendInactivityNotification(user, leastDaysOfActivity, this.changes, false);
                continue;
            }
            if (leastDaysOfActivity > this.getDaysTillFirstInActiveNotice()) {
                this.sendInactivityNotification(user, leastDaysOfActivity, this.changes, true);
                continue;
            }
            if (!this.debug) continue;
            this.results.logf("Ignoring: %s days since login - userId %s - %s\n", new Object[]{leastDaysOfActivity, user.getUserId(), user.toStringWithId()});
        }
    }

    private void disableUserAccount(UserToken user, int leastDaysOfActivity) {
        this.results.warningf("De-Activate User not logged in for > %s days was %s for %s userId %s\n", new Object[]{this.getDaysTillInActive(), leastDaysOfActivity, user.toStringWithId(), user.getUserId()});
        if (this.persist) {
            this.changes.setSoleAttributeValue((ArtifactId)user.getArtifact(), (AttributeTypeToken)CoreAttributeTypes.Active, (Object)false);
            this.results.log("Fixed");
        }
    }

    protected void sendInactivityNotification(UserToken user, int leastDaysOfActivity, IAtsChangeSet changes, boolean first) {
        if (EmailUtil.isEmailInValid((String)user.getEmail())) {
            return;
        }
        String firstOrLastStr = first ? "First" : "Last";
        int firstOrLastDaysInt = first ? this.getDaysTillFirstInActiveNotice() : this.getDaysTillLastInActiveNotice();
        String firstOrLastStaticId = first ? FIRST_NOTIFICATION_STATIC_ID : SECOND_NOTIFICATION_STATIC_ID;
        this.results.warningf("Email %s Notice to User not logged in for > %s days was %s for %s userId %s\n", new Object[]{firstOrLastStr, firstOrLastDaysInt, leastDaysOfActivity, user.toStringWithId(), user.getUserId()});
        if (this.persist) {
            ArtifactReadable userArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(user.getId());
            if (userArt.getTags().contains(firstOrLastStaticId)) {
                return;
            }
            String fromEmail = this.atsApi.getConfigValue(AtsConfigKey.NoReplyEmail, "");
            if (EmailUtil.isEmailInValid((String)fromEmail)) {
                this.results.errorf(String.valueOf(AtsConfigKey.NoReplyEmail.name()) + " is not set; notifications disabled\n", new Object[0]);
                return;
            }
            String toEmail = user.getEmail();
            String subject = String.format("ACTION REQUIRED - OSEE Account Will Be Disabled - %s Notification", firstOrLastStr);
            this.atsApi.getNotificationService().sendNotifications(fromEmail, (Collection)org.eclipse.osee.framework.jdk.core.util.Collections.asList((Object[])new String[]{toEmail}), subject, "Your OSEE account has not been accessed in the past " + firstOrLastDaysInt + " days.<br/><br/>" + "<b>Please launch OSEE to continue account access.</b><br/><br/> " + "Otherwise the account will be automatically disabled.<br/><br/>" + "Account: " + user.toString());
            changes.addAttribute((ArtifactId)userArt, (AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)firstOrLastStaticId);
            this.results.log("Sent");
        }
    }

    protected Integer getLeastDaysLastActivity(UserToken user) {
        Integer lastActivityEntryDays;
        block7: {
            lastActivityEntryDays = 0;
            JdbcStatement chStmt = this.jdbcClient.getStatement();
            Date lastActivityDate = null;
            try {
                try {
                    Timestamp time;
                    chStmt.runPreparedQuery("SELECT start_timestamp FROM osee_activity WHERE account_id = ? ORDER BY START_TIMESTAMP desc", new Object[]{user.getIdString()});
                    if (chStmt.next() && (time = chStmt.getTimestamp("START_TIMESTAMP")) != null) {
                        lastActivityDate = new Date(time.getTime());
                        lastActivityEntryDays = DateUtil.getWorkingDaysBetween((Date)lastActivityDate, (Date)new Date());
                    }
                }
                catch (OseeCoreException ex) {
                    this.results.errorf("Exception %s", new Object[]{Lib.exceptionToString((Exception)((Object)ex))});
                    chStmt.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                chStmt.close();
                throw throwable;
            }
            chStmt.close();
        }
        ArtifactToken art = this.atsApi.getQueryService().getArtifact((ArtifactId)user);
        Date date = this.getTxDate(art);
        int userArtDaysInActive = DateUtil.getWorkingDaysBetween((Date)date, (Date)new Date());
        if (lastActivityEntryDays > 0 && lastActivityEntryDays < userArtDaysInActive) {
            return lastActivityEntryDays;
        }
        return userArtDaysInActive;
    }

    protected int getDaysTillInActive() {
        return 183;
    }

    protected int getDaysTillFirstInActiveNotice() {
        return 160;
    }

    protected int getDaysTillLastInActiveNotice() {
        return 175;
    }

    protected void testForDuplicates(List<UserToken> regUsers) throws Exception {
        HashSet<Long> duplicates = new HashSet<Long>();
        TreeMap<String, UserToken> userIdMap = new TreeMap<String, UserToken>();
        TreeMap<String, UserToken> nameMap = new TreeMap<String, UserToken>();
        boolean error = false;
        for (UserToken user : regUsers) {
            UserToken userIdInMap = (UserToken)userIdMap.get(user.getUserId());
            if (userIdMap.containsKey(user.getUserId())) {
                this.results.errorf("[%s] and [%s] have SAME USERIDs\n", new Object[]{user, userIdMap.get(user.getUserId())});
                duplicates.add(userIdInMap.getId());
                duplicates.add(user.getId());
                error = true;
            }
            UserToken nameInMap = (UserToken)nameMap.get(user.getName());
            if (nameMap.containsKey(user.getName()) && !this.ignoreDupNames.contains(user.getArtifact())) {
                this.results.errorf("[%s] and [%s] have SAME NAMES\n", new Object[]{user, nameMap.get(user.getName())});
                duplicates.add(nameInMap.getId());
                duplicates.add(user.getId());
                error = true;
            }
            nameMap.put(user.getName(), user);
            userIdMap.put(user.getUserId(), user);
        }
        if (error) {
            this.results.logf("\nDuplicates: %s\n", new Object[]{org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", duplicates)});
        }
    }

    private UserToken createUserToken(ArtifactToken art) {
        String email = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.Email, (Object)"");
        String userId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.UserId, (Object)"");
        boolean active = (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)false);
        List loginIds = this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.LoginId);
        UserToken user = UserToken.create((long)art.getId(), (String)art.getName(), (String)email, (String)userId, (boolean)active, (List)loginIds, Collections.emptyList());
        user.setArtifact(art);
        if (this.atsApi.getAttributeResolver().getAttributesToStringListFromArt(art, (AttributeTypeToken)CoreAttributeTypes.StaticId).contains("IgnoreDupNames")) {
            this.ignoreDupNames.add((ArtifactReadable)art);
        }
        return user;
    }
}

