/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.validator;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.core.util.ArtifactValueProvider;
import org.eclipse.osee.ats.core.validator.AtsXWidgetValidator;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsXCommitManagerValidator
extends AtsXWidgetValidator {
    public static final String ALL_BRANCHES_MUST_BE_COMMITTED = "All branches must be configured for commit.";
    protected static final String ALL_BRANCHES_MUST_BE_CONFIGURED_FOR_COMMIT = "All branches must be configured for commit.";

    @Override
    public WidgetResult validateTransition(IAtsWorkItem workItem, IValueProvider provider, WidgetDefinition widgetDef, StateDefinition fromStateDef, StateDefinition toStateDef, AtsApi atsServices) {
        WidgetResult result = WidgetResult.Success;
        if ("XCommitManager".equals(widgetDef.getXWidgetName())) {
            try {
                ArtifactValueProvider valueProvider;
                IAtsBranchService branchService = atsServices.getBranchService();
                if (provider instanceof ArtifactValueProvider && (valueProvider = (ArtifactValueProvider)provider).getObject() instanceof IAtsTeamWorkflow) {
                    boolean changesExistToCommit;
                    IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)valueProvider.getObject();
                    boolean workingBranchInWork = branchService.isWorkingBranchInWork(teamWf);
                    boolean committedBranchExists = branchService.isCommittedBranchExists(teamWf);
                    boolean hasBranchesLeftToCommit = !branchService.getBranchesLeftToCommit(teamWf).isEmpty();
                    boolean bl = changesExistToCommit = (workingBranchInWork || committedBranchExists) && hasBranchesLeftToCommit;
                    if (changesExistToCommit) {
                        boolean allObjectsToCommitToConfigured = branchService.isAllObjectsToCommitToConfigured(teamWf);
                        if (!allObjectsToCommitToConfigured) {
                            return new WidgetResult(WidgetStatus.Invalid_Incompleted, TransitionResult.NOT_ALL_BRANCHES_COMMITTED.toString(), new Object[0]);
                        }
                        if (!this.transitionToWithWorkingBranchRuleExists(toStateDef) && !branchService.isBranchesAllCommitted(teamWf)) {
                            return new WidgetResult(WidgetStatus.Invalid_Incompleted, TransitionResult.NOT_ALL_BRANCHES_COMMITTED.toString(), new Object[0]);
                        }
                    }
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(AtsXCommitManagerValidator.class, (Level)Level.SEVERE, (Throwable)ex);
                return new WidgetResult(WidgetStatus.Exception, (Exception)((Object)ex), "Exception validating Commits for transition validation [%s]; see error log", new Object[]{ex.getLocalizedMessage()});
            }
        }
        return result;
    }

    protected boolean transitionToWithWorkingBranchRuleExists(StateDefinition toStateDef) {
        return toStateDef.hasRule(RuleDefinitionOption.AllowTransitionWithWorkingBranch.name());
    }
}

