/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workflow.transition.IAtsXWidgetValidator;
import org.eclipse.osee.ats.api.workflow.transition.IAtsXWidgetValidatorProvider;
import org.eclipse.osee.ats.core.util.ArtifactValueProvider;

public class AtsXWidgetValidateManager {
    private static List<IAtsXWidgetValidatorProvider> providers = new LinkedList<IAtsXWidgetValidatorProvider>();

    public AtsXWidgetValidateManager() {
    }

    public AtsXWidgetValidateManager(boolean clearCache) {
        if (clearCache) {
            providers.clear();
        }
    }

    public void addWidgetValidatorProvider(IAtsXWidgetValidatorProvider provider) {
        AtsXWidgetValidateManager.getProviders().add(provider);
    }

    public void removeWidgetValidatorProvider(IAtsXWidgetValidatorProvider provider) {
        AtsXWidgetValidateManager.getProviders().remove(provider);
    }

    public static List<WidgetResult> validateTransition(IAtsWorkItem workItem, List<WidgetResult> results, IValueProvider valueProvider, WidgetDefinition widgetDef, StateDefinition fromStateDef, StateDefinition toStateDef, AtsApi atsServices) {
        List<IAtsXWidgetValidatorProvider> providers = AtsXWidgetValidateManager.getProviders();
        for (IAtsXWidgetValidatorProvider provider : providers) {
            for (IAtsXWidgetValidator validator : provider.getValidators()) {
                try {
                    WidgetResult status = validator.validateTransition(workItem, valueProvider, widgetDef, fromStateDef, toStateDef, atsServices);
                    if (status == null || status.isSuccess()) continue;
                    results.add(status);
                }
                catch (Exception ex) {
                    results.add(new WidgetResult(WidgetStatus.Exception, ex, String.format("Exception retrieving validation for widget [%s] Exception [%s]", validator.getClass().getSimpleName(), ex.getLocalizedMessage()), new Object[]{ex}));
                }
            }
        }
        return results;
    }

    static synchronized List<IAtsXWidgetValidatorProvider> getProviders() {
        return providers;
    }

    public static Collection<WidgetResult> validateTransition(IAtsWorkItem workItem, StateDefinition toStateDef, AtsApi atsApi) {
        ArrayList<WidgetResult> results = new ArrayList<WidgetResult>();
        List widgetItems = atsApi.getWorkDefinitionService().getWidgetsFromLayoutItems(workItem.getStateDefinition());
        List headerWidgetItems = atsApi.getWorkDefinitionService().getWidgetsFromLayoutItems(workItem.getStateDefinition(), workItem.getWorkDefinition().getHeaderDef().getLayoutItems());
        if (!headerWidgetItems.isEmpty()) {
            for (WidgetDefinition item : headerWidgetItems) {
                widgetItems.add(item);
            }
        }
        for (WidgetDefinition widgetDef : widgetItems) {
            ArtifactValueProvider provider = new ArtifactValueProvider(workItem.getStoreObject(), widgetDef, atsApi);
            AtsXWidgetValidateManager.validateTransition(workItem, results, provider, widgetDef, workItem.getStateDefinition(), toStateDef, atsApi);
        }
        return results;
    }
}

