/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;

public class AtsForceAssigneesToTeamLeadsWorkItemHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsForceAssigneesToTeamLeadsWorkItemHook.class.getSimpleName();
    }

    public String getDescription() {
        return "Check if toState is configured to force assignees to leads and set leads accordingly.";
    }

    public void transitioned(IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<AtsUser> toAssignees, AtsUser asUser, IAtsChangeSet changes, AtsApi atsApi) {
        Collection teamLeads;
        if (workItem.isTeamWorkflow() && this.isForceAssigneesToTeamLeads(atsApi.getWorkDefinitionService().getStateDefinitionByName(workItem, toState.getName())) && !(teamLeads = atsApi.getTeamDefinitionService().getLeads(((IAtsTeamWorkflow)workItem).getTeamDefinition())).isEmpty()) {
            changes.setAssignees(workItem, teamLeads);
        }
    }

    private boolean isForceAssigneesToTeamLeads(StateDefinition stateDefinition) {
        return stateDefinition.hasRule(RuleDefinitionOption.ForceAssigneesToTeamLeads.name());
    }
}

