/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewDefectManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;

public class AtsPeerReviewRoleDefectValidator
implements IAtsTransitionHook {
    public void transitioning(TransitionResults results, IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<AtsUser> toAssignees, AtsUser asUser, AtsApi atsApi) {
        super.transitioning(results, workItem, fromState, toState, toAssignees, asUser, atsApi);
        if (workItem.isPeerReview() && toState.isCompleted()) {
            IAtsPeerToPeerReview review = (IAtsPeerToPeerReview)workItem;
            IAtsPeerReviewDefectManager defectMgr = review.getDefectManager();
            for (ReviewDefectItem item : defectMgr.getDefectItems()) {
                if (item.isClosed()) continue;
                results.addResult(workItem, TransitionResult.REVIEW_DEFECTS_NOT_CLOSED);
                break;
            }
            for (UserRole role : review.getRoleManager().getUserRoles()) {
                if (role.isCompleted()) continue;
                results.addResult(workItem, TransitionResult.REVIEW_ROLES_NOT_COMPLETED);
                break;
            }
        }
    }

    public String getDescription() {
        return "Verify that Peer to Peer Review Roles and Defects are completed";
    }
}

