/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.workflow.util.AbstractDuplicateWorkflowOperation;
import org.eclipse.osee.ats.core.workflow.util.IDuplicateWorkflowListener;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class DuplicateWorkflowAsIsOperation
extends AbstractDuplicateWorkflowOperation {
    private final boolean duplicateTasks;
    private List<AttributeTypeId> excludeTypes;
    private static String ATS_CONFIG_EXCLUDE_DUPLICATE_TYPE_IDS_KEY = "DuplicateWorkflowAsIsOperation_ExcludeAttrTypeIds";
    private final String comment;
    private final Collection<IDuplicateWorkflowListener> duplicateListeners = new ArrayList<IDuplicateWorkflowListener>();
    private final boolean newAction;
    private AtsUser originator;
    private String description;
    private Collection<AtsUser> assigneesOverride;
    private String changeType;
    private String priority;
    private String points;

    public DuplicateWorkflowAsIsOperation(Collection<IAtsTeamWorkflow> teamWfs, boolean duplicateTasks, String title, AtsUser asUser, AtsApi atsApi) {
        this(teamWfs, duplicateTasks, title, asUser, atsApi, "", false, null);
    }

    public DuplicateWorkflowAsIsOperation(Collection<IAtsTeamWorkflow> teamWfs, boolean duplicateTasks, String title, AtsUser asUser, AtsApi atsApi, String comment, boolean newAction, Collection<IDuplicateWorkflowListener> listeners) {
        super(teamWfs, title, asUser, atsApi);
        this.duplicateTasks = duplicateTasks;
        this.comment = comment;
        if (listeners != null) {
            this.duplicateListeners.addAll(listeners);
        }
        this.newAction = newAction;
    }

    public DuplicateWorkflowAsIsOperation(List<IAtsTeamWorkflow> asList, boolean duplicateTasks, String existingName, String newName, AtsUser currentUser, AtsApi atsApi) {
        this(asList, duplicateTasks, newName, currentUser, atsApi, "", false, null);
    }

    public XResultData run() {
        XResultData results = this.validate();
        if (results.isErrors()) {
            return results;
        }
        this.oldToNewMap = new HashMap();
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet(Strings.isValid((String)this.comment) ? this.comment : "Duplicate Workflow - As-Is", this.asUser);
        for (IAtsTeamWorkflow teamWf : this.teamWfs) {
            IAtsWorkItem newTeamWf = this.duplicateWorkItem(changes, (IAtsWorkItem)teamWf);
            changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)this.asUser, (IAtsWorkItem)newTeamWf, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Originator, AtsNotifyType.Assigned, AtsNotifyType.SubscribedTeamOrAi}));
            if (this.duplicateTasks) {
                for (IAtsTask task : this.atsApi.getTaskService().getTask((IAtsWorkItem)teamWf)) {
                    IAtsTask dupTaskArt = (IAtsTask)this.duplicateWorkItem(changes, (IAtsWorkItem)task);
                    dupTaskArt.getLog().addLog(LogType.Note, null, "Task duplicated from " + task.getAtsId(), this.atsApi.getUserService().getCurrentUser().getUserId());
                    changes.relate((Object)newTeamWf.getStoreObject(), AtsRelationTypes.TeamWfToTask_Task, (Object)dupTaskArt);
                    changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)this.asUser, (IAtsWorkItem)dupTaskArt, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.SubscribedTeamOrAi}));
                    changes.add((Object)dupTaskArt);
                }
            }
            this.oldToNewMap.put(teamWf, (IAtsTeamWorkflow)newTeamWf);
        }
        changes.execute();
        return results;
    }

    private IAtsWorkItem duplicateWorkItem(IAtsChangeSet changes, IAtsWorkItem fromWorkItem) {
        ArtifactToken newWorkItemArt = changes.createArtifact(this.atsApi.getStoreService().getArtifactType((ArtifactId)fromWorkItem.getStoreObject()), this.getTitle(fromWorkItem));
        if (fromWorkItem.isTeamWorkflow() && !this.newAction) {
            changes.relate((Object)newWorkItemArt, AtsRelationTypes.ActionToWorkflow_Action, (Object)fromWorkItem.getParentAction());
        }
        IAtsLog atsLog = this.atsApi.getLogFactory().getLogLoaded(fromWorkItem, this.atsApi.getAttributeResolver());
        atsLog.addLog(LogType.Note, null, "Workflow duplicated from " + fromWorkItem.getAtsId(), this.asUser.getUserId());
        LinkedList<AtsUser> assignees = new LinkedList<AtsUser>();
        if (this.assigneesOverride != null) {
            if (!this.assigneesOverride.isEmpty()) {
                assignees.addAll(this.assigneesOverride);
            } else {
                assignees.add(AtsCoreUsers.UNASSIGNED_USER);
            }
        } else {
            assignees.addAll(fromWorkItem.getAssignees());
        }
        if (fromWorkItem.isTeamWorkflow()) {
            IAtsTeamWorkflow fromTeamWf = (IAtsTeamWorkflow)fromWorkItem;
            if (this.assigneesOverride == null) {
                assignees.addAll(AtsApiService.get().getTeamDefinitionService().getLeads(((IAtsTeamWorkflow)fromWorkItem).getTeamDefinition()));
                if (!assignees.contains(this.asUser)) {
                    assignees.add(this.asUser);
                }
            }
            if (newWorkItemArt instanceof IAtsTeamWorkflow) {
                IAtsGoal goal = null;
                for (IDuplicateWorkflowListener listener : this.duplicateListeners) {
                    goal = listener.addToGoal((IAtsTeamWorkflow)newWorkItemArt, changes);
                    listener.handleChanges((IAtsTeamWorkflow)newWorkItemArt, changes);
                }
                this.atsApi.getActionService().addActionToConfiguredGoal(fromTeamWf.getTeamDefinition(), (IAtsTeamWorkflow)newWorkItemArt, (Collection)fromTeamWf.getActionableItems(), goal, changes);
            }
        }
        for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((ArtifactId)fromWorkItem.getStoreObject())) {
            if (this.getExcludeTypes().contains(attr.getAttributeType())) continue;
            if (attr.getAttributeType().equals(AtsAttributeTypes.Points) || attr.getAttributeType().equals(AtsAttributeTypes.PointsNumeric)) {
                if (Strings.isValid((String)this.points)) {
                    changes.setSoleAttributeValue((ArtifactId)newWorkItemArt, attr.getAttributeType(), (Object)this.points);
                    continue;
                }
                changes.addAttribute((ArtifactId)newWorkItemArt, attr.getAttributeType(), attr.getValue());
                continue;
            }
            if (attr.getAttributeType().equals(AtsAttributeTypes.Priority)) {
                if (Strings.isValid((String)this.priority)) {
                    changes.setSoleAttributeValue((ArtifactId)newWorkItemArt, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)this.priority);
                    continue;
                }
                changes.addAttribute((ArtifactId)newWorkItemArt, attr.getAttributeType(), attr.getValue());
                continue;
            }
            if (attr.getAttributeType().equals(AtsAttributeTypes.ChangeType)) {
                if (Strings.isValid((String)this.changeType)) {
                    changes.setSoleAttributeValue((ArtifactId)newWorkItemArt, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)this.changeType);
                    continue;
                }
                changes.addAttribute((ArtifactId)newWorkItemArt, attr.getAttributeType(), attr.getValue());
                continue;
            }
            if (attr.getAttributeType().equals(AtsAttributeTypes.CreatedBy)) {
                if (this.originator != null) {
                    changes.setSoleAttributeValue((ArtifactId)newWorkItemArt, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, (Object)this.originator.getUserId());
                    continue;
                }
                changes.setSoleAttributeValue((ArtifactId)newWorkItemArt, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, (Object)this.atsApi.getUserService().getCurrentUser().getUserId());
                continue;
            }
            if (attr.getAttributeType().equals(AtsAttributeTypes.CreatedDate)) {
                changes.setSoleAttributeValue((ArtifactId)newWorkItemArt, (AttributeTypeToken)AtsAttributeTypes.CreatedDate, (Object)new Date());
                continue;
            }
            if (attr.getAttributeType().equals(AtsAttributeTypes.Description) && Strings.isValid((String)this.description)) {
                changes.setSoleAttributeValue((ArtifactId)newWorkItemArt, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)this.description);
                continue;
            }
            changes.addAttribute((ArtifactId)newWorkItemArt, attr.getAttributeType(), attr.getValue());
        }
        IAtsWorkItem newWorkItem = this.atsApi.getWorkItemService().getWorkItem(newWorkItemArt);
        changes.setAssignees(newWorkItem, assignees);
        if (this.newAction) {
            IAtsAction origAction = fromWorkItem.getParentAction();
            ChangeTypes changeType = ChangeTypeColumn.getChangeType(origAction, this.atsApi);
            String priority = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)origAction, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)"");
            boolean validationRequired = (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)origAction, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, (Object)false);
            Date needByDate = (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)origAction, (AttributeTypeToken)AtsAttributeTypes.NeedBy, null);
            IAtsAction newAction = this.atsApi.getActionService().createAction(this.comment, this.description, changeType, priority, validationRequired, needByDate, changes);
            changes.relate((Object)newWorkItemArt, AtsRelationTypes.ActionToWorkflow_Action, (Object)newAction);
        }
        this.atsApi.getActionService().setAtsId((IAtsObject)newWorkItem, fromWorkItem.getParentTeamWorkflow().getTeamDefinition(), null, changes);
        return newWorkItem;
    }

    private List<AttributeTypeId> getExcludeTypes() {
        if (this.excludeTypes == null) {
            this.excludeTypes = new LinkedList<AttributeTypeId>();
            this.excludeTypes.add((AttributeTypeId)AtsAttributeTypes.AtsId);
            this.excludeTypes.add((AttributeTypeId)CoreAttributeTypes.Name);
            String value = this.atsApi.getConfigValue(ATS_CONFIG_EXCLUDE_DUPLICATE_TYPE_IDS_KEY);
            if (Strings.isValid((String)value)) {
                String[] stringArray = value.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String attrTypeId = stringArray[n2];
                    if (Strings.isNumeric((String)attrTypeId)) {
                        AttributeTypeId attributeType = AttributeTypeId.valueOf((String)attrTypeId);
                        if (attributeType != null) {
                            this.excludeTypes.add(attributeType);
                        } else {
                            OseeLog.log(DuplicateWorkflowAsIsOperation.class, (Level)Level.SEVERE, (String)String.format("Can't resolve Attribute Type for id %s in AtsConfig.%s", attrTypeId, ATS_CONFIG_EXCLUDE_DUPLICATE_TYPE_IDS_KEY));
                        }
                    } else {
                        OseeLog.log(DuplicateWorkflowAsIsOperation.class, (Level)Level.SEVERE, (String)String.format("Can't resolve non-numeric Attribute Type for id %s in AtsConfig.%s", attrTypeId, ATS_CONFIG_EXCLUDE_DUPLICATE_TYPE_IDS_KEY));
                    }
                    ++n2;
                }
            }
        }
        return this.excludeTypes;
    }

    public AtsUser getOriginator() {
        return this.originator;
    }

    public void setOriginator(AtsUser originator) {
        this.originator = originator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAssignees(Collection<AtsUser> assignees) {
        this.assigneesOverride = assignees;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setPoints(String points) {
        this.points = points;
    }
}

