/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer.coverage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoApiConfiguration;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DispoSetCopier;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.vcast.VCastClient;
import org.eclipse.osee.vcast.VCastDataStore;
import org.eclipse.osee.vcast.VCastLisFileParser;
import org.eclipse.osee.vcast.VCastValidateDatFileSyntax;
import org.eclipse.osee.vcast.model.VCastFunction;
import org.eclipse.osee.vcast.model.VCastInstrumentedFile;
import org.eclipse.osee.vcast.model.VCastMcdcCoveragePairRow;
import org.eclipse.osee.vcast.model.VCastResult;
import org.eclipse.osee.vcast.model.VCastSourceFileJoin;
import org.eclipse.osee.vcast.model.VCastStatementCoverage;

public class LisFileParser
implements DispoImporterApi {
    private static final String RESULTS = "results";
    private static final String IMPORTED_RESULTS = "IMPORTED_RESULTS";
    private static final String LOG = "\\s*(log).*";
    private static final String EXIT_WHEN = "^(?i)(.*\\bEXIT WHEN\\b\\s*[^:]*$)";
    private static final String MCDC_BRANCH_TF_CONDITIONS = "^(?i)(.*\\b(IF|ELSIF|WHILE|EXIT.*WHEN)\\b\\s*[^:]*$)";
    private static final String BRANCH_TF_CONDITIONS = "^(?i)(.*\\bFOR\\b.*)";
    private static final String BRANCH_T_CONDITION = "^(?i)(?!.*\\bEXIT\\b).*\\b(WHEN|BEGIN)\\b.*";
    private static final String WHILE_ONE = "(.*\\b(WHILE|while)\\b\\s*\\(1\\).*)";
    private static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final DispoDataFactory dataFactory;
    private static final Pattern fileMethod5LineNumberPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)");
    private static final Pattern fileMethod3LineNumberPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)");
    private static final Pattern fileMethod4LineNumberPlusTokenPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+(T|F)");
    private final Map<String, DispoItemData> datIdToItem = new HashMap<String, DispoItemData>();
    private final Set<String> datIdsCoveredByException = new HashSet<String>();
    private final Set<String> alreadyUsedDatIds = new HashSet<String>();
    private final Set<String> alreadyUsedFileNames = new HashSet<String>();
    private final DispoConnector dispoConnector;
    private final DispoApiConfiguration config;
    private String vCastDir;

    public LisFileParser(Log logger, DispoDataFactory dataFactory, DispoApiConfiguration config, DispoConnector connector) {
        this.dataFactory = dataFactory;
        this.config = config;
        this.dispoConnector = connector;
    }

    @Override
    public List<DispoItem> importDirectory(Map<String, DispoItem> exisitingItems, File filesDir, OperationReport report) {
        this.vCastDir = filesDir.getAbsolutePath();
        File f = new File(String.valueOf(this.vCastDir) + File.separator + "cover.db");
        if (!f.exists()) {
            this.vCastDir = String.valueOf(filesDir.getAbsolutePath()) + File.separator + "vcast";
            f = new File(String.valueOf(this.vCastDir) + File.separator + "cover.db");
        }
        VCastDataStore dataStore = VCastClient.newDataStore((String)f.getAbsolutePath());
        dataStore.setIsMCDC();
        dataStore.setIsBranch();
        Collection<VCastInstrumentedFile> instrumentedFiles = this.getInstrumentedFiles(dataStore, report);
        HashMap<String, File> nameToFileMap = this.createNameToFileMap(report);
        for (VCastInstrumentedFile instrumentedFile : instrumentedFiles) {
            this.processInstrumented(dataStore, instrumentedFile, nameToFileMap, report);
        }
        Collection<VCastResult> results = this.getResultFiles(dataStore);
        for (VCastResult result : results) {
            try {
                this.processResults(result, report);
            }
            catch (Exception exception) {
                report.addEntry("FAILURE", "VCast Error", DispoSummarySeverity.ERROR);
            }
        }
        this.processExceptionHandled(report);
        return this.createItems(exisitingItems, report);
    }

    private HashMap<String, File> createNameToFileMap(OperationReport report) {
        HashMap<String, File> fileNameToFileMap = new HashMap<String, File>();
        File vcastDir = new File(this.vCastDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lis") || name.endsWith(".LIS");
            }
        };
        File[] lisFiles = vcastDir.listFiles(filter);
        if (lisFiles != null) {
            File[] fileArray = lisFiles;
            int n = lisFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileNameLowerCase = this.normalizeLisFileName(file.getName());
                if (fileNameToFileMap.containsKey(fileNameLowerCase)) {
                    report.addEntry("DIRECTORY", String.format("Collision with file name: %s", fileNameLowerCase), DispoSummarySeverity.ERROR);
                } else {
                    fileNameToFileMap.put(fileNameLowerCase, file);
                }
                ++n2;
            }
        }
        return fileNameToFileMap;
    }

    private List<DispoItem> createItems(Map<String, DispoItem> exisitingItems, OperationReport report) {
        List<Object> toReturn;
        Collection<DispoItemData> items = this.datIdToItem.values();
        for (DispoItemData dispoItemData : items) {
            this.dataFactory.initDispoItem(dispoItemData);
            dispoItemData.setTotalPoints(String.valueOf(dispoItemData.getAnnotationsList().size() + dispoItemData.getDiscrepanciesList().size()));
        }
        if (!exisitingItems.isEmpty()) {
            toReturn = this.runCopier(exisitingItems, report, items);
        } else {
            toReturn = new ArrayList<DispoItemData>();
            toReturn.addAll(items);
        }
        for (DispoItem dispoItem : toReturn) {
            this.createPlaceHolderAnnotations((DispoItemData)dispoItem, exisitingItems, report);
        }
        return toReturn;
    }

    private List<DispoItem> runCopier(Map<String, DispoItem> exisitingItems, OperationReport report, Collection<DispoItemData> items) {
        DispoSetCopier copier = new DispoSetCopier(this.dispoConnector);
        ArrayList<DispoItemData> itemsFromImport = new ArrayList<DispoItemData>();
        itemsFromImport.addAll(items);
        HashMap<String, Set<DispoItemData>> namesToDestItems = new HashMap<String, Set<DispoItemData>>();
        for (DispoItemData item : itemsFromImport) {
            String name = item.getName();
            Set itemsWithSameName = (Set)namesToDestItems.get(name);
            if (itemsWithSameName == null) {
                HashSet<DispoItemData> set = new HashSet<DispoItemData>();
                set.add(item);
                namesToDestItems.put(name, set);
                continue;
            }
            itemsWithSameName.add(item);
            namesToDestItems.put(name, itemsWithSameName);
        }
        List<DispoItem> toReturn = copier.copyAllDispositions(namesToDestItems, exisitingItems.values(), false, null, report);
        return toReturn;
    }

    private void createPlaceHolderAnnotations(DispoItemData item, Map<String, DispoItem> exisitingItems, OperationReport report) {
        ArrayList<DispoItem> prevItems = new ArrayList<DispoItem>(exisitingItems.values());
        List<String> uncovered = this.dispoConnector.getAllUncoveredDiscrepancies((DispoItem)item);
        ArrayList<String> discrepanciesToRemove = new ArrayList<String>();
        if (!uncovered.isEmpty()) {
            Map discrepanciesList = item.getDiscrepanciesList();
            for (String id : discrepanciesList.keySet()) {
                Discrepancy discrepancy = (Discrepancy)discrepanciesList.get(id);
                if (discrepancy.getLocation().endsWith(").T") || discrepancy.getLocation().endsWith(").F")) {
                    discrepanciesToRemove.add(id);
                    continue;
                }
                if (!uncovered.contains(discrepancy.getLocation())) continue;
                DispoAnnotationData uncoveredAnnotation = this.matchOldAnnotation(discrepancy, prevItems, item);
                if (uncoveredAnnotation != null) {
                    if (uncoveredAnnotation.getResolutionType().equalsIgnoreCase("Test_Script")) {
                        uncoveredAnnotation.setLastResolution(uncoveredAnnotation.getResolution());
                        this.addBlankAnnotationForUncoveredLine(item, discrepancy.getLocation(), discrepancy.getText(), uncoveredAnnotation.getLastResolution());
                        continue;
                    }
                    if (uncoveredAnnotation.getResolutionType().equalsIgnoreCase("Exception_Handling")) {
                        uncoveredAnnotation.setLastResolution("Exception_Handling");
                        this.addBlankAnnotationForUncoveredLine(item, discrepancy.getLocation(), discrepancy.getText(), uncoveredAnnotation.getLastResolution());
                        continue;
                    }
                    this.keepExistingAnnotation(item, uncoveredAnnotation);
                    continue;
                }
                this.addBlankAnnotationForUncoveredLine(item, discrepancy.getLocation(), discrepancy.getText(), "N/A");
            }
            for (String id : discrepanciesToRemove) {
                discrepanciesList.remove(id);
                item.setDiscrepanciesList(discrepanciesList);
            }
        }
    }

    private void processExceptionHandled(OperationReport report) {
        for (String datId : this.datIdsCoveredByException) {
            Discrepancy matchingDiscrepancy;
            Matcher matcher = Pattern.compile("\\d*:\\d*:").matcher(datId);
            matcher.find();
            String itemDatId = matcher.group();
            DispoItemData item = this.datIdToItem.get(itemDatId);
            String line = datId.replaceAll("\\d*:\\d*:", "");
            line = line.replaceAll(":", "");
            String text = "";
            if (line.endsWith("RESULT")) {
                String lineF = String.valueOf(line) + ".F";
                Discrepancy matchingDiscrepancyF = this.matchDiscrepancy(lineF, item.getDiscrepanciesList());
                if (matchingDiscrepancyF != null) {
                    text = matchingDiscrepancyF.getText();
                    Map discrepancies = item.getDiscrepanciesList();
                    discrepancies.remove(matchingDiscrepancyF.getId());
                    this.addAnnotationForCoveredLine(item, lineF, "Exception_Handling", "", text);
                }
                line = String.valueOf(line) + ".T";
            }
            if ((matchingDiscrepancy = this.matchDiscrepancy(line, item.getDiscrepanciesList())) == null) continue;
            text = matchingDiscrepancy.getText();
            Map discrepancies = item.getDiscrepanciesList();
            if (matchingDiscrepancy.getPairAnnotations() != null && !matchingDiscrepancy.getPairAnnotations().isEmpty() && !matchingDiscrepancy.getIsOverloadedCondition()) {
                this.addAnnotationForCoveredMcdcLine(item, line, "Exception_Handling", "", text, matchingDiscrepancy.getPairAnnotations());
                discrepancies.remove(matchingDiscrepancy.getId());
                continue;
            }
            if (matchingDiscrepancy.getIsOverloadedCondition()) {
                this.addAnnotationForOverloadedMcdcLine(item, line, text, "", matchingDiscrepancy.getDevNotes());
                continue;
            }
            this.addAnnotationForCoveredLine(item, line, "Exception_Handling", "", text);
            discrepancies.remove(matchingDiscrepancy.getId());
        }
    }

    private Collection<VCastInstrumentedFile> getInstrumentedFiles(VCastDataStore dataStore, OperationReport report) {
        ArrayList<VCastInstrumentedFile> instrumentedFiles = new ArrayList();
        try {
            Map<String, File> idToFileName = this.getDispoFileNamesById();
            instrumentedFiles = dataStore.getAllInstrumentedFiles(idToFileName);
        }
        catch (OseeCoreException oseeCoreException) {
            report.addEntry("SQL", String.format("SQL error while reading functions for directory: [%s]", this.vCastDir), DispoSummarySeverity.ERROR);
        }
        return instrumentedFiles;
    }

    public Map<String, File> getDispoFileNamesById() {
        File vcastFolder = new File(this.vCastDir);
        WildcardFileFilter fileFilter = new WildcardFileFilter("*.LIS");
        File[] lisFiles = vcastFolder.listFiles((FileFilter)fileFilter);
        HashMap<String, File> idToLisFile = new HashMap<String, File>();
        if (lisFiles != null) {
            int i = 0;
            while (i < lisFiles.length) {
                String[] parts;
                boolean fileFound = false;
                String[] stringArray = parts = lisFiles[i].getName().split("\\.");
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (Pattern.matches("\\-?\\d+", s) && !s.equals("2")) {
                        if (idToLisFile.containsKey(s)) {
                            if (FileUtils.isFileNewer((File)lisFiles[i], (File)((File)idToLisFile.get(s)))) {
                                idToLisFile.remove(s);
                                idToLisFile.put(s, lisFiles[i]);
                            }
                        } else {
                            idToLisFile.put(s, lisFiles[i]);
                        }
                        fileFound = true;
                        break;
                    }
                    ++n2;
                }
                if (!fileFound) {
                    if (idToLisFile.containsKey("2")) {
                        if (FileUtils.isFileNewer((File)lisFiles[i], (File)((File)idToLisFile.get("2")))) {
                            idToLisFile.remove("2");
                            idToLisFile.put("2", lisFiles[i]);
                        }
                    } else {
                        idToLisFile.put("2", lisFiles[i]);
                    }
                }
                ++i;
            }
        }
        return idToLisFile;
    }

    private void processInstrumented(VCastDataStore dataStore, VCastInstrumentedFile instrumentedFile, HashMap<String, File> nameToFileMap, OperationReport report) {
        VCastSourceFileJoin sourceFile = null;
        try {
            sourceFile = dataStore.getSourceFileJoin(instrumentedFile);
        }
        catch (OseeCoreException ex) {
            report.addEntry("SQL", String.format("SQL error while reading source_files for instrumented_file id: [%s]. Error Message: [%s]", instrumentedFile.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        if (sourceFile != null) {
            String normalizedName;
            File file;
            int fileNum = sourceFile.getUnitIndex();
            String lisFileNameFullPath = instrumentedFile.getLISFile();
            if (!Strings.isValid((String)lisFileNameFullPath)) {
                report.addEntry("SQL", String.format("Error: instrumented_file has invalid LIS_file value.  ID:(" + instrumentedFile.getId() + ")", new Object[0]), DispoSummarySeverity.ERROR);
            }
            if ((file = nameToFileMap.get(normalizedName = this.normalizeLisFileName(lisFileNameFullPath))) != null) {
                VCastLisFileParser lisFileParser = new VCastLisFileParser(file);
                try {
                    lisFileParser.loadFileText();
                }
                catch (IOException iOException) {
                    report.addEntry("VCast", String.format("Could not load file: %s", normalizedName), DispoSummarySeverity.ERROR);
                }
                Collection<Object> functions = Collections.emptyList();
                try {
                    functions = dataStore.getFunctions(instrumentedFile);
                }
                catch (OseeCoreException oseeCoreException) {
                    report.addEntry("SQL", String.format("SQL error while reading functions for instrumented_file id: [%s]. Error Message: [%s]", instrumentedFile.getId(), oseeCoreException.getMessage()), DispoSummarySeverity.ERROR);
                }
                for (VCastFunction vCastFunction : functions) {
                    this.processFunction(instrumentedFile, lisFileParser, fileNum, dataStore, instrumentedFile, vCastFunction, dataStore.getIsMCDC(), report);
                }
            } else {
                report.addEntry("VCast", String.format("Could not find file: %s", normalizedName), DispoSummarySeverity.ERROR);
            }
        }
    }

    private void processFunction(VCastInstrumentedFile lisFile, VCastLisFileParser lisFileParser, int fileNum, VCastDataStore dataStore, VCastInstrumentedFile instrumentedFile, VCastFunction function, boolean isMCDCFile, OperationReport report) {
        int functionNum = function.getFindex();
        String itemName = "";
        DispoItemData newItem = new DispoItemData();
        newItem.setAnnotationsList(new ArrayList());
        VCastSourceFileJoin sourceFileJoin = dataStore.getSourceFileJoin(lisFile);
        Objects.requireNonNull(sourceFileJoin, "sourceFileJoin can not be null");
        itemName = String.valueOf(sourceFileJoin.getDisplayName()) + "." + function.getName();
        newItem.setName(itemName);
        newItem.setFileNumber(Integer.toString(fileNum));
        newItem.setMethodNumber(Integer.toString(functionNum));
        try {
            String fullPathToFile = String.valueOf(this.vCastDir) + File.separator + lisFile.getLISFile();
            Date lastModified = DispoUtil.getTimestampOfFile(fullPathToFile);
            newItem.setLastUpdate(lastModified);
        }
        catch (Throwable ex) {
            report.addEntry("Get Timestamp of File", String.format("Error retrieving the timestamp for [%s]. Error Message: [%s]", instrumentedFile.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        String datId = this.generateDatId(fileNum, functionNum);
        this.datIdToItem.put(datId, newItem);
        this.checkForMultiEnvRename(fileNum, instrumentedFile, newItem);
        Collection<Object> statementCoverageItems = Collections.emptyList();
        try {
            statementCoverageItems = dataStore.getStatementCoverageLines(function);
        }
        catch (OseeCoreException ex) {
            report.addEntry("SQL", String.format("SQL error while reading statement_coverages for instrumented_file id: [%s] and function id: [%s]. Error Message: [%s]", instrumentedFile.getId(), function.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        HashMap<String, Discrepancy> discrepancies = new HashMap<String, Discrepancy>();
        for (VCastStatementCoverage vCastStatementCoverage : statementCoverageItems) {
            this.processStatement(lisFile, lisFileParser, fileNum, functionNum, function, vCastStatementCoverage, isMCDCFile, discrepancies, report);
        }
        newItem.setDiscrepanciesList(discrepancies);
    }

    private void checkForMultiEnvRename(int fileNum, VCastInstrumentedFile instrumentedFile, DispoItemData newItem) {
        String regexWithSeparator = String.format(".*?%svcast%s.*?\\d+\\.2\\.lis", File.separator, File.separator);
        if (instrumentedFile.getLISFile().matches(regexWithSeparator)) {
            String nameWithoutId = newItem.getName();
            String regex = "\\.2\\.";
            String nameWithId = nameWithoutId.replaceAll(regex, String.format(".%s.2.", fileNum));
            newItem.setName(nameWithId);
        }
    }

    private void processStatement(VCastInstrumentedFile lisFile, VCastLisFileParser lisFileParser, int fileNum, int functionNum, VCastFunction function, VCastStatementCoverage statementCoverageItem, boolean isMCDCFile, Map<String, Discrepancy> discrepancies, OperationReport report) {
        Integer functionNumber = function.getFindex();
        Integer lineNumber = statementCoverageItem.getLine();
        Pair lineData = null;
        try {
            lineData = lisFileParser.getSourceCodeForLine(functionNumber, lineNumber);
        }
        catch (Exception ex) {
            report.addEntry("SQL", String.format("Issue getting source code line [%s], [%s]", lisFile.getLISFile(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        String location = "";
        if (lineData != null) {
            boolean isMCDCPair = statementCoverageItem.getIsMCDCPair();
            if (isMCDCPair) {
                location = String.format("%s.%s", lineNumber, statementCoverageItem.getAbbrevCondition());
                if (((String)lineData.getFirst()).matches(MCDC_BRANCH_TF_CONDITIONS)) {
                    String text = String.format("%s %s", ((String)lineData.getFirst()).trim(), statementCoverageItem.getFullCondition());
                    int numberOfConditions = statementCoverageItem.getNumConditions();
                    int conditionIndex = statementCoverageItem.getCondIndex();
                    if (conditionIndex > 0) {
                        ArrayList coverageRows = statementCoverageItem.getCoverageRows();
                        HashMap<Integer, DispoAnnotationData> pairAnnotations = new HashMap<Integer, DispoAnnotationData>();
                        if (numberOfConditions <= 8) {
                            Table<Integer, Integer, Boolean> truthTable = this.mcdcTruthTable(numberOfConditions);
                            Multimap<Integer, Integer> allPairs = this.determineMcdcPairs(truthTable, coverageRows, conditionIndex);
                            for (VCastMcdcCoveragePairRow coverageRow : coverageRows) {
                                int rowValue = coverageRow.getRowValue();
                                if (!allPairs.containsKey((Object)rowValue)) continue;
                                boolean isRowCovered = coverageRow.getMaxHitCount() > 0;
                                String truthRowText = "";
                                for (Map.Entry truthRow : truthTable.row((Object)rowValue).entrySet()) {
                                    truthRowText = String.format("%s%s=%b  ", truthRowText, Character.valueOf(LETTERS.charAt((Integer)truthRow.getKey() - 1)), truthRow.getValue());
                                }
                                truthRowText = coverageRow.getRowResult() == 1 ? String.format("%sResult=%b", truthRowText, true) : String.format("%sResult=%b", truthRowText, false);
                                pairAnnotations.put(rowValue, this.createPairAnnotation(String.valueOf(location) + "." + rowValue, truthRowText, isRowCovered, rowValue, allPairs.get((Object)rowValue)));
                            }
                            this.addMcdcDiscrepancy(discrepancies, location, text, pairAnnotations, "", false);
                        } else {
                            String overloadedText = String.format("", numberOfConditions);
                            this.addMcdcDiscrepancy(discrepancies, location, text, pairAnnotations, overloadedText, true);
                        }
                    }
                } else if (((String)lineData.getFirst()).matches(BRANCH_TF_CONDITIONS)) {
                    String text = String.format("%s %s", ((String)lineData.getFirst()).trim(), statementCoverageItem.getFullCondition());
                    this.addDiscrepancy(discrepancies, String.valueOf(location) + ".T", text);
                    this.addDiscrepancy(discrepancies, String.valueOf(location) + ".F", text);
                } else {
                    String text = String.format("%s %s", ((String)lineData.getFirst()).trim(), statementCoverageItem.getFullCondition());
                    this.addDiscrepancy(discrepancies, String.valueOf(location) + ".T", text);
                }
            } else {
                String text = ((String)lineData.getFirst()).trim();
                if (statementCoverageItem.getNumConditions() == 2 && (((String)lineData.getFirst()).matches(MCDC_BRANCH_TF_CONDITIONS) || ((String)lineData.getFirst()).matches(BRANCH_TF_CONDITIONS))) {
                    location = String.format("%s.%s", lineNumber, "T");
                    String locationF = String.format("%s.%s", lineNumber, "F");
                    this.addDiscrepancy(discrepancies, location, text);
                    this.addDiscrepancy(discrepancies, locationF, text);
                } else if (statementCoverageItem.getNumConditions() == 1 && ((String)lineData.getFirst()).matches(BRANCH_T_CONDITION)) {
                    location = String.format("%s.%s", lineNumber, "T");
                    this.addDiscrepancy(discrepancies, location, text);
                } else {
                    location = String.valueOf(lineNumber);
                    this.addDiscrepancy(discrepancies, location, text);
                }
            }
            if (((Boolean)lineData.getSecond()).booleanValue()) {
                String datId = this.generateDatId(fileNum, functionNum, location);
                this.datIdsCoveredByException.add(datId);
            }
        }
    }

    private Table<Integer, Integer, Boolean> mcdcTruthTable(int numberOfConditions) {
        TreeBasedTable truthTable = TreeBasedTable.create();
        ArrayList<Integer> current = new ArrayList<Integer>();
        ArrayList<Integer> holding = new ArrayList<Integer>();
        current.add(numberOfConditions);
        int rowNumber = 1;
        int i = 1;
        while (i <= numberOfConditions) {
            truthTable.put((Object)rowNumber, (Object)i, (Object)true);
            ++i;
        }
        return this.mcdcTruthTableRec((Table<Integer, Integer, Boolean>)truthTable, current, holding, numberOfConditions, ++rowNumber);
    }

    private Table<Integer, Integer, Boolean> mcdcTruthTableRec(Table<Integer, Integer, Boolean> truthTable, List<Integer> current, List<Integer> holding, int numberOfConditions, int rowNumber) {
        try {
            if (current.contains(0) || current.isEmpty()) {
                return truthTable;
            }
            int i2 = 1;
            while (i2 <= numberOfConditions) {
                truthTable.put((Object)rowNumber, (Object)i2, (Object)true);
                ++i2;
            }
            if (holding.isEmpty()) {
                for (int i2 : current) {
                    truthTable.put((Object)rowNumber, (Object)i2, (Object)false);
                }
                ++rowNumber;
                int prevCondition = current.get(0) - 1;
                holding.addAll(current);
                current.clear();
                current.add(prevCondition);
                return this.mcdcTruthTableRec(truthTable, current, holding, numberOfConditions, rowNumber);
            }
            Collections.sort(current);
            Collections.sort(holding);
            int currMax = current.get(current.size() - 1);
            int holdMax = holding.get(holding.size() - 1);
            if (currMax < holdMax) {
                for (int i3 : current) {
                    truthTable.put((Object)rowNumber, (Object)i3, (Object)false);
                }
                current.add(holdMax);
                holding.removeAll(Arrays.asList(holdMax));
                return this.mcdcTruthTableRec(truthTable, current, holding, numberOfConditions, ++rowNumber);
            }
            ArrayList<Integer> toHold = new ArrayList<Integer>();
            if (currMax > holdMax) {
                for (int i4 : current) {
                    truthTable.put((Object)rowNumber, (Object)i4, (Object)false);
                }
                for (int i4 : current) {
                    if (i4 <= holdMax) continue;
                    holding.removeAll(Arrays.asList(holdMax));
                    toHold.add(i4);
                }
                ++rowNumber;
                holding.addAll(toHold);
                current.removeAll(toHold);
                current.add(holdMax);
                return this.mcdcTruthTableRec(truthTable, current, holding, numberOfConditions, rowNumber);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return truthTable;
    }

    private Multimap<Integer, Integer> determineMcdcPairs(Table<Integer, Integer, Boolean> truthTable, ArrayList<VCastMcdcCoveragePairRow> pairRows, int conditionIndex) {
        ArrayListMultimap pairs = ArrayListMultimap.create();
        for (VCastMcdcCoveragePairRow pairRowSideA : pairRows) {
            int sideARow = pairRowSideA.getRowValue();
            int sideARowResult = pairRowSideA.getRowResult();
            Map sideAConditionBools = truthTable.row((Object)sideARow);
            for (VCastMcdcCoveragePairRow pairRowSideB : pairRows) {
                int sideBRow = pairRowSideB.getRowValue();
                int sideBRowResult = pairRowSideB.getRowResult();
                Map sideBConditionBools = truthTable.row((Object)sideBRow);
                if (sideARowResult == sideBRowResult || sideAConditionBools.get(conditionIndex) == sideBConditionBools.get(conditionIndex)) continue;
                boolean singleConditionFlip = true;
                Iterator iterator = sideAConditionBools.keySet().iterator();
                while (iterator.hasNext()) {
                    boolean sideBConditionValue;
                    boolean sideAConditionValue;
                    int key = (Integer)iterator.next();
                    if (key == conditionIndex || (sideAConditionValue = ((Boolean)sideAConditionBools.get(key)).booleanValue()) == (sideBConditionValue = ((Boolean)sideBConditionBools.get(key)).booleanValue())) continue;
                    singleConditionFlip = false;
                    break;
                }
                if (!singleConditionFlip) continue;
                pairs.put((Object)sideARow, (Object)sideBRow);
            }
        }
        return pairs;
    }

    private void addDiscrepancy(Map<String, Discrepancy> discrepancies, String location, String text) {
        Discrepancy newDiscrepancy = new Discrepancy();
        newDiscrepancy.setLocation(location);
        newDiscrepancy.setText(text);
        String id = String.valueOf(Lib.generateUuid());
        newDiscrepancy.setId(id);
        discrepancies.put(id, newDiscrepancy);
    }

    private void addMcdcDiscrepancy(Map<String, Discrepancy> discrepancies, String location, String text, Map<Integer, DispoAnnotationData> pairAnnotations, String devNotes, boolean isOverloadedCondition) {
        String id = String.valueOf(Lib.generateUuid());
        Discrepancy newDiscrepancy = new Discrepancy();
        newDiscrepancy.setId(id);
        newDiscrepancy.setLocation(location);
        newDiscrepancy.setText(text);
        newDiscrepancy.setPairAnnotations(pairAnnotations);
        newDiscrepancy.setDevNotes(devNotes);
        newDiscrepancy.setIsOverloadedCondition(isOverloadedCondition);
        discrepancies.put(id, newDiscrepancy);
    }

    private DispoAnnotationData createPairAnnotation(String location, String text, boolean isRowCovered, int row, Collection<Integer> collection) {
        String id = String.valueOf(Lib.generateUuid());
        DispoAnnotationData pairAnnotation = new DispoAnnotationData();
        pairAnnotation.setId(id);
        pairAnnotation.setLocationRefs(location);
        pairAnnotation.setRow(row);
        pairAnnotation.setCustomerNotes(text);
        pairAnnotation.setIsRowCovered(isRowCovered);
        pairAnnotation.setPairedWith(collection);
        pairAnnotation.setLocationRefs(location);
        pairAnnotation.setIsPairAnnotation(true);
        pairAnnotation.setResolutionType("");
        pairAnnotation.setResolution("");
        pairAnnotation.setIsResolutionValid(false);
        pairAnnotation.setIsDefault(false);
        return pairAnnotation;
    }

    private String generateDatId(Object ... ids) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            sb.append(id);
            sb.append(":");
            ++n2;
        }
        return sb.toString();
    }

    private void processResults(VCastResult result, OperationReport report) throws Exception {
        String resultPath = result.getPath();
        String resultPathAbs = String.valueOf(this.vCastDir) + File.separator + resultPath;
        File resultsFile = new File(resultPathAbs);
        if (!resultsFile.exists()) {
            boolean fileExists = this.findAndProcessResultFile(resultsFile, resultPath, report);
            if (!fileExists) {
                report.addEntry("SQL", String.format("Could not find DAT file [%s]", resultPathAbs), DispoSummarySeverity.WARNING);
            }
        } else {
            this.process(report, resultPath, resultsFile);
        }
    }

    private boolean findAndProcessResultFile(File resultsFile, String resultPath, OperationReport report) {
        ArrayList<File> resultsDirs = new ArrayList<File>();
        resultsDirs.add(new File(String.valueOf(this.vCastDir) + File.separator + RESULTS));
        resultsDirs.add(new File(String.valueOf(this.vCastDir) + File.separator + RESULTS + File.separator + IMPORTED_RESULTS));
        for (File resultsDir : resultsDirs) {
            File[] files;
            if (!resultsDir.exists() || (files = resultsDir.listFiles()) == null) continue;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String inputF = file.toString();
                String outputF = inputF.replaceAll(this.config.getResultsFileExtRegex(), "");
                if (outputF.toString().equalsIgnoreCase(resultsFile.toString())) {
                    this.process(report, resultPath, file);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void process(OperationReport report, String resultPath, File resultsFile) {
        block15: {
            if (!this.isDuplicateFile(resultsFile, report)) {
                BufferedReader br;
                block13: {
                    block14: {
                        br = null;
                        try {
                            BufferedReader br2;
                            try {
                                String resultsLine;
                                br = new BufferedReader(new FileReader(resultsFile));
                                while ((resultsLine = br.readLine()) != null) {
                                    if (!Strings.isValid((String)resultsLine)) continue;
                                    Result datFileSyntaxResult = VCastValidateDatFileSyntax.validateDatFileSyntax((String)resultsLine);
                                    if (!datFileSyntaxResult.isTrue()) {
                                        report.addEntry("SQL", String.format("This line [%s] is not in proper format. In DAT file [%s]", resultsLine, resultsFile.getName()), DispoSummarySeverity.WARNING);
                                        continue;
                                    }
                                    if (this.alreadyUsedDatIds.contains(resultsLine)) continue;
                                    this.processDatFileLine(report, resultPath, resultsFile, resultsLine);
                                }
                                break block13;
                            }
                            catch (Exception ex) {
                                report.addEntry("EXCEPTION", ex.getMessage(), DispoSummarySeverity.ERROR);
                                br2 = null;
                                try {
                                    try {
                                        String resultsLine;
                                        br2 = new BufferedReader(new FileReader(resultsFile));
                                        while ((resultsLine = br2.readLine()) != null) {
                                            if (!Strings.isValid((String)resultsLine)) continue;
                                            Result datFileSyntaxResult = VCastValidateDatFileSyntax.validateDatFileSyntax((String)resultsLine);
                                            if (!datFileSyntaxResult.isTrue()) {
                                                report.addEntry("SQL", String.format("This line [%s] is not in proper format. In DAT file [%s]", resultsLine, resultsFile.getName()), DispoSummarySeverity.WARNING);
                                                continue;
                                            }
                                            if (this.alreadyUsedDatIds.contains(resultsLine)) continue;
                                            this.processDatFileLine(report, resultPath, resultsFile, resultsLine);
                                        }
                                    }
                                    catch (Exception ex2) {
                                        report.addEntry("EXCEPTION", ex2.getMessage(), DispoSummarySeverity.ERROR);
                                        Lib.close((AutoCloseable)br2);
                                        Lib.close((AutoCloseable)br);
                                        break block14;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Lib.close(br2);
                                    Lib.close((AutoCloseable)br);
                                    throw throwable;
                                }
                            }
                            Lib.close((AutoCloseable)br2);
                            Lib.close((AutoCloseable)br);
                        }
                        catch (Throwable throwable) {
                            Lib.close(br);
                            throw throwable;
                        }
                    }
                    Lib.close((AutoCloseable)br);
                    break block15;
                }
                Lib.close((AutoCloseable)br);
            }
        }
    }

    private void processDatFileLine(OperationReport report, String resultPath, File resultsFile, String resultsLine) {
        this.alreadyUsedDatIds.add(resultsLine);
        StringTokenizer st = new StringTokenizer(resultsLine);
        int count = st.countTokens();
        if (count == 3) {
            Matcher m = fileMethod3LineNumberPattern.matcher(resultsLine);
            if (m.find()) {
                this.processSingleResult(resultPath, m);
            }
        } else if (count == 4) {
            Matcher m = fileMethod4LineNumberPlusTokenPattern.matcher(resultsLine);
            if (m.find()) {
                this.processSingleResultBranch(resultPath, m);
            }
        } else if (count == 5) {
            Matcher m = fileMethod5LineNumberPattern.matcher(resultsLine);
            if (m.find()) {
                this.processMultiResultMCDC(resultPath, m);
            }
        } else {
            report.addEntry("RESULTS FILE PARSE", String.format("This line [%s] could not be parsed. In DAT file [%s]", resultsLine, resultsFile.getName()), DispoSummarySeverity.WARNING);
        }
    }

    private boolean isDuplicateFile(File file, OperationReport report) {
        String normalizedFileName = file.getName().replace("//....", "");
        if (this.alreadyUsedFileNames.contains(normalizedFileName)) {
            report.addEntry(file.getName(), "Duplicate File skipped", DispoSummarySeverity.WARNING);
            return true;
        }
        this.alreadyUsedFileNames.add(normalizedFileName);
        return false;
    }

    private void processSingleResult(String resultPath, Matcher m) {
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null) {
            String location = m.group(3);
            String discrepancyText = "";
            Discrepancy matchingDiscrepancy = this.matchDiscrepancy(location, item.getDiscrepanciesList());
            if (matchingDiscrepancy != null) {
                discrepancyText = matchingDiscrepancy.getText();
                Map discrepancies = item.getDiscrepanciesList();
                discrepancies.remove(matchingDiscrepancy.getId());
                this.datIdsCoveredByException.remove(this.generateDatId(m.group(1), m.group(2), m.group(3)));
                item.setDiscrepanciesList(discrepancies);
                this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, discrepancyText);
            }
        }
    }

    private void processSingleResultBranch(String resultPath, Matcher m) {
        String location;
        Discrepancy matchingDiscrepancy;
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null && (matchingDiscrepancy = this.matchDiscrepancy(location = String.valueOf(m.group(3)) + "." + m.group(4), item.getDiscrepanciesList())) != null) {
            String text = matchingDiscrepancy.getText();
            Map discrepancies = item.getDiscrepanciesList();
            discrepancies.remove(matchingDiscrepancy.getId());
            this.datIdsCoveredByException.remove(this.generateDatId(m.group(1), m.group(2), m.group(3), m.group(4)));
            item.setDiscrepanciesList(discrepancies);
            this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, text);
        }
    }

    private void processMultiResultMCDC(String resultPath, Matcher m) {
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null) {
            Integer lineNumber = Integer.valueOf(m.group(3));
            Integer bitsValue = Integer.valueOf(m.group(4));
            Integer bitsMask = Integer.valueOf(m.group(5));
            Map<String, Boolean> bitsTrueMap = this.getBitToBoolean(Integer.toString(bitsValue, 2), Integer.toString(bitsMask, 2));
            for (String abbrevCond : bitsTrueMap.keySet()) {
                String location = "";
                location = bitsTrueMap.get(abbrevCond) == null ? this.formatLocation(lineNumber, abbrevCond, " ") : (bitsTrueMap.get(abbrevCond) != false ? this.formatLocation(lineNumber, abbrevCond, "T") : this.formatLocation(lineNumber, abbrevCond, "F"));
                Discrepancy matchingDiscrepancy = this.matchDiscrepancy(location, item.getDiscrepanciesList());
                if (matchingDiscrepancy == null) continue;
                String text = matchingDiscrepancy.getText();
                Map discrepancies = item.getDiscrepanciesList();
                if (matchingDiscrepancy.getPairAnnotations() != null && !matchingDiscrepancy.getPairAnnotations().isEmpty() && !matchingDiscrepancy.getIsOverloadedCondition()) {
                    this.addAnnotationForCoveredMcdcLine(item, location, "Test_Script", resultPath, text, matchingDiscrepancy.getPairAnnotations());
                    discrepancies.remove(matchingDiscrepancy.getId());
                } else if (matchingDiscrepancy.getIsOverloadedCondition()) {
                    this.addAnnotationForOverloadedMcdcLine(item, location, text, resultPath, matchingDiscrepancy.getDevNotes());
                } else {
                    this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, text);
                    discrepancies.remove(matchingDiscrepancy.getId());
                }
                this.datIdsCoveredByException.remove(this.generateDatId(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5)));
                item.setDiscrepanciesList(discrepancies);
            }
        }
    }

    private String formatLocation(int lineNumber, String abbrevCond, String TorF) {
        if (abbrevCond.length() != 1 || abbrevCond.charAt(0) < 'A' || abbrevCond.charAt(0) > 'Z') {
            return String.format("%s.%s.%s", lineNumber, abbrevCond, TorF);
        }
        return String.format("%s.%s", lineNumber, String.valueOf(abbrevCond.charAt(0) - 64) + " (P" + abbrevCond.toLowerCase() + ")");
    }

    private Map<String, Boolean> getBitToBoolean(String bitsValue, String bitsMask) {
        String key;
        HashMap<String, Boolean> toReturn = new HashMap<String, Boolean>();
        char[] bitsMaskedArray = bitsMask.toCharArray();
        char[] bitsValueArray = bitsValue.toCharArray();
        int totalResultIndex = bitsValueArray.length - 1;
        int sizeDelta = bitsMaskedArray.length - bitsValueArray.length;
        int highestChar = 63 + bitsMaskedArray.length;
        int i = 0;
        while (i < sizeDelta) {
            char valueMaskBit = bitsMaskedArray[i];
            char c = (char)highestChar--;
            key = Character.toString(c);
            if (valueMaskBit == '1') {
                toReturn.put(key, false);
            } else {
                toReturn.put(key, null);
            }
            ++i;
        }
        i = 0;
        while (i < bitsValueArray.length) {
            char valueC = bitsValueArray[i];
            char valueMaskBit = bitsMaskedArray[i + sizeDelta];
            key = "";
            if (i != totalResultIndex) {
                char c = (char)highestChar--;
                key = Character.toString(c);
            } else {
                key = "RESULT";
            }
            if (valueMaskBit == '0' && valueC == '0') {
                toReturn.put(key, null);
            } else {
                toReturn.put(key, valueC == '1');
            }
            ++i;
        }
        return toReturn;
    }

    private Discrepancy matchDiscrepancy(String location, Map<String, Discrepancy> discrepancies) {
        Discrepancy toReturn = null;
        for (String key : discrepancies.keySet()) {
            Discrepancy discrepancy = discrepancies.get(key);
            if (!String.valueOf(discrepancy.getLocation()).equals(location)) continue;
            toReturn = discrepancy;
            break;
        }
        return toReturn;
    }

    private DispoAnnotationData matchOldAnnotation(Discrepancy discrepancy, List<DispoItem> oldItems, DispoItemData item) {
        DispoAnnotationData toReturn = null;
        DispoItem dispoItem = null;
        if (!oldItems.isEmpty()) {
            for (DispoItem oldItem : oldItems) {
                if (!String.valueOf(oldItem.getName()).equals(item.getName())) continue;
                dispoItem = oldItem;
                break;
            }
            if (dispoItem != null) {
                for (DispoAnnotationData value : dispoItem.getAnnotationsList()) {
                    if (!String.valueOf(value.getLocationRefs()).equals(discrepancy.getLocation())) continue;
                    toReturn = value;
                    return toReturn;
                }
            }
        }
        return toReturn;
    }

    private void keepExistingAnnotation(DispoItemData item, DispoAnnotationData existingAnnotation) {
        Discrepancy matchingDiscrepancy;
        String location = existingAnnotation.getLocationRefs();
        if (location.contains("(P") && (matchingDiscrepancy = this.matchDiscrepancy(location, item.getDiscrepanciesList())).getPairAnnotations() != null && !matchingDiscrepancy.getPairAnnotations().isEmpty() && !matchingDiscrepancy.getIsOverloadedCondition()) {
            HashMap<Integer, DispoAnnotationData> pairAnnotations = new HashMap<Integer, DispoAnnotationData>();
            pairAnnotations.putAll(matchingDiscrepancy.getPairAnnotations());
            existingAnnotation.setPossiblePairs(this.getPossiblePairs(pairAnnotations, item));
            existingAnnotation.setSatisfiedPairs("");
        }
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        existingAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, existingAnnotation);
    }

    private void addBlankAnnotationForUncoveredLine(DispoItemData item, String location, String text, String lastResolution) {
        Discrepancy matchingDiscrepancy;
        DispoAnnotationData newAnnotation = new DispoAnnotationData();
        this.dataFactory.initAnnotation(newAnnotation);
        String idOfNewAnnotation = this.dataFactory.getNewId();
        newAnnotation.setId(idOfNewAnnotation);
        newAnnotation.setIsDefault(false);
        newAnnotation.setLocationRefs(location);
        newAnnotation.setResolutionType("");
        newAnnotation.setResolution("");
        newAnnotation.setLastResolution(lastResolution);
        newAnnotation.setIsResolutionValid(false);
        newAnnotation.setCustomerNotes(text);
        if (location.contains("(P") && (matchingDiscrepancy = this.matchDiscrepancy(location, item.getDiscrepanciesList())).getPairAnnotations() != null && !matchingDiscrepancy.getPairAnnotations().isEmpty() && !matchingDiscrepancy.getIsOverloadedCondition()) {
            HashMap<Integer, DispoAnnotationData> pairAnnotations = new HashMap<Integer, DispoAnnotationData>();
            pairAnnotations.putAll(matchingDiscrepancy.getPairAnnotations());
            newAnnotation.setPossiblePairs(this.getPossiblePairs(pairAnnotations, item));
            newAnnotation.setSatisfiedPairs("");
        }
        this.dispoConnector.connectAnnotation(newAnnotation, item.getDiscrepanciesList());
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        newAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, newAnnotation);
    }

    private void addAnnotationForCoveredLine(DispoItemData item, String location, String resolutionType, String coveringFile, String text) {
        DispoAnnotationData newAnnotation = new DispoAnnotationData();
        this.dataFactory.initAnnotation(newAnnotation);
        String idOfNewAnnotation = this.dataFactory.getNewId();
        newAnnotation.setId(idOfNewAnnotation);
        newAnnotation.setIsDefault(true);
        newAnnotation.setLocationRefs(location);
        newAnnotation.setResolutionType(resolutionType);
        newAnnotation.setResolution(coveringFile);
        newAnnotation.setLastResolution("N/A");
        newAnnotation.setIsResolutionValid(true);
        newAnnotation.setCustomerNotes(text);
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        newAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, newAnnotation);
    }

    private void addAnnotationForOverloadedMcdcLine(DispoItemData item, String location, String text, String lastResolution, String developerNotes) {
        DispoAnnotationData newAnnotation = new DispoAnnotationData();
        this.dataFactory.initAnnotation(newAnnotation);
        String idOfNewAnnotation = this.dataFactory.getNewId();
        newAnnotation.setId(idOfNewAnnotation);
        newAnnotation.setIsDefault(false);
        newAnnotation.setLocationRefs(location);
        newAnnotation.setResolutionType("");
        newAnnotation.setResolution("");
        newAnnotation.setLastResolution(lastResolution);
        newAnnotation.setIsResolutionValid(false);
        newAnnotation.setCustomerNotes(text);
        newAnnotation.setDeveloperNotes(developerNotes);
        this.dispoConnector.connectAnnotation(newAnnotation, item.getDiscrepanciesList());
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        newAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, newAnnotation);
    }

    private boolean addAnnotationForCoveredMcdcLine(DispoItemData item, String location, String resolutionType, String coveringFile, String text, Map<Integer, DispoAnnotationData> pairAnnotations) {
        boolean isCovered = false;
        DispoAnnotationData newAnnotation = new DispoAnnotationData();
        this.dataFactory.initAnnotation(newAnnotation);
        String idOfNewAnnotation = this.dataFactory.getNewId();
        newAnnotation.setId(idOfNewAnnotation);
        newAnnotation.setLocationRefs(location);
        newAnnotation.setLastResolution("N/A");
        newAnnotation.setCustomerNotes(text);
        List<String> satisfiedPairs = this.getSatisfiedPairs(pairAnnotations, resolutionType, coveringFile);
        String possiblePairs = this.getPossiblePairs(pairAnnotations, item);
        newAnnotation.setPossiblePairs(possiblePairs);
        if (!satisfiedPairs.isEmpty()) {
            newAnnotation.setIsDefault(true);
            newAnnotation.setResolutionType(resolutionType);
            newAnnotation.setResolution(coveringFile);
            newAnnotation.setIsResolutionValid(true);
            newAnnotation.setSatisfiedPairs(String.format("Pairs Satisfied By: %s", satisfiedPairs.toString()));
            isCovered = true;
        } else {
            newAnnotation.setIsDefault(false);
            newAnnotation.setResolutionType("");
            newAnnotation.setResolution("");
            newAnnotation.setIsResolutionValid(false);
            newAnnotation.setSatisfiedPairs("");
        }
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        newAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, newAnnotation);
        return isCovered;
    }

    private List<String> getSatisfiedPairs(Map<Integer, DispoAnnotationData> pairAnnotations, String resolutionType, String resolution) {
        ArrayList<String> satisfiedPairs = new ArrayList<String>();
        for (DispoAnnotationData pairAnnotation : pairAnnotations.values()) {
            if (!pairAnnotation.getIsRowCovered()) continue;
            pairAnnotation.setResolutionType(resolutionType);
            pairAnnotation.setResolution(resolution);
            pairAnnotation.setIsResolutionValid(true);
            pairAnnotation.setIsDefault(true);
            Iterator iterator = pairAnnotation.getPairedWith().iterator();
            while (iterator.hasNext()) {
                int pair = (Integer)iterator.next();
                int sideARow = pairAnnotation.getRow();
                if (sideARow >= pair || !pairAnnotations.get(pair).getIsRowCovered()) continue;
                satisfiedPairs.add(String.format("%s/%s", sideARow, pair));
            }
        }
        return satisfiedPairs;
    }

    private String getPossiblePairs(Map<Integer, DispoAnnotationData> pairAnnotations, DispoItemData item) {
        ArrayList<String> possiblePairs = new ArrayList<String>();
        for (DispoAnnotationData pairAnnotation : pairAnnotations.values()) {
            List annotationsList = item.getAnnotationsList();
            int newIndex = annotationsList.size();
            pairAnnotation.setIndex(newIndex);
            annotationsList.add(newIndex, pairAnnotation);
            Iterator iterator = pairAnnotation.getPairedWith().iterator();
            while (iterator.hasNext()) {
                int pair = (Integer)iterator.next();
                int sideARow = pairAnnotation.getRow();
                if (sideARow >= pair || !pairAnnotations.get(pair).getIsRowCovered()) continue;
                possiblePairs.add(String.format("%s/%s", sideARow, pair));
            }
        }
        return String.format("Possible Pairs: %s", ((Object)possiblePairs).toString());
    }

    private Collection<VCastResult> getResultFiles(VCastDataStore dataStore) {
        Collection results = null;
        results = dataStore.getAllResults();
        return results;
    }

    private String normalizeLisFileName(String fileName) {
        return fileName.replaceAll("^.*(\\\\|\\/)", "").toLowerCase();
    }
}

