/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal;

import java.util.Map;
import javax.naming.NamingException;
import org.eclipse.osee.authentication.ldap.internal.util.LdapEntry;
import org.eclipse.osee.authentication.ldap.internal.util.VariablePattern;

public class LdapAccount {
    private final LdapEntry ldapEntry;
    private final VariablePattern accountFullName;
    private final VariablePattern accountEmailAddress;
    private final VariablePattern accountUserName;

    public LdapAccount(LdapEntry ldapEntry, VariablePattern accountFullName, VariablePattern accountEmailAddress, VariablePattern accountUserName) {
        this.ldapEntry = ldapEntry;
        this.accountFullName = accountFullName;
        this.accountEmailAddress = accountEmailAddress;
        this.accountUserName = accountUserName;
    }

    public String getDistinguishedName() throws NamingException {
        return this.ldapEntry.getDistinguishedName();
    }

    public String getField(String key) throws NamingException {
        return this.ldapEntry.get(key);
    }

    public String getDisplayName() throws NamingException {
        return LdapAccount.getEntry(this.ldapEntry, this.accountFullName);
    }

    public String getUserName() throws NamingException {
        return LdapAccount.getEntry(this.ldapEntry, this.accountUserName);
    }

    public String getEmailAddress() throws NamingException {
        return LdapAccount.getEntry(this.ldapEntry, this.accountEmailAddress);
    }

    private static String getEntry(LdapEntry entry, VariablePattern pattern) throws NamingException {
        String toReturn = null;
        if (pattern != null) {
            Map<String, String> values = entry.asMap();
            String value = pattern.expandVariables(values);
            toReturn = value.isEmpty() ? null : value;
        }
        return toReturn;
    }
}

