/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.test;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.test.AtsTestUtilCore;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class VersionRelationToggleServerTest {
    private final AtsApi atsApi;
    private final XResultData rd;

    public VersionRelationToggleServerTest(AtsApi atsApi, XResultData rd) {
        this.atsApi = atsApi;
        this.rd = rd;
    }

    public XResultData run() {
        this.testSettingSameVersionDoesNotCreateTransaction();
        this.testToggledTargetVersionLoadsCorrectly();
        AtsTestUtilCore.cleanupSimpleTest((String)this.getClass().getSimpleName());
        return this.rd;
    }

    public void testSettingSameVersionDoesNotCreateTransaction() {
        this.rd.log("Started VersionRelationToggleServerTest.testSettingSameVersionDoesNotCreateTransaction");
        AtsUser joe = this.atsApi.getUserService().getUserByToken(DemoUsers.Joe_Smith);
        AtsTestUtilCore.cleanupAndReset((String)this.getClass().getSimpleName(), (boolean)false, (AtsUser)joe);
        IAtsTeamWorkflow teamWf = AtsTestUtilCore.getTeamWf();
        IAtsVersion version1 = AtsTestUtilCore.getVerArt1();
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getClass().getSimpleName(), joe);
        this.atsApi.getVersionService().setTargetedVersion(teamWf, version1, changes);
        changes.executeIfNeeded();
        teamWf = this.reloadAttributesAndRelations(teamWf, this.atsApi, this.rd);
        this.testVersionCalls(this.atsApi, teamWf, version1, this.rd);
        changes = this.atsApi.createChangeSet(this.getClass().getSimpleName(), joe);
        this.atsApi.getVersionService().setTargetedVersion(teamWf, version1, changes);
        TransactionToken tx = changes.executeIfNeeded();
        this.assertEquals(Boolean.TRUE, tx.isInvalid(), this.rd);
        AtsTestUtilCore.cleanup();
        this.rd.log("Completed");
    }

    public void testToggledTargetVersionLoadsCorrectly() {
        this.rd.log("Started VersionRelationToggleServerTest.testToggledTargetVersionLoadsCorrectly");
        AtsUser joe = this.atsApi.getUserService().getUserByToken(DemoUsers.Joe_Smith);
        AtsTestUtilCore.cleanupAndReset((String)this.getClass().getSimpleName(), (boolean)false, (AtsUser)joe);
        IAtsTeamWorkflow teamWf = AtsTestUtilCore.getTeamWf();
        IAtsVersion version1 = AtsTestUtilCore.getVerArt1();
        IAtsVersion version2 = AtsTestUtilCore.getVerArt2();
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getClass().getSimpleName(), joe);
        this.atsApi.getVersionService().setTargetedVersion(teamWf, version1, changes);
        changes.execute();
        teamWf = this.reloadAttributesAndRelations(teamWf, this.atsApi, this.rd);
        this.testVersionCalls(this.atsApi, teamWf, version1, this.rd);
        changes = this.atsApi.createChangeSet(this.getClass().getSimpleName(), joe);
        this.atsApi.getVersionService().setTargetedVersion(teamWf, version2, changes);
        changes.execute();
        teamWf = this.reloadAttributesAndRelations(teamWf, this.atsApi, this.rd);
        this.testVersionCalls(this.atsApi, teamWf, version2, this.rd);
        changes = this.atsApi.createChangeSet(this.getClass().getSimpleName(), joe);
        this.atsApi.getVersionService().setTargetedVersion(teamWf, version1, changes);
        changes.execute();
        teamWf = this.reloadAttributesAndRelations(teamWf, this.atsApi, this.rd);
        this.testVersionCalls(this.atsApi, teamWf, version1, this.rd);
        changes = this.atsApi.createChangeSet(this.getClass().getSimpleName(), joe);
        this.atsApi.getVersionService().setTargetedVersion(teamWf, version2, changes);
        changes.execute();
        teamWf = this.reloadAttributesAndRelations(teamWf, this.atsApi, this.rd);
        this.testVersionCalls(this.atsApi, teamWf, version2, this.rd);
        AtsTestUtilCore.cleanup();
        this.rd.log("Completed");
    }

    private IAtsTeamWorkflow reloadAttributesAndRelations(IAtsTeamWorkflow teamWf, AtsApi atsApi, XResultData rd) {
        return atsApi.getWorkItemService().getTeamWf(atsApi.getQueryService().getArtifact(teamWf.getId()));
    }

    private void testVersionCalls(AtsApi atsApi, IAtsTeamWorkflow teamWf, IAtsVersion version, XResultData rd) {
        Collection versions = atsApi.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
        this.assertEquals(versions.size(), 1, rd);
        if (!versions.isEmpty()) {
            this.assertEquals(version, versions.iterator().next(), rd);
        }
        versions = atsApi.getRelationResolver().getRelated((ArtifactId)teamWf.getStoreObject(), AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
        this.assertEquals(versions.size(), 1, rd);
        if (!versions.isEmpty()) {
            this.assertEquals(version, versions.iterator().next(), rd);
        }
    }

    private void assertEquals(Object obj1, Object obj2, XResultData rd) {
        if (!obj1.equals(obj2)) {
            rd.errorf("Not Equal [%s] [%s]", new Object[]{obj1, obj2});
        }
    }
}

