/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.util.IAtsOperationCache;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;

public class AtsOperationCache
implements IAtsOperationCache {
    private final AtsApi atsApi;
    private final Map<Long, IAtsTeamWorkflow> idToTeamWf = new HashMap<Long, IAtsTeamWorkflow>(20000);
    private final Map<Long, IAtsTask> idToTask = new HashMap<Long, IAtsTask>(30000);
    private final Map<Long, IAtsAbstractReview> idToReview = new HashMap<Long, IAtsAbstractReview>(4000);
    private List<ArtifactToken> teamDefArts;
    private List<ArtifactToken> aiArts;
    private boolean debug = false;

    public AtsOperationCache(AtsApi atsApi, boolean debug) {
        this.atsApi = atsApi;
        this.debug = debug;
    }

    public IAtsTeamWorkflow getParentTeamWorkflow(IAtsWorkItem workItem, HealthCheckResults results) {
        if (workItem.isTeamWorkflow()) {
            return (IAtsTeamWorkflow)workItem;
        }
        List ids = null;
        if (workItem.isTask()) {
            ids = ((ArtifactReadable)workItem.getStoreObject()).getRelatedIds(AtsRelationTypes.TeamWfToTask_TeamWorkflow);
        } else if (workItem.isReview()) {
            ids = ((ArtifactReadable)workItem.getStoreObject()).getRelatedIds(AtsRelationTypes.TeamWorkflowToReview_TeamWorkflow);
        }
        if (ids == null || ids.size() == 0) {
            if (this.debug) {
                results.log(workItem.getArtifactId(), "getParentTeamWorkflow", String.format("Error: No parent workflow for %s", workItem.toStringWithId()));
            }
            return null;
        }
        if (ids.size() == 2) {
            if (this.debug) {
                results.log(workItem.getArtifactId(), "getParentTeamWorkflow", String.format("Error: Multiple parent workflows for %s", workItem.toStringWithId()));
            }
            return null;
        }
        ArtifactId id = (ArtifactId)ids.iterator().next();
        IAtsTeamWorkflow teamWf = this.idToTeamWf.get(id.getId());
        if (teamWf == null) {
            teamWf = this.atsApi.getQueryService().getTeamWf(id);
            this.idToTeamWf.put(id.getId(), teamWf);
        }
        return teamWf;
    }

    public List<ArtifactToken> getTeamDefinitions() {
        if (this.teamDefArts == null) {
            this.teamDefArts = this.atsApi.getQueryService().getArtifacts(AtsArtifactTypes.TeamDefinition);
        }
        return this.teamDefArts;
    }

    public List<ArtifactToken> getActionableItems() {
        if (this.aiArts == null) {
            this.aiArts = this.atsApi.getQueryService().getArtifacts(AtsArtifactTypes.ActionableItem);
        }
        return this.aiArts;
    }

    public void addTeamWf(ArtifactToken teamWfArt) {
        IAtsTeamWorkflow teamWf = this.atsApi.getWorkItemService().getTeamWf(teamWfArt);
        this.idToTeamWf.put(teamWf.getId(), teamWf);
    }

    public void addTask(IAtsTask task) {
        this.idToTask.put(task.getId(), task);
    }

    public Map<Long, IAtsTask> getTasks() {
        return this.idToTask;
    }

    public void addReview(IAtsAbstractReview review) {
        this.idToReview.put(review.getId(), review);
    }

    public Map<Long, IAtsAbstractReview> getReviews() {
        return this.idToReview;
    }
}

