/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsProductLineEndpointApi;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.Attribute;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ActionOperations;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranchCategoryTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;

public final class AtsProductLineEndpointImpl
implements AtsProductLineEndpointApi {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;

    public AtsProductLineEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public List<BranchToken> getBranches(String branchQueryType, String workType) {
        if (!WorkType.valueOfOrNone((String)workType).equals((Object)WorkType.None)) {
            ArrayList<Pair> artAttrPairs = new ArrayList<Pair>();
            artAttrPairs.add(new Pair((Object)AtsArtifactTypes.TeamDefinition, (Object)AtsAttributeTypes.WorkType));
            artAttrPairs.add(new Pair((Object)AtsArtifactTypes.TeamWorkflow, (Object)AtsAttributeTypes.TeamDefinitionReference));
            List<Object> pleBranchList = new ArrayList<BranchToken>();
            if (branchQueryType.equals("baseline")) {
                pleBranchList = ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andIsOfCategory(CoreBranchCategoryTokens.PLE)).includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE})).andStateIs(new BranchState[]{BranchState.MODIFIED, BranchState.CREATED})).getResultsAsId().getList();
            }
            if (branchQueryType.equals("working")) {
                pleBranchList = ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andIsOfCategory(CoreBranchCategoryTokens.PLE)).includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.MODIFIED, BranchState.CREATED})).mapAssocArtIdToRelatedAttributes(workType, (BranchId)CoreBranches.COMMON, artAttrPairs)).getResultsAsId().getList();
            }
            Collections.sort(pleBranchList);
            return pleBranchList;
        }
        return Collections.EMPTY_LIST;
    }

    public XResultData checkPlarbApproval(String id) {
        XResultData rd = new XResultData();
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        ActionOperations ops = new ActionOperations(workItem, this.atsApi, this.orcsApi);
        Attribute approval = ops.getActionAttributeValues((AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedBy, workItem);
        if (approval.getValues().isEmpty()) {
            rd.error("Working branch has not yet been approved by PLARB");
        }
        return rd;
    }

    public XResultData setPlarbApproval(String id) {
        XResultData rd = new XResultData();
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Plarb approval user");
        Date resultDate = new Date(System.currentTimeMillis());
        UserToken account = this.orcsApi.userService().getUser();
        if (account.isInvalid()) {
            rd.error("Account Id not passed properly.  See Admin for help.");
        }
        changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedBy, account.getIdString());
        changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedDate, (Object)resultDate);
        changes.execute();
        return rd;
    }
}

