/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Objects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class ArtifactSpecification
extends BranchSpecification {
    protected final ArtifactId artifactId;

    public ArtifactSpecification(ArtifactId artifactId) {
        this(BranchId.SENTINEL, ArtifactId.SENTINEL, artifactId);
    }

    public ArtifactSpecification(BranchId branchId, ArtifactId artifactId) {
        this(branchId, ArtifactId.SENTINEL, artifactId);
    }

    public ArtifactSpecification(BranchId branchId, ArtifactId viewId, ArtifactId artifactId) {
        super(branchId, viewId);
        this.artifactId = BranchSpecification.cleanArtifactId(artifactId);
    }

    public ArtifactId getArtifactId() {
        return this.artifactId;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ArtifactSpecification)) {
            return false;
        }
        ArtifactSpecification otherArtifactSpecification = (ArtifactSpecification)other;
        return this.artifactId.getId().equals(otherArtifactSpecification.artifactId.getId()) && this.branchId.getId().equals(otherArtifactSpecification.branchId.getId()) && this.branchId.getViewId().getId().equals(otherArtifactSpecification.getViewId().getId());
    }

    @Override
    public int hashCode() {
        Long a = this.artifactId.getId();
        Long b = this.branchId.getId();
        Long c = this.branchId.getViewId().getId();
        long d = Long.rotateLeft((a << 5) - a, 24) ^ b * b - b;
        long r = Long.rotateLeft((d << 5) - d, 24) ^ c * c - c;
        return (int)(r >> 32 ^ r) & 0xFFFFFFFF;
    }

    @Override
    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.title((CharSequence)"Artifact Specification").indentInc().segment((CharSequence)"Branch Identifier", (Object)(this.branchId.getId().equals(Id.SENTINEL) ? "SENTINEL" : this.branchId.getIdString())).segment((CharSequence)"View Identifier", (Object)(this.branchId.getViewId().getId().equals(Id.SENTINEL) ? "SENTINEL" : this.branchId.getViewId().getIdString())).segment((CharSequence)"Artifact Identifier", (Object)(this.artifactId.getId().equals(Id.SENTINEL) ? "SENTINEL" : this.artifactId.getIdString())).indentDec();
        return outMessage;
    }
}

