/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.ArtifactTypeAttributeTypeMetaData;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristic;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.Multiplicity;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.Id;

public final class AttributeMultiplicity
extends ConcurrentHashMap<AttributeTypeToken, ArtifactTypeAttributeTypeMetaData<?>> {
    private static final long serialVersionUID = 1L;
    private final ArtifactTypeToken artifactType;
    private final List<ComputedCharacteristicToken<?>> computedCharacteristics = new ArrayList();

    public AttributeMultiplicity(Long id, NamespaceToken namespace, String name, boolean isAbstract, OseeImage image, List<ArtifactTypeToken> superTypes) {
        ArtifactTypeToken artifactType;
        this.artifactType = artifactType = ArtifactTypeToken.create(id, namespace, name, isAbstract, this, image, superTypes);
    }

    public AttributeMultiplicity(Long id, NamespaceToken namespace, String name, boolean isAbstract, List<ArtifactTypeToken> superTypes) {
        ArtifactTypeToken artifactType;
        this.artifactType = artifactType = ArtifactTypeToken.create(id, namespace, name, isAbstract, this, superTypes);
    }

    public AttributeMultiplicity(Long id, NamespaceToken namespace, String name, boolean isAbstract, OseeImage image, ArtifactTypeToken ... superTypes) {
        this(id, namespace, name, isAbstract, image, Arrays.asList(superTypes));
    }

    public AttributeMultiplicity(Long id, NamespaceToken namespace, String name, boolean isAbstract, ArtifactTypeToken ... superTypes) {
        ArtifactTypeToken artifactType;
        this.artifactType = artifactType = ArtifactTypeToken.create(id, namespace, name, isAbstract, this, Arrays.asList(superTypes));
    }

    public <T> AttributeMultiplicity any(AttributeTypeGeneric<T> attributeType, T defaultValue, String description) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData<T>(Multiplicity.ANY, defaultValue));
        return this;
    }

    public <T> AttributeMultiplicity any(AttributeTypeGeneric<T> attributeType, T defaultValue) {
        return this.any(attributeType, defaultValue, "");
    }

    public <T> AttributeMultiplicity any(AttributeTypeGeneric<T> attributeType) {
        return this.any(attributeType, attributeType.getBaseAttributeTypeDefaultValue());
    }

    public <T> AttributeMultiplicity exactlyOne(AttributeTypeGeneric<T> attributeType, T defaultValue, String description) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData<T>(Multiplicity.EXACTLY_ONE, defaultValue));
        return this;
    }

    public <T> AttributeMultiplicity exactlyOne(AttributeTypeGeneric<T> attributeType, T defaultValue) {
        return this.exactlyOne(attributeType, defaultValue, "");
    }

    public <T> AttributeMultiplicity exactlyOne(AttributeTypeGeneric<T> attributeType) {
        return this.exactlyOne(attributeType, attributeType.getBaseAttributeTypeDefaultValue());
    }

    public <T> AttributeMultiplicity zeroOrOne(AttributeTypeGeneric<T> attributeType, T defaultValue) {
        return this.zeroOrOne(attributeType, defaultValue, "");
    }

    public <T> AttributeMultiplicity zeroOrOne(AttributeTypeGeneric<T> attributeType, T defaultValue, String description) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData<T>(Multiplicity.ZERO_OR_ONE, defaultValue));
        return this;
    }

    public <T> AttributeMultiplicity zeroOrOne(AttributeTypeGeneric<T> attributeType) {
        return this.zeroOrOne(attributeType, attributeType.getBaseAttributeTypeDefaultValue());
    }

    public <T> AttributeMultiplicity atLeastOne(AttributeTypeGeneric<T> attributeType, T defaultValue, String description) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData<T>(Multiplicity.AT_LEAST_ONE, defaultValue));
        return this;
    }

    public <T> AttributeMultiplicity atLeastOne(AttributeTypeGeneric<T> attributeType, T defaultValue) {
        return this.atLeastOne(attributeType, defaultValue, "");
    }

    public <T> AttributeMultiplicity atLeastOne(AttributeTypeGeneric<T> attributeType) {
        return this.atLeastOne(attributeType, attributeType.getBaseAttributeTypeDefaultValue());
    }

    public <T extends EnumToken> AttributeMultiplicity any(AttributeTypeEnum<T> attributeType, T defaultValue, String[] enumeratedValues) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData<T>(Multiplicity.ANY, defaultValue, enumeratedValues));
        return this;
    }

    public <T extends EnumToken> AttributeMultiplicity exactlyOne(AttributeTypeEnum<T> attributeType, T defaultValue, String[] enumeratedValues) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData<T>(Multiplicity.EXACTLY_ONE, defaultValue, enumeratedValues));
        return this;
    }

    public <T extends EnumToken> AttributeMultiplicity zeroOrOne(AttributeTypeEnum<T> attributeType, T defaultValue, String[] enumeratedValues) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData<T>(Multiplicity.ZERO_OR_ONE, defaultValue, enumeratedValues));
        return this;
    }

    public <T extends EnumToken> AttributeMultiplicity atLeastOne(AttributeTypeEnum<T> attributeType, T defaultValue, String[] enumeratedValues) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData<T>(Multiplicity.AT_LEAST_ONE, defaultValue, enumeratedValues));
        return this;
    }

    public <T> AttributeMultiplicity computed(ComputedCharacteristic<T> computedCharacteristic) {
        this.computedCharacteristics.add(computedCharacteristic);
        return this;
    }

    public List<ComputedCharacteristicToken<?>> getComputedCharacteristics() {
        return this.computedCharacteristics;
    }

    public Integer getMinimum(AttributeTypeToken attributeType) {
        return this.getMultiplicity(attributeType).matches(new Id[]{Multiplicity.ANY, Multiplicity.ZERO_OR_ONE}) ? 0 : 1;
    }

    public Integer getMaximum(AttributeTypeToken attributeType) {
        return this.getMultiplicity(attributeType).matches(new Id[]{Multiplicity.EXACTLY_ONE, Multiplicity.ZERO_OR_ONE}) ? 1 : Integer.MAX_VALUE;
    }

    public Multiplicity getMultiplicity(AttributeTypeToken attributeType) {
        ArtifactTypeAttributeTypeMetaData typeMetaData = (ArtifactTypeAttributeTypeMetaData)this.get(attributeType);
        if (typeMetaData == null) {
            return Multiplicity.SENTINEL;
        }
        return typeMetaData.getMultiplicity();
    }

    public <T> T getAttributeDefault(AttributeTypeGeneric<T> attributeType) {
        try {
            return ((ArtifactTypeAttributeTypeMetaData)this.get(attributeType)).getDefaultValue();
        }
        catch (Exception exception) {
            return attributeType.getBaseAttributeTypeDefaultValue();
        }
    }

    public ArtifactTypeToken get() {
        return this.artifactType;
    }

    public <T extends EnumToken> List<T> getValidEnumValues(AttributeTypeEnum<T> attributeType) {
        ArrayList<EnumToken> validEnumTokens = new ArrayList<EnumToken>();
        try {
            for (EnumToken enumToken : attributeType.getEnumValuesByNamespace(this.artifactType.getNamespace())) {
                String[] stringArray = ((ArtifactTypeAttributeTypeMetaData)this.get(attributeType)).getValidEnumValues();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String enumeratedValue = stringArray[n2];
                    if (enumToken.getName().equals(enumeratedValue)) {
                        validEnumTokens.add(enumToken);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            validEnumTokens.addAll(attributeType.getEnumValuesByNamespace(this.artifactType.getNamespace()));
        }
        if (validEnumTokens.isEmpty()) {
            validEnumTokens.addAll(attributeType.getEnumValuesByNamespace(this.artifactType.getNamespace()));
        }
        return validEnumTokens;
    }

    public List<AttributeTypeToken> getValidAttributeTypes() {
        ArrayList<AttributeTypeToken> attributeTypes = new ArrayList<AttributeTypeToken>(this.size());
        this.forEachKey(50000L, attributeTypes::add);
        return attributeTypes;
    }

    public void getSingletonAttributeTypes(Set<AttributeTypeToken> attributeTypeTokens) {
        for (Map.Entry entry : this.entrySet()) {
            if (!((ArtifactTypeAttributeTypeMetaData)entry.getValue()).getMultiplicity().matches(new Id[]{Multiplicity.EXACTLY_ONE, Multiplicity.ZERO_OR_ONE})) continue;
            attributeTypeTokens.add((AttributeTypeToken)entry.getKey());
        }
    }
}

