/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.publishing.DataRight;
import org.eclipse.osee.framework.core.publishing.DataRightAnchor;
import org.eclipse.osee.framework.core.publishing.DataRightAnchorSkinny;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class DataRightResult
implements ToMessage {
    private List<DataRightAnchorSkinny> dataRightAnchorSkinnys;
    private List<DataRight> dataRights;

    public DataRightResult() {
        this.dataRightAnchorSkinnys = null;
        this.dataRights = null;
    }

    @JsonIgnore
    public DataRightResult(Stream<DataRightAnchor> dataRightAnchorStream) {
        Objects.requireNonNull(dataRightAnchorStream, "DataRightResult::new, parameter \"dataRightAnchorStream\" cannot be null.");
        HashMap dataRightsMap = new HashMap();
        this.dataRightAnchorSkinnys = dataRightAnchorStream.peek(dataRightAnchor -> this.collectUniqueDataRights((DataRightAnchor)dataRightAnchor, dataRightsMap)).map(DataRightAnchorSkinny::new).collect(Collectors.toList());
        this.dataRights = new ArrayList(dataRightsMap.values());
    }

    @JsonIgnore
    private void collectUniqueDataRights(DataRightAnchor dataRightAnchor, Map<String, DataRight> map) {
        DataRight dataRight = dataRightAnchor.getDataRight();
        map.putIfAbsent(dataRight.getClassification(), dataRight);
    }

    @JsonIgnore
    public Map<ArtifactId, DataRightAnchor> getDataRightAnchors() {
        if (Objects.isNull(this.dataRightAnchorSkinnys) || Objects.isNull(this.dataRights)) {
            throw new IllegalStateException("DataRightResult::getDataRightAnchors, member \"dataRightAnchors\" and/or \"dataRights\" has not been set.");
        }
        Map dataRightsMap = this.dataRights.stream().collect(Collectors.toMap(DataRight::getClassification, Function.identity()));
        return Collections.unmodifiableMap(this.dataRightAnchorSkinnys.stream().map(dataRightAnchorSkinny -> new DataRightAnchor((DataRightAnchorSkinny)dataRightAnchorSkinny, dataRightsMap)).collect(Collectors.toMap(DataRightAnchor::getArtifactId, Function.identity())));
    }

    public List<DataRightAnchorSkinny> getDataRightAnchorSkinnys() {
        if (Objects.isNull(this.dataRightAnchorSkinnys)) {
            throw new IllegalStateException("DataRightResult::getDataRightAnchorSkinnys, member \"dataRightAnchorSkinnys\" has not been set.");
        }
        return this.dataRightAnchorSkinnys;
    }

    public List<DataRight> getDataRights() {
        if (Objects.isNull(this.dataRights)) {
            throw new IllegalStateException("DataRightResult::getDataRights, member \"dataRights\" has not been set.");
        }
        return this.dataRights;
    }

    public boolean isValid() {
        return Objects.nonNull(this.dataRightAnchorSkinnys) && this.dataRightAnchorSkinnys.stream().allMatch(DataRightAnchorSkinny::isValid) && Objects.nonNull(this.dataRights) && this.dataRights.stream().allMatch(DataRight::isValid);
    }

    public void setDataRightAnchorSkinnys(List<DataRightAnchorSkinny> dataRightAnchorSkinnys) {
        if (Objects.nonNull(this.dataRightAnchorSkinnys)) {
            throw new IllegalStateException("DataRightResult::setDataRightAnchors, member \"dataRightAnchorSkinnys\" has already been set.");
        }
        this.dataRightAnchorSkinnys = Objects.requireNonNull(dataRightAnchorSkinnys, "DataRightResult::setDataRightAnchorSkinnys, parameter \"dataRightAnchorSkinnys\" cannot be null.");
    }

    public void setDataRights(List<DataRight> dataRights) {
        if (Objects.nonNull(this.dataRights)) {
            throw new IllegalStateException("DataRightResult::setDataRightAnchors, member \"dataRightAnchorSkinnys\" has already been set.");
        }
        this.dataRights = Objects.requireNonNull(dataRights, "DataRightResult::setDataRights, parameter \"dataRights\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Data Right Anchors Result").indentInc().segmentIndexedList((CharSequence)"dataRightAnchorSkinnys", this.dataRightAnchorSkinnys).segmentIndexedList((CharSequence)"dataRights", this.dataRights).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

