/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Objects;

public class InvalidRendererOptionsException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String jsonRendererOptionsString;
    private String publishingTemplateIdentifier;
    private String publishingTemplateName;

    public InvalidRendererOptionsException(String jsonRendererOptionsString) {
        this.jsonRendererOptionsString = jsonRendererOptionsString;
        this.publishingTemplateIdentifier = null;
        this.publishingTemplateName = null;
    }

    public InvalidRendererOptionsException(String jsonRendererOptionsString, Throwable cause) {
        this.initCause(cause);
        this.jsonRendererOptionsString = jsonRendererOptionsString;
        this.publishingTemplateIdentifier = null;
        this.publishingTemplateName = null;
    }

    @Override
    public String getMessage() {
        return InvalidRendererOptionsException.buildMessage(this.jsonRendererOptionsString, this.publishingTemplateIdentifier, this.publishingTemplateName);
    }

    public void setPublishingTemplateInformation(String identifier, String name) {
        this.publishingTemplateIdentifier = identifier;
        this.publishingTemplateName = name;
    }

    public static String buildMessage(String jsonRendererOptionsString, String publishingTemplateIdentifier, String publishingTemplateName) {
        return new StringBuilder(1024).append("\n").append("Invalid JSON Renderer Options string.").append("\n").append("   Publishing Template Identifier: ").append(Objects.nonNull(publishingTemplateIdentifier) ? publishingTemplateIdentifier : "(null)").append("\n").append("   Publishing Template Name:       ").append(Objects.nonNull(publishingTemplateName) ? publishingTemplateName : "(null)").append("\n").append("   JSON Follows:").append("\n").append("\n").append(jsonRendererOptionsString).append("\n").append("\n").toString();
    }
}

