/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class NestedTemplates
implements ToMessage {
    private static final Set<String> keys = Set.of("Id", "Name");
    private static final Set<String> outlineTypes = Set.of("", "APPENDIX");
    @JsonProperty(value="Key")
    private String key;
    @JsonProperty(value="OutlineType")
    private String outlineType;
    @JsonProperty(value="SectionNumber")
    private String sectionNumber;
    @JsonProperty(value="SubDocName")
    private String subDocName;
    @JsonProperty(value="Value")
    private String value;

    private static void validateKey(String key) {
        if (!keys.contains(key)) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"NestedTemplates::validateKey, parameter \"key\" has an invalid value.").indentInc().segment((CharSequence)"Specified Key", (Object)key).segmentIndexedArray((CharSequence)"Allowed Values", keys.toArray()).toString());
        }
    }

    private static void validateOutlineType(String outlineType) {
        if (!outlineTypes.contains(outlineType)) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"NestedTemplates::validateOutlineType, parameter \"outlineType\" has an invalid value.").indentInc().segment((CharSequence)"Specified Outline Type", (Object)outlineType).segmentIndexedArray((CharSequence)"Allowed Values", outlineTypes.toArray()).toString());
        }
    }

    public NestedTemplates() {
        this.outlineType = null;
        this.sectionNumber = null;
        this.subDocName = null;
        this.key = null;
        this.value = null;
    }

    public NestedTemplates(String outlineType, String sectionNumber, String subDocName, String key, String value) {
        Objects.requireNonNull(outlineType, "NestedTemplates::new, parameter \"outlineType\" cannot be null.");
        NestedTemplates.validateOutlineType(outlineType);
        this.outlineType = outlineType;
        this.sectionNumber = Objects.requireNonNull(sectionNumber, "NestedTemplates::new, parameter \"sectionNumber\" cannot be null.");
        this.subDocName = Objects.requireNonNull(subDocName, "NestedTemplates::new, parameter \"subDocName\" cannot be null.");
        Objects.requireNonNull(key, "NestedTemplates::new, parameter \"key\" cannot be null.");
        NestedTemplates.validateKey(key);
        this.key = key;
        this.value = Objects.requireNonNull(value, "NestedTemplates::new, parameter \"value\" cannot be null.");
    }

    public void defaults() {
        if (Objects.isNull(this.outlineType)) {
            this.outlineType = "";
        }
    }

    public String getKey() {
        if (Objects.isNull(this.key)) {
            throw new IllegalStateException("NestedTemplates::getKey, member \"key\" has not been set.");
        }
        return this.key;
    }

    public String getOutlineType() {
        if (Objects.isNull(this.outlineType)) {
            throw new IllegalStateException("NestedTemplates::getOutlineType, member \"outlineType\" has not been set.");
        }
        return this.outlineType;
    }

    public String getSectionNumber() {
        if (Objects.isNull(this.sectionNumber)) {
            throw new IllegalStateException("NestedTemplates::getSectionNumber, member \"sectionNumber\" has not been set.");
        }
        return this.sectionNumber;
    }

    public String getSubDocName() {
        if (Objects.isNull(this.subDocName)) {
            throw new IllegalStateException("NestedTemplates::getSubDocName, member \"subDocName\" has not been set.");
        }
        return this.subDocName;
    }

    public String getValue() {
        if (Objects.isNull(this.outlineType)) {
            throw new IllegalStateException("NestedTemplates::getValue, member \"value\" has not been set.");
        }
        return this.value;
    }

    public boolean isValid() {
        return Objects.nonNull(this.outlineType) && outlineTypes.contains(this.outlineType) && Objects.nonNull(this.sectionNumber) && Objects.nonNull(this.subDocName) && Objects.nonNull(this.key) && keys.contains(this.key) && Objects.nonNull(this.value);
    }

    public void setkey(String key) {
        if (Objects.nonNull(this.key)) {
            throw new IllegalStateException("NestedTemplates::setkey, member \"key\" has already been set.");
        }
        Objects.requireNonNull(key, "NestedTemplates::setkey, parameter \"key\" cannot be null.");
        NestedTemplates.validateKey(key);
        this.key = key;
    }

    public void setOutlineType(String outlineType) {
        if (Objects.nonNull(this.outlineType)) {
            throw new IllegalStateException("NestedTemplates::setOutlineType, member \"outlineType\" has already been set.");
        }
        Objects.requireNonNull(outlineType, "NestedTemplates::setOutlineType, parameter \"outlineType\" cannot be null.");
        NestedTemplates.validateOutlineType(outlineType);
        this.outlineType = outlineType;
    }

    public void setSectionNumber(String sectionNumber) {
        if (Objects.nonNull(this.sectionNumber)) {
            throw new IllegalStateException("NestedTemplates::setSectionNumber, member \"sectionNumber\" has already been set.");
        }
        this.sectionNumber = Objects.requireNonNull(sectionNumber, "NestedTemplates::setSectionNumber, parameter \"sectionNumber\" cannot be null.");
    }

    public void setSubDocName(String subDocName) {
        if (Objects.nonNull(this.subDocName)) {
            throw new IllegalStateException("NestedTemplates::setSubDocName, member \"subDocName\" has already been set.");
        }
        this.subDocName = Objects.requireNonNull(subDocName, "NestedTemplates::setSubDocName, parameter \"subDocName\" cannot be null.");
    }

    public void setValue(String value) {
        if (Objects.nonNull(this.value)) {
            throw new IllegalStateException("NestedTemplates::setvalue, member \"value\" has already been set.");
        }
        this.value = Objects.requireNonNull(value, "NestedTemplates::setvalue, parameter \"value\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"NestedTemplates").indentInc().segment((CharSequence)"Outline Type", (Object)this.outlineType).segment((CharSequence)"Section Number", (Object)this.sectionNumber).segment((CharSequence)"Sub-document Name", (Object)this.subDocName).segment((CharSequence)"Key", (Object)this.key).segment((CharSequence)"Value", (Object)this.value).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

