/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.framework.core.xml.publishing.PublishingXmlUtils;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.w3c.dom.Document;

public class TemplateContent
implements ToMessage {
    private CharSequence templateString;
    @JsonIgnore
    boolean templateStringParsed;
    @JsonIgnore
    Optional<Document> templateXmlOptional;
    @JsonIgnore
    Optional<Exception> templateStringParseErrorOptional;

    public TemplateContent() {
        this.templateString = null;
        this.templateStringParsed = false;
        this.templateXmlOptional = Optional.empty();
        this.templateStringParseErrorOptional = Optional.empty();
    }

    public TemplateContent(CharSequence templateString) {
        this.templateString = Objects.requireNonNull(templateString, "TemplateContent::new, parameter \"templateString\" cannot be null.").toString();
        this.templateStringParsed = false;
        this.templateXmlOptional = Optional.empty();
        this.templateStringParseErrorOptional = Optional.empty();
    }

    @JsonIgnore
    public void defaults() {
        if (Objects.isNull(this.templateString)) {
            this.templateString = "";
        }
    }

    public CharSequence getTemplateString() {
        if (Objects.isNull(this.templateString)) {
            throw new IllegalStateException("TemplateContent::getTemplateString, the member \"templateString\" has not been set.");
        }
        return this.templateString;
    }

    @JsonIgnore
    public Optional<Document> getTemplateXml() {
        if (Objects.isNull(this.templateString)) {
            throw new IllegalStateException("TemplateContent::getTemplateXml, the member \"templateString\" has not been set.");
        }
        if (!this.templateStringParsed) {
            this.parseTemplateString();
        }
        return this.templateXmlOptional;
    }

    @JsonIgnore
    public Optional<Exception> getTemplateXmlParseError() {
        return this.templateStringParseErrorOptional;
    }

    @JsonIgnore
    public boolean isValid() {
        return Objects.nonNull(this.templateString);
    }

    private void parseTemplateString() {
        if (this.templateString.length() > 0) {
            PublishingXmlUtils publishingXmlUtils = new PublishingXmlUtils();
            this.templateXmlOptional = publishingXmlUtils.parse(this.templateString.toString());
            if (publishingXmlUtils.isKo()) {
                this.templateStringParseErrorOptional = publishingXmlUtils.getLastError();
            }
        }
        this.templateStringParsed = true;
    }

    public void setTemplateString(CharSequence templateString) {
        if (Objects.nonNull(this.templateString)) {
            throw new IllegalStateException("TemplateContent::setTemplateString, the member \"templateString\" has already been set.");
        }
        this.templateString = Objects.requireNonNull(templateString, "TemplateContent::setTemplateString, parameter \"templateString\" cannot be null.");
    }

    @JsonIgnore
    void replace(CharSequence templateString) {
        this.templateString = Objects.requireNonNull(templateString, "TemplateContent::replace, parameter \"templateString\" cannot be null.");
    }

    @JsonIgnore
    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Template Content").indentInc().segment((CharSequence)"Template Parsed", (Object)this.templateStringParsed).segment((CharSequence)"XML DOM Available", (Object)this.templateXmlOptional.isPresent()).segment((CharSequence)"Template String", (Object)this.templateString);
        if (this.templateStringParseErrorOptional.isPresent()) {
            outMessage.segment((CharSequence)"XML Parse Error Follows", (Object)this.templateStringParseErrorOptional.get().getMessage());
        }
        outMessage.indentDec();
        return outMessage;
    }

    @JsonIgnore
    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

