/*********************************************************************
* Copyright (c) 2023 Boeing
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* SPDX-License-Identifier: EPL-2.0
*
* Contributors:
*     Boeing - initial API and implementation
**********************************************************************/
 var app = angular.module('WorldApp', ['ngGrid']);
  
function WorldCtrl($scope, $http, $window) {
   
	   $http.get($url).
	      success(function(data) {
	         $scope.items = data;
	         $scope.gridOptions.sortBy('AtsId');
	      }
	   );
                    
   function dateSort(aDate, bDate) {
       var a=new Date(aDate);
       var b=new Date(bDate);
       if (a < b) {
         return -1;
       }
       else if (a > b) {
         return 1;
       }
       else {
         return 0;
       }
   }
	  
	var idCellTmpl = '<button class="btn btn-default btn-sm" ng-enabled="!row.entity.actionLocation" ng-click="openLink(row.entity.actionLocation)">{{row.getProperty(col.field)}}</button>';

   $scope.gridOptions = {
     data: 'items',
     enableHighlighting: true,
     selectedItems: $scope.selectedItems,
     enableColumnResize: true,
     showFilter: true,
		sortInfo: {fields: ['AtsId'], directions: ['asc']},
		columnDefs: [
		     {field: 'AtsId', displayName: 'ATS ID', width: 85, cellTemplate: idCellTmpl},
		     {field: 'TeamName', displayName: 'Team', width: 100},
		     {field: 'Priority', displayName: 'Priority', width: 20},
		     {field: 'ChangeType', displayName: 'Change Type', width: 35},
		     {field: 'State', displayName: 'State', width: 100},
		     {field: 'Name', displayName: 'Title', width: 400}, 
		     {field: 'Assignees', displayName: 'Assignees', width: 100}, 
		     {field: 'CreatedBy', displayName: 'Created By', width: 100}, 
		     {field: 'CreatedDate', displayName: 'Created Date', width: 100}
		     ]
     };
   
	$scope.openLink = function(url) {
		$window.open(url);
	}
	     
}
